/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.users.vars;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiSessionVarDescriptorQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.users.vars.SessionVarsBean;

public class SessionVarsListBean
extends ServletListBean {
    private String mName = "";
    private boolean mPasswordFlag = false;
    private String mValue = "";
    private String[] mIDs = new String[0];
    private String[] mNames = new String[0];
    private String[] mValues = new String[0];
    private boolean[] mPasswordFlags = new boolean[0];
    private String mMode = "";
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private SessionManager mSessionManager = null;
    private static final String STARRED_OUT = "label.sessionVars.starred_out";

    public SessionVarsListBean(SessionManager sessionManager) {
        this.mSessionManager = sessionManager;
    }

    public void setName(String inValue) {
        this.mName = inValue;
    }

    public void setValue(String inValue) {
        this.mValue = inValue;
    }

    public void setPasswordFlag(boolean inValue) {
        this.mPasswordFlag = inValue;
    }

    public void setNames(String[] inValue) {
        this.mNames = inValue;
    }

    public void setValues(String[] inValue) {
        this.mValues = inValue;
    }

    public void setPasswordFlags(boolean[] inValue) {
        this.mPasswordFlags = inValue;
    }

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public String getName() {
        return this.mName;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean getPasswordFlag() {
        return this.mPasswordFlag;
    }

    public String[] getNames() {
        return this.mNames;
    }

    public String[] getValues() {
        return this.mValues;
    }

    public boolean[] getPasswordFlags() {
        return this.mPasswordFlags;
    }

    public String[] getIDs() {
        return this.mIDs;
    }

    public String getMode() {
        return this.mMode;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public void generateList() throws RaplixException {
        SessionVariableSet svs = this.mSessionManager.getSessionVariables();
        svs = svs.purgeNonDescriptorVars();
        this.mSessionManager.setSessionVariables(svs);
        SummarySessionVarDescriptor[] svds = MultiSessionVarDescriptorQuery.all().selectSummaryView();
        this.mIDs = new String[svds.length];
        this.mNames = new String[svds.length];
        this.mValues = new String[svds.length];
        this.mPasswordFlags = new boolean[svds.length];
        for (int i = 0; i < svds.length; ++i) {
            this.mIDs[i] = svds[i].getID().toString();
            this.mNames[i] = svds[i].getName();
            this.mPasswordFlags[i] = svds[i].getSecure();
            SessionVariable sv = svs.getVariable(this.mNames[i]);
            this.mValues[i] = sv == null ? "" : (this.mPasswordFlags[i] ? ApplicationResources.getMessage(STARRED_OUT) : sv.getValue());
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mIDs);
    }

    public void loadSelectedVars(String[] selected) throws RaplixException {
        SessionVarsBean svb = new SessionVarsBean(this.mSessionManager);
        this.mIDs = new String[selected.length];
        this.mNames = new String[selected.length];
        this.mValues = new String[selected.length];
        this.mPasswordFlags = new boolean[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            svb.loadSingleVar(selected[i], true);
            this.mIDs[i] = svb.getID();
            this.mNames[i] = svb.getName();
            this.mValues[i] = svb.getValue();
            this.mPasswordFlags[i] = svb.getPasswordFlag();
        }
    }

    public void deleteSelectedVars(String[] selected) throws RaplixException {
        for (int i = 0; i < selected.length; ++i) {
            SessionVarDescriptorID svdid = new SessionVarDescriptorID(selected[i]);
            SummarySessionVarDescriptor svd = svdid.getByIDQuery().selectSummaryView();
            SessionVariableSet svs = this.mSessionManager.getSessionVariables();
            svs.remove(svd.getName());
            this.mSessionManager.setSessionVariables(svs);
            svdid.delete();
        }
    }
}

