/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.users.vars;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ServerWebUIApplication;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.users.vars.SessionVarsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class SessionVarsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CANCEL = "error.sessionVars.cancel";
    public static final String MSG_ERROR_CREATE = "error.sessionVars.create";
    public static final String MSG_ERROR_DELETE = "error.sessionVars.delete";
    public static final String MSG_ERROR_DETAILS = "error.sessionVars.details";
    public static final String MSG_ERROR_EDIT = "error.sessionVars.edit";
    public static final String MSG_ERROR_REFRESH = "error.sessionVars.refresh";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.sessionVars.save.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = SessionVarsHandleAction.assertGetParam(request, "mode");
        Logger.debug("Coming through SessionVarsHandleAction: " + mode, this);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("delete")) {
            this.handleDelete(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to SessionVarsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        SessionManager sessionManager = this.getApplication().getUserSessionManager();
        boolean allowPersist = true;
        try {
            ServerWebUIApplication app = (ServerWebUIApplication)SessionVarsHandleAction.getApplication();
            UserDBSubsystem userDB = app.getUserDBSubsystem();
            allowPersist = userDB.getConfigSessionVariablePersist();
        }
        catch (ClassCastException cce) {
        }
        catch (ConfigurationException ce) {
            // empty catch block
        }
        SessionVarsBean svb = new SessionVarsBean(sessionManager);
        svb.setAllowPersist(allowPersist);
        return svb;
    }

    public String getDefaultPage() {
        return "/users/vars/sessionVarDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = SessionVarsHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("details")) {
            return MSG_ERROR_DETAILS;
        }
        if (mode.equals("delete")) {
            return MSG_ERROR_DELETE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("refresh")) {
            return MSG_ERROR_REFRESH;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to SessionVarsHandleAction.");
    }

    private void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsBean svb = (SessionVarsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        String passwordFlagStr = request.getParameter("passwordFlag");
        boolean passwordFlag = passwordFlagStr != null && passwordFlagStr.equals("true");
        svb.createVar(name, value, passwordFlag);
        svb.setIsNew(true);
        svb.setMode("edit");
        servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsBean svb = (SessionVarsBean)servletInfo.getBean();
        this.saveRequestValues(svb, request);
        try {
            svb.persist();
        }
        catch (PersistenceManagerException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            svb.setMode("edit");
            servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (UserDBException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(re.getMessage());
            svb.setMode("edit");
            servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/SessionVariables");
        servletInfo.setShouldRedirect(true);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsBean svb = (SessionVarsBean)servletInfo.getBean();
        String id = SessionVarsHandleAction.assertGetParam(request, "id");
        svb.loadSingleVar(id, true);
        svb.setMode("details");
        servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsBean svb = (SessionVarsBean)servletInfo.getBean();
        String id = SessionVarsHandleAction.assertGetParam(request, "id");
        svb.loadSingleVar(id, false);
        svb.setMode("edit");
        if (svb.getPasswordFlag()) {
            svb.setValue("");
        }
        servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsBean svb = (SessionVarsBean)servletInfo.getBean();
        this.saveRequestValues(svb, request);
        svb.setMode("edit");
        servletInfo.setDestPage("/users/vars/sessionVarDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/SessionVariables");
        servletInfo.setShouldRedirect(true);
    }

    private void handleDelete(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/SessionVariables?mode=delete&bulk_size=1&bulk0=" + SessionVarsHandleAction.assertGetParam(request, "id"));
        servletInfo.setShouldRedirect(true);
    }

    private void saveRequestValues(SessionVarsBean svb, HttpServletRequest request) throws RaplixException {
        String name = request.getParameter("name");
        String desc = request.getParameter("description");
        String value = request.getParameter("value");
        String passwordFlagStr = request.getParameter("passwordFlag");
        boolean passwordFlag = passwordFlagStr != null && passwordFlagStr.equals("true");
        String id = request.getParameter("id");
        String updateCount = request.getParameter("updateCount");
        String isNewStr = request.getParameter("isNew");
        boolean isNew = isNewStr != null && isNewStr.equals("true");
        String crPassword = request.getParameter("crpassword");
        svb.setName(name);
        svb.setDescription(desc);
        svb.setValue(value);
        svb.setPasswordFlag(passwordFlag);
        svb.setID(id);
        svb.setUpdateCount(Integer.parseInt(updateCount));
        svb.setIsNew(isNew);
        svb.setCRPassword(crPassword);
    }
}

