/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.users.vars;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptor;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVarDescriptorID;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariable;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionVariableSet;
import com.raplix.rolloutexpress.systemmodel.userdb.SummarySessionVarDescriptor;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ServletBean;

public class SessionVarsBean
extends ServletBean {
    private String mID = "";
    private String mMode = "";
    private boolean mIsNew = false;
    private String mName = "";
    private String mDescription = "";
    private String mValue = "";
    private boolean mPasswordFlag = false;
    private int mUpdateCount = 0;
    private String mCRPassword = "";
    private boolean mAllowPersist = false;
    private SessionManager mSessionManager = null;
    private static final String STARRED_OUT = "label.sessionVars.starred_out";

    public SessionVarsBean(SessionManager sessionManager) {
        this.mSessionManager = sessionManager;
    }

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public void setIsNew(boolean inValue) {
        this.mIsNew = inValue;
    }

    public void setName(String inValue) {
        this.mName = inValue;
    }

    public void setDescription(String inValue) {
        this.mDescription = inValue;
    }

    public void setValue(String inValue) {
        this.mValue = inValue;
    }

    public void setPasswordFlag(boolean inValue) {
        this.mPasswordFlag = inValue;
    }

    public void setUpdateCount(int inValue) {
        this.mUpdateCount = inValue;
    }

    public void setID(String inValue) {
        this.mID = inValue;
    }

    public void setCRPassword(String inValue) {
        this.mCRPassword = inValue;
    }

    public void setAllowPersist(boolean inValue) {
        this.mAllowPersist = inValue;
    }

    public String getID() {
        if (!this.mID.equals("")) {
            return this.mID;
        }
        return super.getID();
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getValue() {
        return this.mValue;
    }

    public boolean getPasswordFlag() {
        return this.mPasswordFlag;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public boolean getAllowPersist() {
        return this.mAllowPersist;
    }

    public void createVar(String name, String value, boolean passwordFlag) throws RaplixException {
        this.mName = name;
        this.mValue = value;
        this.mPasswordFlag = passwordFlag;
        this.mIsNew = true;
        this.mID = "";
    }

    public void loadSingleVar(String id, boolean hidePassword) throws RaplixException {
        SummarySessionVarDescriptor ssvd = new SessionVarDescriptorID(id).getByIDQuery().selectSummaryView();
        this.mID = id;
        this.mIsNew = false;
        this.mPasswordFlag = ssvd.getSecure();
        this.mName = ssvd.getName();
        this.mDescription = ssvd.getDescription();
        this.mUpdateCount = ssvd.getUpdateCount();
        SessionVariableSet svs = this.mSessionManager.getSessionVariables();
        SessionVariable sv = svs.getVariable(this.mName);
        this.mValue = sv == null ? "" : (hidePassword && this.mPasswordFlag ? ApplicationResources.getMessage(STARRED_OUT) : sv.getValue());
    }

    public void persist() throws RaplixException {
        if (this.mAllowPersist) {
            this.mSessionManager.validatePassword(this.mCRPassword);
        }
        SessionVariableSet svs = this.mSessionManager.getSessionVariables();
        svs = svs.purgeNonDescriptorVars();
        this.mSessionManager.setSessionVariables(svs);
        if (this.mIsNew) {
            SessionVarDescriptor svd = new SessionVarDescriptor(this.mName);
            svd.setSecure(this.mPasswordFlag);
            svd.setDescription(this.mDescription);
            svd.save();
        } else {
            SessionVarDescriptor svd = new SessionVarDescriptorID(this.mID).getByIDQuery().select();
            if (!this.mDescription.equals(svd.getDescription())) {
                svd.setDescription(this.mDescription);
                svd.setUpdateCount(this.mUpdateCount);
                svd.save();
            }
        }
        svs.add(new SessionVariable(this.mName, this.mValue, this.mPasswordFlag));
        this.mSessionManager.setSessionVariables(svs);
        if (this.mAllowPersist) {
            this.mSessionManager.saveSessionVariables(this.mCRPassword);
        }
    }
}

