/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.users.vars;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.users.vars.SessionVarsListBean;
import javax.servlet.http.HttpServletRequest;

public class SessionVarsAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String MSG_ERROR = "error.sessionVars.list";
    private static final String MSG_ERROR_DELETE = "error.sessionVars.delete";
    private static final String MSG_ERROR_NO_SELECTION = "error.sessionVars.noselection";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "";
        }
        if (mode.equals("deletefromlist")) {
            this.handleDeleteFromList(request, servletInfo);
        } else if (mode.equals("delete")) {
            this.handleDeleteFromList(request, servletInfo);
        } else if (mode.equals("deleteconfirmed")) {
            this.handleDeleteConfirmed(request, servletInfo);
        } else {
            this.handleList(request, servletInfo);
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        SessionManager sessionManager = this.getApplication().getUserSessionManager();
        SessionVarsListBean svlb = new SessionVarsListBean(sessionManager);
        return svlb;
    }

    public String getDefaultPage() {
        return "/users/vars/sessionVars.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = inRequest.getParameter("mode");
        if (mode.equals("delete")) {
            return MSG_ERROR_DELETE;
        }
        if (mode.equals("deletefromlist")) {
            return MSG_ERROR_DELETE;
        }
        if (mode.equals("deleteconfirmed")) {
            return MSG_ERROR_DELETE;
        }
        return MSG_ERROR;
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        boolean passwordFlag;
        SessionVarsListBean svlb = (SessionVarsListBean)servletInfo.getBean();
        svlb.generateList();
        String name = request.getParameter("name");
        String value = request.getParameter("value");
        String passwordFlagStr = request.getParameter("passwordFlag");
        boolean bl = passwordFlag = passwordFlagStr != null && passwordFlagStr.equals("true");
        if (name != null) {
            svlb.setName(name);
        }
        if (value != null) {
            svlb.setValue(value);
        }
        svlb.setPasswordFlag(passwordFlag);
        servletInfo.setDestPage("/users/vars/sessionVars.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleDeleteFromList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsListBean svlb = (SessionVarsListBean)servletInfo.getBean();
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] selected = in.getSelected();
        if (selected.length == 0) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_DELETE);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
            this.handleList(request, servletInfo);
        } else {
            svlb.loadSelectedVars(selected);
            svlb.setMode(request.getParameter("mode"));
            servletInfo.setDestPage("/users/vars/sessionVarDelConf.jsp");
            servletInfo.setShouldRedirect(false);
            servletInfo.setSaveInSession(false);
        }
    }

    private void handleDeleteConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        SessionVarsListBean svlb = (SessionVarsListBean)servletInfo.getBean();
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] selected = in.getSelected();
        svlb.deleteSelectedVars(selected);
        this.handleList(request, servletInfo);
    }
}

