/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.resources;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.executor.HostsUnpreparedException;
import com.raplix.rolloutexpress.hierarchies.BrowserIncompatibleWithHostException;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.resources.ResourceDetailsBean;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class ResourcesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String RSRC_ERRORMSG_CANCEL = "error.resources.cancel";
    private static final String RSRC_ERRORMSG_CREATE = "error.resources.create";
    private static final String RSRC_ERRORMSG_REFRESH = "error.resources.refresh";
    private static final String RSRC_ERRORMSG_CHECKIN = "error.resources.checkin";
    private static final String RSRC_ERRORMSG_CHECKIN_COMPONENT = "error.resources.checkin.component";
    private static final String RSRC_ERRORMSG_MOVE_CHECKIN = "error.resources.move.checkin";
    private static final String RSRC_ERRORMSG_CHECKIN_CONFIRMED = "error.resources.checkinconfirmed";
    private static final String RSRC_ERRORMSG_CANCEL_CHECKIN_JOBS = "error.resources.checkinjobs.canceljobs";
    private static final String RSRC_ERRORMSG_NOT_EXPORTABLE = "error.resources.notexportable";
    private static final String RSRC_ERRORMSG_NONBROWSABLE_COMPONENTTYPE = "error.resources.nonbrowsablecomponenttype";

    public void doUIAction(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        String mode = ResourcesHandleAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ResourcesHandleAction: " + mode, this);
        }
        if (mode.equals("create")) {
            this.handleCreate(servletInfo, inRequest);
        } else if (mode.equals("cancel")) {
            this.handleCancel(servletInfo, inRequest);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(servletInfo, inRequest);
        } else if (mode.equals("checkin")) {
            this.handleCheckin(servletInfo, inRequest);
        } else if (mode.equals("movecheckin")) {
            this.handleMoveCheckin(servletInfo, inRequest);
        } else if (mode.equals("checkinconfirmed")) {
            this.handleCheckinConfirmed(servletInfo, inRequest);
        } else if (mode.equals("checkincancel")) {
            this.handleCheckinCancel(servletInfo, inRequest);
        } else if (mode.equals("componentcheckinnew")) {
            this.handleComponentCheckinNew(servletInfo, inRequest);
        } else if (mode.equals("componentcheckinnewversion")) {
            this.handleComponentCheckinNewVersion(servletInfo, inRequest);
        } else if (mode.equals("checkinnewversion")) {
            this.handleCheckinNewVersion(servletInfo, inRequest);
        } else if (mode.equals("prepare")) {
            this.handleCheckinProgress(servletInfo, inRequest);
        } else if (mode.equals("cancelcheckinjobs")) {
            this.handleProgressCancel(servletInfo, inRequest);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    private void handleCreate(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String name = ResourcesHandleAction.assertGetParam(request, "name");
        String componentType = ResourcesHandleAction.assertGetParam(request, "componentType");
        String label = ResourcesHandleAction.assertGetParam(request, "label");
        String description = ResourcesHandleAction.assertGetParam(request, "description");
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.getString(Preference.FILE_PATH);
        if (name.equals("")) {
            bean.setIsNameAutofill(true);
        }
        bean.createResource(name, folderID, componentType, label, description);
        bean.setIsNew(true);
        this.initBrowseFieldsFromSession(request, servletInfo, componentType);
        try {
            bean.loadBrowserNode();
        }
        catch (BrowserIncompatibleWithHostException biwhe) {
            if (Logger.isDebugEnabled(this)) {
                biwhe.printStackTrace();
            }
            bean.clearBrowserNodeFields();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_CREATE);
            servletInfo.getErrors().addMinorError(re);
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        bean.closeBrowserNode();
        String destPage = "/Components";
        if (bean.getComponentMode().equals("componentcheckinnewversion")) {
            destPage = UriUtil.componentReturnURI(bean.getContainerCompID());
        } else if (bean.getComponentMode().equals("componentcheckinnew")) {
            destPage = UriUtil.componentReturnURI(bean.getContainerCompID());
        } else if (bean.getComponentMode().equals("checkinnewversion")) {
            destPage = UriUtil.componentDetailsURI(bean.getComponentID());
        }
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRefresh(ServletInfo servletInfo, HttpServletRequest request) {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String name = ResourcesHandleAction.assertGetParam(request, "name");
        String componentType = ResourcesHandleAction.assertGetParam(request, "componentType");
        String family = ResourcesHandleAction.assertGetParam(request, "family");
        String platform = ResourcesHandleAction.assertGetParam(request, "platformID");
        String label = ResourcesHandleAction.assertGetParam(request, "label");
        String description = ResourcesHandleAction.assertGetParam(request, "description");
        String browserName = ResourcesHandleAction.assertGetParam(request, "browserName");
        String filterName = StringUtil.normalizeEmpty(request.getParameter("filterName"));
        this.preserveBrowseHostAndPath(request, servletInfo);
        int familyID = Integer.parseInt(family);
        if (familyID == 1) {
            componentType = bean.getComponentType();
        } else if (!ComponentTypesListBean.isBrowsableComponentType(componentType)) {
            String routerURI = UriUtil.componentTypeRouterURI(Util.encodeURL(componentType), family, Util.encodeURL(name), Util.encodeURL(label), Util.encodeURL(description));
            servletInfo.setDestPage(routerURI);
            servletInfo.setShouldRedirect(true);
            return;
        }
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        bean.setName(name);
        bean.setComponentType(componentType);
        spb.setString(Preference.BROWSE_COMPONENT_TYPE, componentType);
        bean.setComponentPlatform(platform);
        bean.setLabel(label);
        bean.setDescription(description);
        bean.setMode("refresh");
        bean.setBrowserName(browserName);
        bean.setFilterName(filterName);
        boolean browseUp = "true".equals(request.getParameter("browseUp"));
        try {
            bean.refreshBrowserNode(browseUp);
            ResourcesHandleAction.loadOptions(request, bean);
        }
        catch (BrowserIncompatibleWithHostException biwhe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Browser Type ('" + bean.getComponentType() + "') Incompatible With Host ('" + bean.getBrowseHost() + "')!", this);
            }
            bean.clearBrowserNodeFields();
        }
        catch (RaplixException re) {
            if (re instanceof HostsUnpreparedException) {
                HostIDSet his = ((HostsUnpreparedException)re).getUnpreppedHostSet();
                ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
                ssb.put("session.hostidset", his);
                bean.setPreparePopupNeeded(true);
            }
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_REFRESH);
            servletInfo.getErrors().addMinorError(re);
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckin(ServletInfo servletInfo, HttpServletRequest request) {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String name = ResourcesHandleAction.assertGetParam(request, "name");
        String componentType = ResourcesHandleAction.assertGetParam(request, "componentType");
        String platform = ResourcesHandleAction.assertGetParam(request, "platformID");
        String label = ResourcesHandleAction.assertGetParam(request, "label");
        String description = ResourcesHandleAction.assertGetParam(request, "description");
        bean.setName(name);
        bean.setComponentType(componentType);
        bean.setComponentPlatform(platform);
        bean.setLabel(label);
        bean.setDescription(description);
        bean.setMode("checkin");
        bean.setIsMajorVersion(false);
        bean.setIsHidingPrevious(true);
        this.preserveBrowseHostAndPath(request, servletInfo);
        try {
            bean.refreshBrowserNode(false);
            ResourcesHandleAction.loadOptions(request, bean);
            if (!bean.getIsExportable()) {
                bean.refreshBrowserNode(true);
                servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_CHECKIN);
                servletInfo.getErrors().addMinorErrorKey(RSRC_ERRORMSG_NOT_EXPORTABLE);
                servletInfo.setDestPage("/resources/resourceEdit.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
            bean.prepareForCheckin();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_CHECKIN);
            servletInfo.getErrors().addMinorError(re.toString());
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/resources/resourceCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMoveCheckin(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String name = ResourcesHandleAction.assertGetParam(request, "name");
        String folderID = ResourcesHandleAction.assertGetParam(request, "resourcePath");
        bean.setName(name);
        bean.setFolderID(folderID);
        servletInfo.setDestPage("/resources/resourceCheckin.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckinConfirmed(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String folderID = request.getParameter("resourcePath");
        String majorVersion = request.getParameter("isMajorVersion");
        String isHidingPrevious = request.getParameter("isHidingPrevious");
        if (name != null) {
            bean.setName(name);
        }
        if (folderID != null) {
            bean.setFolderID(folderID);
        }
        bean.setIsMajorVersion("true".equals(majorVersion));
        bean.setIsHidingPrevious(isHidingPrevious != null);
        try {
            bean.refreshBrowserNode(false);
            bean.checkinResource();
        }
        catch (RaplixException re) {
            this.handleExceptionInCheckin(servletInfo, re);
            return;
        }
        catch (AccessControlException ace) {
            this.handleExceptionInCheckin(servletInfo, ace);
            return;
        }
        this.updateFilePath(request, servletInfo);
        bean.setMode("prepare");
        servletInfo.setDestPage("/resources/resourceCheckinProg.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckinCancel(ServletInfo servletInfo, HttpServletRequest request) {
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleProgressCancel(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        if (bean.isPending()) {
            bean.cancelCheckIn();
            this.handleCancel(servletInfo, request);
            return;
        }
        this.handleCheckinProgress(servletInfo, request);
    }

    private void handleComponentCheckinNew(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String componentID = ResourcesHandleAction.assertGetParam(request, "componentID");
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String folderID = spb.getString(Preference.FILE_PATH);
        String name = "";
        String componentType = ResourcesHandleAction.assertGetParam(request, "selectedresourcetype");
        String typeFamily = ResourcesHandleAction.assertGetParam(request, "family");
        String typeFixed = ResourcesHandleAction.assertGetParam(request, "typeFixed");
        String platform = ResourcesHandleAction.assertGetParam(request, "selectedplatform");
        String label = "";
        String description = "";
        int family = Integer.parseInt(typeFamily);
        if (family == 1) {
            componentType = "system#file";
        } else if (!ComponentTypesListBean.isBrowsableComponentType(componentType)) {
            String errorURI = UriUtil.componentEditBrowseErrorURI(componentID, RSRC_ERRORMSG_NONBROWSABLE_COMPONENTTYPE, Util.encodeURL(componentType));
            servletInfo.setDestPage(errorURI);
            servletInfo.setShouldRedirect(true);
            return;
        }
        bean.createResource(name, folderID, componentType, label, description);
        bean.setComponentPlatform(platform);
        bean.setIsNew(true);
        bean.setIsNameAutofill(true);
        bean.setIsTypeFixed(typeFixed.equals("true"));
        bean.setComponentMode("componentcheckinnew");
        bean.loadComponentTypeInfo();
        bean.setContainerCompID(componentID);
        this.initBrowseFieldsFromSession(request, servletInfo, componentType);
        try {
            bean.loadBrowserNode();
        }
        catch (BrowserIncompatibleWithHostException biwhe) {
            bean.clearBrowserNodeFields();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_CREATE);
            servletInfo.getErrors().addMinorError(re);
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleComponentCheckinNewVersion(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String parentCompID = ResourcesHandleAction.assertGetParam(request, "componentID");
        String componentID = ResourcesHandleAction.assertGetParam(request, "resourceID");
        String slot = ResourcesHandleAction.assertGetParam(request, "index");
        bean.setContainerCompID(parentCompID);
        bean.setComponentID(componentID);
        bean.setComponentSlot(slot);
        bean.loadComponentDetails(componentID);
        bean.setIsTypeFixed(true);
        try {
            bean.loadBrowserNode();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_REFRESH);
            servletInfo.getErrors().addMinorError(re);
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.setComponentMode("componentcheckinnewversion");
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCheckinNewVersion(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        String componentID = ResourcesHandleAction.assertGetParam(request, "componentID");
        bean.setComponentID(componentID);
        bean.loadComponentDetails(componentID);
        bean.setIsTypeFixed(true);
        try {
            bean.loadBrowserNode();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_REFRESH);
            servletInfo.getErrors().addMinorError(re);
            servletInfo.setDestPage("/resources/resourceEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.setComponentMode("checkinnewversion");
        servletInfo.setDestPage("/resources/resourceEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleCheckinProgress(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceDetailsBean bean = (ResourceDetailsBean)servletInfo.getBean();
        if (bean.isPending()) {
            bean.setMode("prepare");
            servletInfo.setDestPage("/resources/resourceCheckinProg.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String checkInMode = bean.getComponentMode();
        String parentComponentID = bean.getContainerCompID();
        String destPage = "/Components";
        if (bean.getCompStatus() instanceof CompError) {
            CompError error = (CompError)bean.getCompStatus();
            Exception exception = error.getExceptions()[0];
            if (!checkInMode.equals("componentcheckinnew") && !checkInMode.equals("componentcheckinnewversion")) {
                this.handleExceptionInCheckin(servletInfo, exception);
                return;
            }
            destPage = UriUtil.componentEditBrowseErrorURI(parentComponentID, RSRC_ERRORMSG_CHECKIN_COMPONENT, Util.encodeURL(bean.getComponentName()));
            bean.closeBrowserNode();
        } else {
            if (bean.getComponentMode().equals("componentcheckinnew")) {
                String childComponentID = bean.getCompletedCheckinCompID();
                destPage = UriUtil.componentVariableDefaultsURI(parentComponentID, childComponentID, "", "componentcheckinnew");
            } else if (bean.getComponentMode().equals("componentcheckinnewversion")) {
                String childComponentID = bean.getCompletedCheckinCompID();
                destPage = UriUtil.componentVariableDefaultsURI(parentComponentID, childComponentID, bean.getComponentSlot(), "componentcheckinnewversion");
            } else if (bean.getComponentMode().equals("checkinnewversion")) {
                destPage = "/Components";
            }
            bean.closeBrowserNode();
        }
        servletInfo.setDestPage(destPage);
        servletInfo.setShouldRedirect(true);
    }

    private void handleExceptionInCheckin(ServletInfo servletInfo, Exception ex) {
        servletInfo.setDestPage("/resources/resourceCheckin.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.getErrors().setMajorErrorKey(RSRC_ERRORMSG_CHECKIN_CONFIRMED);
        if (!(ex instanceof AccessControlException)) {
            servletInfo.getErrors().addMinorError(ex.getMessage());
        } else {
            servletInfo.getErrors().addMinorError(this.ACExToString((AccessControlException)ex));
        }
    }

    private static void loadOptions(HttpServletRequest request, ResourceDetailsBean bean) {
        String[] options = bean.getOptionNames();
        String[] modes = bean.getOptionDisplayModes();
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            String val = request.getParameter(option);
            if (modes.equals("checkbox")) {
                if (val != null) {
                    bean.setOptionValue(option, val);
                    continue;
                }
                bean.setOptionValue(option, "false");
                continue;
            }
            bean.setOptionValue(option, val);
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        String mode = ResourcesHandleAction.assertGetParam(request, "mode");
        ResourceDetailsBean rdb = null;
        if (mode.equals("details") || mode.equals("create") || mode.equals("componentcheckinnew") || mode.equals("componentcheckinnewversion") || mode.equals("checkinnewversion") || mode.equals("edit")) {
            rdb = new ResourceDetailsBean(ResourcesHandleAction.getApplication().getResourceSubsystem(), ResourcesHandleAction.getApplication().getUserManager());
        } else {
            String id = request.getParameter("id");
            rdb = (ResourceDetailsBean)request.getSession().getAttribute(id);
            if (rdb == null) {
                throw new IllegalArgumentException("Expected Bean not found.");
            }
        }
        return rdb;
    }

    public String getDefaultPage() {
        return "/resources/resourceEdit.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = ResourcesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("create")) {
            return RSRC_ERRORMSG_CREATE;
        }
        if (mode.equals("cancel")) {
            return RSRC_ERRORMSG_CANCEL;
        }
        if (mode.equals("componentcheckinnew")) {
            return RSRC_ERRORMSG_CREATE;
        }
        if (mode.equals("componentcheckinnewversion")) {
            return RSRC_ERRORMSG_CREATE;
        }
        if (mode.equals("checkinnewversion")) {
            return RSRC_ERRORMSG_CREATE;
        }
        if (mode.equals("refresh")) {
            return RSRC_ERRORMSG_REFRESH;
        }
        if (mode.equals("checkin")) {
            return RSRC_ERRORMSG_CHECKIN;
        }
        if (mode.equals("checkincancel")) {
            return RSRC_ERRORMSG_CHECKIN;
        }
        if (mode.equals("movecheckin")) {
            return RSRC_ERRORMSG_MOVE_CHECKIN;
        }
        if (mode.equals("checkinconfirmed")) {
            return RSRC_ERRORMSG_CHECKIN_CONFIRMED;
        }
        if (mode.equals("prepare")) {
            return RSRC_ERRORMSG_CHECKIN_CONFIRMED;
        }
        if (mode.equals("cancelcheckinjobs")) {
            return RSRC_ERRORMSG_CANCEL_CHECKIN_JOBS;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ")  passed to ResourcesHandleAction.");
    }

    private void updateFilePath(HttpServletRequest request, ServletInfo servletInfo) {
        ResourceDetailsBean rdb = (ResourceDetailsBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String filePath = ChangePathBean.verifyFolderID(rdb.getFolderID());
        spb.setString(Preference.FILE_PATH, filePath);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("updateFilePath:  path is now " + filePath, this);
        }
    }

    private void initBrowseFieldsFromSession(HttpServletRequest request, ServletInfo servletInfo, String componentType) {
        ResourceDetailsBean rdb = (ResourceDetailsBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String browseHost = spb.trackString(Preference.BROWSE_HOST, request);
        String browseDirectory = spb.trackString(Preference.BROWSE_DIRECTORY, request);
        String cachedComponentType = spb.getString(Preference.BROWSE_COMPONENT_TYPE);
        if (!cachedComponentType.equals(componentType)) {
            browseDirectory = "";
            spb.setString(Preference.BROWSE_DIRECTORY, browseDirectory);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("browseHost is: " + browseHost + " and browseDirectory is: " + browseDirectory, this);
        }
        rdb.setBrowseHost(browseHost);
        rdb.setBrowsePath(browseDirectory);
        rdb.setBrowseDirectory(browseDirectory);
    }

    private void preserveBrowseHostAndPath(HttpServletRequest request, ServletInfo servletInfo) {
        ResourceDetailsBean rdb = (ResourceDetailsBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String browseHost = spb.trackString(Preference.BROWSE_HOST, request);
        String browseDirectory = spb.trackString(Preference.BROWSE_DIRECTORY, request);
        String browsePath = ResourcesHandleAction.assertGetParam(request, "browsePath");
        rdb.setBrowseHost(browseHost);
        rdb.setBrowsePath(browsePath);
        rdb.setBrowseDirectory(browseDirectory);
    }
}

