/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.resources;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.checkInJob.ResourceDescriptor;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.resource.packageformat.ResourceAccessor;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.RsrcManifest;
import com.raplix.rolloutexpress.resource.packageformat.SizedStream;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.resources.ResourceDetailsBean;
import com.raplix.util.logger.Logger;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceDownloadAction
extends LoggedOnServlet {
    public static final String PARAM_MODE = "mode";
    public static final String PARAM_RESOURCE_ID = "id";
    public static final String PARAM_MODE_DOWNLOAD = "download";
    private static final String PARAM_MODE_FILENAME_ADDED_DOWNLOAD = "filenameaddeddownload";
    private static final String PARAM_MODE_FILENAME_ADDED_TOC_DOWNLOAD = "filenameaddedtocdownload";
    public static final String MSG_ERROR_MAJOR = "error.resources.download";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        block6: {
            String mode = request.getParameter(PARAM_MODE);
            String id = ResourceDownloadAction.assertGetParam(request, PARAM_RESOURCE_ID);
            try {
                final HttpServletResponse tResponse = response;
                final ResourceID tResourceID = new ResourceID(id);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("trying to retrieve resource with id:" + id, this);
                }
                ResourceSubsystem tmpResourceSubsystem = ResourceDownloadAction.getApplication().getResourceSubsystem();
                final RsrcInfo resourceInfo = tmpResourceSubsystem.getRsrcInfo(tResourceID, null);
                if (mode != null && mode.equals(PARAM_MODE_FILENAME_ADDED_DOWNLOAD)) {
                    new ResourceAccessor(tmpResourceSubsystem){

                        public Object innerAccess() throws ResourceException {
                            RsrcManifest theManifest = this.getManifest(tResourceID, null);
                            long resSize = -1L;
                            try {
                                InputStream tInstream = null;
                                if (resourceInfo.getHierarchical()) {
                                    SizedStream theSizedZipStream = this.getZippedStream(tResourceID);
                                    tInstream = theSizedZipStream.getInputStream();
                                    resSize = theSizedZipStream.getSize();
                                } else {
                                    ResourceEntry theEntry = theManifest.getEntryIterator().next();
                                    tInstream = theManifest.getInputStream(theEntry);
                                    resSize = theEntry.getSize();
                                }
                                tResponse.setContentLength((int)resSize);
                                tResponse.setContentType("application/octet-stream; charset=UTF-8");
                                ResourceDownloadAction.this.sendInputStreamToOutputStream(tInstream, (OutputStream)tResponse.getOutputStream());
                            }
                            catch (IOException ioe) {
                                Logger.debug("Exception caught in ResourceDownload: " + ioe.getMessage(), ioe, this);
                            }
                            return null;
                        }
                    }.access();
                    break block6;
                }
                if (mode != null && mode.equals(PARAM_MODE_FILENAME_ADDED_TOC_DOWNLOAD)) {
                    new ResourceAccessor(tmpResourceSubsystem){

                        public Object innerAccess() throws ResourceException {
                            try {
                                tResponse.setContentType("application/octet-stream; charset=UTF-8");
                                ResourceDescriptor rd = ResourceDescriptor.getResourceDescriptor(tResourceID);
                                rd.writeToXML((OutputStream)tResponse.getOutputStream());
                            }
                            catch (PersistenceManagerException ioe) {
                                Logger.debug("Exception caught in ResourceDownload: " + ioe.getMessage(), ioe, this);
                            }
                            catch (RPCException ioe) {
                                Logger.debug("Exception caught in ResourceDownload: " + ioe.getMessage(), ioe, this);
                            }
                            catch (IOException ioe) {
                                Logger.debug("Exception caught in ResourceDownload: " + ioe.getMessage(), ioe, this);
                            }
                            return null;
                        }
                    }.access();
                    break block6;
                }
                boolean isZipFile = resourceInfo.getHierarchical();
                String extension = isZipFile ? ".zip" : "";
                String theFileName = Util.encodeURL(ResourceStringUtils.getURLFileName(ResourceDetailsBean.getResourceName(resourceInfo.getResourceSpec())));
                String resourcename = theFileName + extension;
                if (mode != null && mode.equals("tocdownload")) {
                    String redirectAddress = "/ResourceDownload/" + theFileName + "_descriptor" + ".xml" + "?" + PARAM_RESOURCE_ID + "=" + id + "&" + PARAM_MODE + "=" + PARAM_MODE_FILENAME_ADDED_TOC_DOWNLOAD;
                    response.sendRedirect(redirectAddress);
                    return;
                }
                String redirectAddress = "/ResourceDownload/" + resourcename + "?" + PARAM_RESOURCE_ID + "=" + id + "&" + PARAM_MODE + "=" + PARAM_MODE_FILENAME_ADDED_DOWNLOAD;
                response.sendRedirect(redirectAddress);
                return;
            }
            catch (RaplixException e) {
                ServletErrors errors = new ServletErrors();
                Logger.debug("Exception caught in ResourceDownload: " + e.getMessage(), e, this);
                errors.setMajorErrorKey(MSG_ERROR_MAJOR);
                errors.addMinorError(e.getMessage());
                request.setAttribute("error.location", (Object)errors);
                this.forwardRequest(request, response, "/errorhome.jsp");
            }
        }
    }

    private void sendInputStreamToOutputStream(InputStream in, OutputStream out) throws IOException {
        int BUFFER_SIZE = 64000;
        BufferedInputStream bInputStream = new BufferedInputStream(in);
        byte[] buf = new byte[BUFFER_SIZE];
        int read_len = 0;
        while (read_len != -1) {
            read_len = bInputStream.read(buf);
            if (read_len >= 0) {
                out.write(buf, 0, read_len);
            }
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("sendInputStreamToWriter, buf=" + buf, this);
        }
    }
}

