/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.resources;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.hierarchies.BrowserIncompatibleWithHostException;
import com.raplix.rolloutexpress.hierarchies.BrowserNode;
import com.raplix.rolloutexpress.hierarchies.HierarchyBrowserSubsystem;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ExportContext;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.ResourceSpec;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.packageformat.NodePerms;
import com.raplix.rolloutexpress.resource.packageformat.PosixNodePerms;
import com.raplix.rolloutexpress.resource.packageformat.ResourceEntry;
import com.raplix.rolloutexpress.resource.packageformat.SubnodeType;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSaveContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.userdb.UserManager;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.memix.filesystem.Mask;
import com.raplix.util.string.StringUtil;
import com.sun.n1.sps.plugin.browse.BrowserFilter;
import com.sun.n1.sps.plugin.browse.BrowserInfo;
import com.sun.n1.util.vars.DisplayMode;
import com.sun.n1.util.vars.PromptParam;
import com.sun.n1.util.vars.PromptParamList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class ResourceDetailsBean
extends ServletBean {
    private final UserManager mUserDBInterface;
    private final ResourceSubsystem mResourceManager;
    private static final CompCheckInServices sCompCheckInServices = CompCheckInServices.INSTANCE;
    private static final ComponentExportServices sComponentExportServices = ComponentExportServices.INSTANCE;
    private String mResourceID = "";
    private String mComponentID = "";
    private String mComponentSlot = "";
    private String mContainerCompID = "";
    private String mComponentName = "";
    private String mComponentFullName = "";
    private String mComponentFolderID = "";
    private String mComponentFolderPath = "";
    private String mComponentType = "";
    private String mComponentVersion = "";
    private String mComponentPlatform = "";
    private String mComponentDesc = "";
    private String mComponentLabel = "";
    private String mComponentCheckInDate = "";
    private String mComponentCheckInUser = "";
    private SourceInfo mComponentSourceInfo = null;
    private String mFileSystemUserName = "";
    private String mFileSystemGroupName = "";
    private String mFileSystemPerms = "";
    private String mFileSystemName = "";
    private String mFileSystemSize = "";
    private String mFileSystemLastModified = "";
    private boolean mFileSystemWasPosix = false;
    private String mBrowseHost = "";
    private String mBrowsePath = "";
    private String mBrowseDirectory = "";
    private String mFilterName = "";
    private String mBrowserName = "";
    private String[] mChildLocalNames = new String[0];
    private String[] mChildDisplayNames = new String[0];
    private String[] mChildFullNames = new String[0];
    private String[] mFilterNames = new String[0];
    private String[] mFilterDescriptions = new String[0];
    private String[] mOptionNames = new String[0];
    private String[] mOptionDescriptions = new String[0];
    private String[] mOptionDisplayModes = new String[0];
    private String[] mBrowserNames = new String[0];
    private String[] mHostSetNames = new String[0];
    private boolean mHostSetLimited = false;
    private boolean mIsRootNode = false;
    private boolean mIsExportable = false;
    private boolean mPreparePopupNeeded = false;
    private BrowserInfo mBrowserInfo = null;
    private BrowserNode mBrowserNode = null;
    private BrowserInfo[] mAvailableBrowsers = new BrowserInfo[0];
    private HashMap mOptions = new HashMap();
    private CompCheckInID mCompCheckInID = null;
    private boolean mIsNew = false;
    private boolean mIsNameAutofill = false;
    private boolean mIsTypeFixed = false;
    private boolean mIsMajorVersion = false;
    private boolean mIsHidingPrevious = true;
    private String mNextMajorVersion = "";
    private String mNextMinorVersion = "";
    private String mLatestVersion = "";
    private String mMode = "";
    private String mComponentMode = "";
    private String mPreviousName = "";
    private String mPreviousVersion = "";
    private String mReferrerURL = "";
    private String[] mComponentTypes = new String[0];
    private String[] mPlatformNames = new String[0];
    private String[] mPlatformIDs = new String[0];
    private ComponentTypesListBean mComponentTypesListBean = null;

    public ResourceDetailsBean(ResourceSubsystem resourceMgr, UserManager userDBInterface) {
        this.mUserDBInterface = userDBInterface;
        this.mResourceManager = resourceMgr;
    }

    public String getID() {
        if (this.mResourceID != null && !this.mResourceID.equals("")) {
            return this.mResourceID;
        }
        return super.getID();
    }

    public String getResourceID() {
        return this.mResourceID;
    }

    public String getResourceName() {
        return this.mComponentName;
    }

    public String getResourceFullName() {
        return this.mComponentFullName;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getComponentSlot() {
        return this.mComponentSlot;
    }

    public String getContainerCompID() {
        return this.mContainerCompID;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getFolderID() {
        return this.mComponentFolderID;
    }

    public String getFolderPath() {
        return this.mComponentFolderPath;
    }

    public String getDescription() {
        return this.mComponentDesc;
    }

    public String getLabel() {
        return this.mComponentLabel;
    }

    public String getComponentMode() {
        return this.mComponentMode;
    }

    public String getVersion() {
        return this.mComponentVersion;
    }

    public String getCheckedInBy() {
        return this.mComponentCheckInUser;
    }

    public String getCheckedInDate() {
        return this.mComponentCheckInDate;
    }

    public String getFileSystemUserName() {
        return this.mFileSystemUserName;
    }

    public String getFileSystemGroupName() {
        return this.mFileSystemGroupName;
    }

    public String getFileSystemPerms() {
        return this.mFileSystemPerms;
    }

    public String getFileSystemName() {
        return this.mFileSystemName;
    }

    public String getFileSystemSize() {
        return this.mFileSystemSize;
    }

    public String getFileSystemLastModified() {
        return this.mFileSystemLastModified;
    }

    public boolean getFileSystemWasPosix() {
        return this.mFileSystemWasPosix;
    }

    public void setResourceID(String id) {
        this.mResourceID = id;
    }

    public void setName(String resourceName) {
        this.mComponentName = resourceName;
    }

    public void setDescription(String description) {
        this.mComponentDesc = description;
    }

    public void setLabel(String label) {
        this.mComponentLabel = label;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getIsNameAutofill() {
        return this.mIsNameAutofill;
    }

    public boolean getIsTypeFixed() {
        return this.mIsTypeFixed;
    }

    public boolean getIsMajorVersion() {
        return this.mIsMajorVersion;
    }

    public boolean getIsHidingPrevious() {
        return this.mIsHidingPrevious;
    }

    public String getNextMinorVersion() {
        return this.mNextMinorVersion;
    }

    public String getNextMajorVersion() {
        return this.mNextMajorVersion;
    }

    public String getMode() {
        return this.mMode;
    }

    public String getPreviousName() {
        return this.mPreviousName;
    }

    public String getPreviousVersion() {
        return this.mPreviousVersion;
    }

    public String getReferrerURL() {
        return this.mReferrerURL;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setIsNameAutofill(boolean ina) {
        this.mIsNameAutofill = ina;
    }

    public void setIsTypeFixed(boolean itf) {
        this.mIsTypeFixed = itf;
    }

    public void setIsMajorVersion(boolean imv) {
        this.mIsMajorVersion = imv;
    }

    public void setIsHidingPrevious(boolean ihp) {
        this.mIsHidingPrevious = ihp;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setComponentMode(String mode) {
        this.mComponentMode = mode;
    }

    public void setComponentID(String id) {
        this.mComponentID = id;
    }

    public void setComponentSlot(String slot) {
        this.mComponentSlot = slot;
    }

    public void setContainerCompID(String id) {
        this.mContainerCompID = id;
    }

    public void setReferrerURL(String url) {
        this.mReferrerURL = url;
    }

    public String getComponentType() {
        return this.mComponentType;
    }

    public String getComponentPlatform() {
        return this.mComponentPlatform;
    }

    public String getBrowseHost() {
        return this.mBrowseHost;
    }

    public String getBrowsePath() {
        return this.mBrowsePath;
    }

    public String getBrowseDirectory() {
        return this.mBrowseDirectory;
    }

    public String getFilterName() {
        return this.mFilterName;
    }

    public String getBrowserName() {
        return this.mBrowserName;
    }

    public String[] getChildLocalNames() {
        return this.mChildLocalNames;
    }

    public String[] getChildDisplayNames() {
        return this.mChildDisplayNames;
    }

    public String[] getChildFullNames() {
        return this.mChildFullNames;
    }

    public String[] getFilterNames() {
        return this.mFilterNames;
    }

    public String[] getFilterDescriptions() {
        return this.mFilterDescriptions;
    }

    public String[] getOptionNames() {
        return this.mOptionNames;
    }

    public String[] getOptionDescriptions() {
        return this.mOptionDescriptions;
    }

    public String[] getOptionDisplayModes() {
        return this.mOptionDisplayModes;
    }

    public String[] getBrowserNames() {
        return this.mBrowserNames;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public boolean getHostSetLimited() {
        return this.mHostSetLimited;
    }

    public boolean getIsRootNode() {
        return this.mIsRootNode;
    }

    public boolean getIsExportable() {
        return this.mIsExportable;
    }

    public boolean getPreparePopupNeeded() {
        return this.mPreparePopupNeeded;
    }

    public CompStatus getCompStatus() throws RaplixException {
        return sCompCheckInServices.getStatus(this.mCompCheckInID);
    }

    public void setComponentType(String type) {
        this.mComponentType = type;
    }

    public void setComponentPlatform(String platform) {
        this.mComponentPlatform = platform;
    }

    public void setBrowseHost(String hostName) {
        this.mBrowseHost = hostName;
    }

    public void setBrowsePath(String pathName) {
        this.mBrowsePath = pathName;
    }

    public void setBrowseDirectory(String pathName) {
        this.mBrowseDirectory = pathName;
    }

    public void setFilterName(String filterName) {
        this.mFilterName = filterName;
    }

    public void setBrowserName(String name) {
        this.mBrowserName = name;
    }

    public void setIsRootNode(boolean isRoot) {
        this.mIsRootNode = isRoot;
    }

    public void setIsExportable(boolean ie) {
        this.mIsExportable = ie;
    }

    public void setPreparePopupNeeded(boolean ip) {
        this.mPreparePopupNeeded = ip;
    }

    public String getOptionValue(String name) {
        String value = "";
        if (this.mOptions.containsKey(name)) {
            value = (String)this.mOptions.get(name);
        }
        return value;
    }

    public void setOptionValue(String name, String val) {
        this.mOptions.put(name, val);
    }

    public void setFolderID(String folderID) throws RaplixException {
        this.mComponentFolderID = folderID;
        this.mComponentFolderPath = ChangePathBean.folderIDtoFilePath(this.mComponentFolderID);
    }

    public String[] getComponentTypes() {
        return this.mComponentTypes;
    }

    public String[] getPlatformNames() {
        return this.mPlatformNames;
    }

    public String[] getPlatformIDs() {
        return this.mPlatformIDs;
    }

    public ComponentTypesListBean getComponentTypesListBean() {
        return this.mComponentTypesListBean;
    }

    public static String getResourceName(ResourceSpec spec) {
        return spec.getName();
    }

    public void loadResourceDetails(String id) throws RaplixException {
        this.mResourceID = id;
        this.generateResourceOutputFields();
    }

    public void loadComponentDetails(String id) throws RaplixException {
        this.mComponentID = id;
        this.generateComponentFields();
    }

    public void prepareForCheckin() throws RaplixException {
        if (this.mIsNew) {
            this.mPreviousName = "";
            this.mPreviousVersion = "";
        } else {
            ComponentID componentID = new ComponentID(this.mComponentID);
            SummaryComponent component = componentID.getByIDQuery().selectSummaryView();
            try {
                SingleComponentQuery scq = SingleComponentQuery.byName(component.getPath(), component.getName(), null);
                component = scq.selectSummaryView();
                this.mLatestVersion = component.getVersionNumber().getAsString();
            }
            catch (NoResultsFoundException ex) {
                this.mLatestVersion = null;
            }
            this.mNextMinorVersion = component.getVersionNumber().nextMinorVersionNumber().getAsString();
            this.mNextMajorVersion = component.getVersionNumber().nextMajorVersionNumber().getAsString();
            this.mPreviousName = component.getName();
            this.mPreviousVersion = component.getVersionNumber().getAsString();
        }
    }

    public void createResource(String name, String folderID, String componentType, String label, String description) throws RaplixException {
        this.mComponentName = name;
        this.setFolderID(folderID);
        this.mComponentType = componentType;
        this.mComponentDesc = description;
        this.mComponentLabel = label;
        this.mBrowseHost = "";
        this.mBrowsePath = "";
        this.mBrowseDirectory = "";
        this.mFilterName = "";
        this.mBrowserName = "";
        this.mChildLocalNames = new String[0];
        this.mChildDisplayNames = new String[0];
        this.mChildFullNames = new String[0];
        this.mFilterNames = new String[0];
        this.mFilterDescriptions = new String[0];
        this.mOptionNames = new String[0];
        this.mOptionDescriptions = new String[0];
        this.mOptionDisplayModes = new String[0];
        this.mBrowserNames = new String[0];
        this.mHostSetNames = new String[0];
        this.mPreparePopupNeeded = false;
        this.loadBrowserInfo();
        this.loadComponentTypeInfo();
        this.loadPlatformInfo();
    }

    public void loadComponentTypeInfo() throws RaplixException {
        this.mComponentTypesListBean = new ComponentTypesListBean();
        boolean filterNonBrowseableTypes = this.mComponentMode.equals("componentcheckinnew");
        this.mComponentTypesListBean.loadDirectlyBrowseableComponentTypes(filterNonBrowseableTypes);
        this.mComponentTypes = this.mComponentTypesListBean.getComponentTypeNames();
    }

    private void loadPlatformInfo() throws RaplixException {
        ComponentType ct = ComponentType.create(this.mComponentType);
        String platformName = ct.getComponent().getPlatform();
        SingleHostSetQuery shsq = SingleHostSetQuery.byName(platformName);
        HostSetID hsID = shsq.selectSummaryView().getID();
        HostSetsListBean hslb = new HostSetsListBean();
        hslb.loadSupportedPlatforms(hsID);
        this.mPlatformIDs = hslb.getIDs();
        this.mPlatformNames = hslb.getNames();
    }

    private void generateResourceOutputFields() throws RaplixException {
        RsrcInfo rsrcInfo = this.mResourceManager.getRsrcInfo(new ResourceID(this.mResourceID), null);
        String resourceName = rsrcInfo.getName() == null ? "" : rsrcInfo.getName();
        ResourceEntry entry = this.mResourceManager.getTopResourceEntry(new ResourceID(this.mResourceID));
        NodePerms nodePerms = entry.getPerms();
        this.mFileSystemName = ResourceDetailsBean.extractName(resourceName);
        this.mFileSystemSize = ResourceDetailsBean.convertFileSize(entry.getSize());
        this.mFileSystemLastModified = Util.formatDate(new Date(entry.getTime()));
        if (nodePerms instanceof PosixNodePerms) {
            this.mFileSystemWasPosix = true;
            PosixNodePerms perms = (PosixNodePerms)nodePerms;
            this.mFileSystemUserName = StringUtil.normalizeEmpty(perms.getOwnerName());
            this.mFileSystemGroupName = StringUtil.normalizeEmpty(perms.getGroupName());
            this.mFileSystemPerms = new Mask((int)perms.getPermBits()).toString();
            if (entry.getType() == SubnodeType.DIRECTORY) {
                this.mFileSystemPerms = "d" + this.mFileSystemPerms;
            }
        }
    }

    private void generateComponentFields() throws RaplixException {
        Component c = new ComponentID(this.mComponentID).getByIDQuery().select();
        this.mComponentID = c.getID().toString();
        this.mComponentName = c.getName();
        this.mComponentFullName = c.getFullName();
        this.setFolderID(c.getPath().toString());
        this.mComponentType = ComponentTypesListBean.normalizeName(c.getExtendsTypeName());
        this.mComponentPlatform = c.getPlatform();
        this.mComponentDesc = c.getDescription();
        this.mComponentLabel = c.getLabel();
        this.mComponentCheckInDate = Util.formatDate(c.getTimeStamp());
        if (c.getUserID() != null) {
            this.mComponentCheckInUser = this.mUserDBInterface.getUser(c.getUserID()).getUsername();
        }
        this.mComponentVersion = c.getVersionNumber().getAsString();
        if (c.getResource() != null) {
            this.loadResourceDetails(c.getResource().getResourceID().toString());
        }
        this.mComponentSourceInfo = c.getSourceInfo();
        if (this.mComponentSourceInfo != null) {
            if (this.mComponentSourceInfo.getHost() != null) {
                this.mBrowseHost = HostsBean.getSummaryHostByID(this.mComponentSourceInfo.getHost()).getName();
            }
            this.mBrowsePath = StringUtil.normalizeEmpty(this.mComponentSourceInfo.getBrowseLocation());
            this.mBrowseDirectory = "";
        }
        this.loadComponentTypeInfo();
    }

    public static String extractName(String sourcePath) {
        String name = FileSpec.convertPathSeparatorToUniversal(sourcePath);
        int lastSlashIndex = name.lastIndexOf(FileSpec.UNIVERSAL_FILE_SEPARATOR);
        if (lastSlashIndex > -1) {
            if (lastSlashIndex == name.length() - 1) {
                name = name.substring(0, lastSlashIndex);
                lastSlashIndex = name.lastIndexOf(FileSpec.UNIVERSAL_FILE_SEPARATOR);
            }
            name = name.substring(lastSlashIndex + 1);
        }
        return name;
    }

    public static String convertFileSize(long numBytesLong) {
        if (numBytesLong > 1000L) {
            return numBytesLong / 1000L + " KB";
        }
        return String.valueOf(numBytesLong) + " B";
    }

    public void loadBrowserNode() throws RaplixException {
        this.loadBrowserInfo();
        this.loadPlatformInfo();
        if (this.mBrowseHost.equals("")) {
            this.clearBrowserNodeFields();
            return;
        }
        this.fetchBrowserNode();
        this.loadBrowserChildren(false);
        this.loadAvailableFilters();
        this.mIsRootNode = this.mBrowserNode.isRoot();
        this.mIsExportable = this.mBrowserNode.isExportable();
    }

    public void refreshBrowserNode(boolean browseUp) throws BrowserIncompatibleWithHostException, RaplixException {
        if (this.mBrowseHost.equals("")) {
            this.clearBrowserNodeFields();
            this.loadBrowserInfo();
            this.loadPlatformInfo();
            return;
        }
        try {
            boolean componentTypeChanged = false;
            boolean hostChanged = false;
            boolean browserChanged = false;
            if (this.mBrowserNode != null) {
                HostID hostID = HostsBean.getSummaryHostByName(this.mBrowseHost).getID();
                componentTypeChanged = !this.mComponentType.equals(this.mBrowserNode.getComponentTypeName());
                hostChanged = !hostID.equals(this.mBrowserNode.getHostID());
                browserChanged = false;
                if (!componentTypeChanged && !this.mBrowserName.equals(this.mBrowserInfo.getBrowserType())) {
                    browserChanged = true;
                }
            }
            if (this.mBrowserNode == null || componentTypeChanged || hostChanged || browserChanged) {
                this.mBrowsePath = "";
                this.mBrowseDirectory = "";
                this.mFilterName = "";
                this.loadBrowserInfo();
                this.loadPlatformInfo();
                this.fetchBrowserNode();
            }
        }
        catch (HostDBException hdbe) {
            this.closeBrowserNode();
            throw hdbe;
        }
        catch (UIActionException uiae) {
            this.closeBrowserNode();
            throw uiae;
        }
        if ("".equals(this.mFilterName)) {
            if (this.mBrowserNode.getFilterName() != null) {
                this.mFilterName = this.mBrowserNode.getFilterName();
            }
        } else {
            this.mBrowserNode.setFilterName(this.mFilterName);
        }
        this.loadBrowserChildren(browseUp);
        this.loadAvailableFilters();
        this.mIsRootNode = this.mBrowserNode.isRoot();
        this.mIsExportable = this.mBrowserNode.isExportable();
    }

    public void clearBrowserNodeFields() {
        this.mBrowserNode = null;
        this.mBrowseHost = "";
        this.mBrowsePath = "";
        this.mBrowseDirectory = "";
        this.mChildLocalNames = new String[0];
        this.mChildDisplayNames = new String[0];
        this.mChildFullNames = new String[0];
        this.mFilterNames = new String[0];
        this.mFilterDescriptions = new String[0];
    }

    private void loadBrowserChildren(boolean browseDirection) throws RaplixException {
        BrowserNode[] kids;
        boolean foundNode = false;
        if (browseDirection) {
            if (this.mBrowserNode.getParent() != null) {
                this.mBrowserNode = this.mBrowserNode.getParent();
                this.mBrowsePath = this.mBrowserNode.getFullName();
                this.mBrowseDirectory = this.mBrowserNode.getFullName();
            }
        } else {
            if (this.mBrowserNode.getFullName().equals(this.mBrowsePath)) {
                foundNode = true;
            } else {
                kids = this.mBrowserNode.isContainer() ? this.mBrowserNode.getChildren() : (this.mBrowserNode.getParent() != null ? this.mBrowserNode.getParent().getChildren() : new BrowserNode[]{});
                for (int i = 0; i < kids.length; ++i) {
                    BrowserNode childNode = kids[i];
                    if (!childNode.getFullName().equals(this.mBrowsePath)) continue;
                    this.mBrowserNode = childNode;
                    foundNode = true;
                    break;
                }
            }
            if (!foundNode) {
                this.fetchBrowserNode();
            }
        }
        if (this.mBrowserNode.isContainer()) {
            kids = this.mBrowserNode.getChildren();
            this.mBrowseDirectory = this.mBrowsePath;
        } else if (this.mBrowserNode.getParent() != null) {
            kids = this.mBrowserNode.getParent().getChildren();
            this.mBrowseDirectory = this.mBrowserNode.getParent().getFullName();
        } else {
            kids = new BrowserNode[]{};
        }
        int numChildren = kids.length;
        this.mChildLocalNames = new String[numChildren];
        this.mChildDisplayNames = new String[numChildren];
        this.mChildFullNames = new String[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            this.mChildLocalNames[i] = kids[i].getLocalName();
            this.mChildDisplayNames[i] = kids[i].getDisplayName();
            this.mChildFullNames[i] = kids[i].getFullName();
        }
    }

    private void loadAvailableFilters() {
        BrowserFilter[] filters = this.mBrowserNode.getAvailableFilters();
        int numFilters = filters.length;
        this.mFilterNames = new String[numFilters];
        this.mFilterDescriptions = new String[numFilters];
        for (int i = 0; i < numFilters; ++i) {
            this.mFilterNames[i] = filters[i].getName();
            this.mFilterDescriptions[i] = filters[i].getDescription();
        }
    }

    private void fetchBrowserNode() throws BrowserIncompatibleWithHostException, RaplixException {
        HostID hostID = HostsBean.getSummaryHostByName(this.mBrowseHost).getID();
        String browsePath = this.mBrowsePath.equals("") ? null : this.mBrowsePath;
        this.mBrowserNode = HierarchyBrowserSubsystem.getInstance().getBrowser(this.mBrowserInfo, hostID, browsePath);
        this.mBrowsePath = this.mBrowserNode.getFullName();
    }

    private void loadBrowserInfo() throws RaplixException {
        BrowserInfo[] selectedBrowsers = sComponentExportServices.getAvailableBrowsers(this.mComponentType);
        String actualCompType = selectedBrowsers[0].getComponentType();
        if (this.mComponentType.equals(actualCompType)) {
            this.mAvailableBrowsers = selectedBrowsers;
        } else {
            this.mComponentType = actualCompType;
            this.mAvailableBrowsers = sComponentExportServices.getAvailableBrowsers(actualCompType);
        }
        this.mBrowserInfo = this.mAvailableBrowsers[0];
        this.mBrowserNames = new String[this.mAvailableBrowsers.length];
        for (int i = 0; i < this.mAvailableBrowsers.length; ++i) {
            this.mBrowserNames[i] = this.mAvailableBrowsers[i].getBrowserType();
            if (!this.mBrowserNames[i].equals(this.mBrowserName)) continue;
            this.mBrowserInfo = this.mAvailableBrowsers[i];
        }
        this.mBrowserName = this.mBrowserInfo.getBrowserType();
        if (this.mBrowserInfo.getLimitToHostSet() != null) {
            String hostSetName = this.mBrowserInfo.getLimitToHostSet();
            SingleHostSetQuery shsq = SingleHostSetQuery.byName(hostSetName);
            SummaryHostSet shs = shsq.selectSummaryView();
            HostSetID hostSetID = shs.getID();
            SummaryHost[] hosts = hostSetID.getAllHostsQuery().selectSummaryView();
            this.mHostSetLimited = true;
            this.mHostSetNames = new String[hosts.length];
            for (int i = 0; i < hosts.length; ++i) {
                this.mHostSetNames[i] = hosts[i].getName();
            }
        } else {
            this.mHostSetLimited = false;
            this.mHostSetNames = new String[0];
        }
        PromptParamList optionList = this.mBrowserInfo.getCheckinOptions();
        this.mOptionNames = optionList.getVarNames();
        this.mOptionDescriptions = new String[this.mOptionNames.length];
        this.mOptionDisplayModes = new String[this.mOptionNames.length];
        for (int i = 0; i < this.mOptionNames.length; ++i) {
            String optionName = this.mOptionNames[i];
            PromptParam option = optionList.getParam(optionName);
            this.mOptionDescriptions[i] = option.getResolvedPrompt();
            DisplayMode display = option.getDisplayMode();
            this.mOptionDisplayModes[i] = display.equals(DisplayMode.PASSWORD) ? "password" : (display.equals(DisplayMode.CLEAR) ? "cleartext" : "checkbox");
            if (this.mComponentSourceInfo == null) {
                this.setOptionValue(optionName, option.getDefaultValue());
                continue;
            }
            String val = this.mComponentSourceInfo.getVarValue(optionName);
            if (val == null) continue;
            this.setOptionValue(optionName, val);
        }
    }

    public void closeBrowserNode() throws RaplixException {
        if (this.mBrowserNode == null) {
            return;
        }
        this.mBrowserNode.closeSession();
        this.mBrowserNode = null;
        this.clearBrowserNodeFields();
    }

    public void checkinResource() throws RaplixException {
        if (this.mIsNew) {
            this.mLatestVersion = null;
        }
        VersionNumber version = null;
        if (this.mLatestVersion != null) {
            version = new VersionNumber(this.mLatestVersion);
        }
        ComponentSaveContext ctx = new ComponentSaveContext();
        ctx.setLatestVersion(version);
        ctx.setSaveAsNewMajor(this.mIsMajorVersion);
        ctx.setHideLatest(this.mIsHidingPrevious);
        HostID hostID = HostsBean.getSummaryHostByName(this.mBrowseHost).getID();
        HostSetID platformID = HostSetsBean.getSummaryHostSetByID(this.mComponentPlatform).getID();
        SourceInfo sourceInfo = this.mBrowserNode.getSourceInfo();
        Iterator options = this.mOptions.keySet().iterator();
        while (options.hasNext()) {
            String name = (String)options.next();
            String val = this.getOptionValue(name);
            sourceInfo.addParameter(name, val, "");
        }
        ExportContext exportCtx = new ExportContext();
        exportCtx.setComponentSaveContext(ctx);
        exportCtx.setDescription(this.mComponentDesc);
        exportCtx.setLabel(this.mComponentLabel);
        exportCtx.setPlatform(platformID);
        exportCtx.setSourceInfo(sourceInfo);
        exportCtx.setAttributes(this.mBrowserNode.getAttributes());
        FolderID folderID = new FolderID(this.mComponentFolderID);
        this.mCompCheckInID = sComponentExportServices.checkIn(this.mBrowserNode.getComponentTypeName(), this.mBrowserNode.getBrowserType(), folderID, this.mComponentName, exportCtx);
    }

    public boolean isPending() throws RaplixException {
        return this.getCompStatus() instanceof CompPending;
    }

    public void cancelCheckIn() throws RaplixException {
        sCompCheckInServices.cancel(this.mCompCheckInID);
    }

    public String getCompletedCheckinCompID() throws RaplixException {
        String compID = "";
        if (this.getCompStatus() instanceof CompComplete) {
            compID = ((CompComplete)this.getCompStatus()).getComponentID().toString();
        }
        return compID;
    }
}

