/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.resources;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.CompCheckInServices;
import com.raplix.rolloutexpress.hierarchies.compexport.ComponentExportServices;
import com.raplix.rolloutexpress.hierarchies.compexport.SourceInfo;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCancelled;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompCheckInID;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompComplete;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompError;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompPending;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompStatus;
import com.raplix.rolloutexpress.hierarchies.compexport.status.CompWasRedundant;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.util.string.StringUtil;
import java.util.Date;
import java.util.Vector;

public class ResourceCheckinJobsBean
extends ServletListBean {
    private static final CompCheckInServices sCompCheckInServices = CompCheckInServices.INSTANCE;
    private static final ComponentExportServices sComponentExportServices = ComponentExportServices.INSTANCE;
    private CompCheckInInfo[] mCheckInInfos = new CompCheckInInfo[0];
    private String[] mCheckinJobIDs = new String[0];
    private boolean[] mIsJobRunnings = new boolean[0];
    private String[] mHostNames = new String[0];
    private String[] mResourceNames = new String[0];
    private String[] mResourceTypes = new String[0];
    private String[] mCheckinEndTimes = new String[0];
    private String[] mCheckinStatuses = new String[0];
    private boolean mPreviousRunning = false;
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    public static final String JOB_STATUS_CANCELLED = ApplicationResources.getMessage("resourcesCheckinJobs.cancelled");
    public static final String JOB_STATUS_FAILED = ApplicationResources.getMessage("resourcesCheckinJobs.failed");
    public static final String JOB_STATUS_IN_PROGRESS = ApplicationResources.getMessage("resourcesCheckinJobs.inprogress");
    public static final String JOB_STATUS_SUCCEEDED = ApplicationResources.getMessage("resourcesCheckinJobs.succeeded");
    public static final String JOB_STATUS_WAS_REDUNDANT = ApplicationResources.getMessage("resourcesCheckinJobs.currentasis");

    public String[] getCheckinJobIDs() {
        return this.mCheckinJobIDs;
    }

    public boolean[] getIsJobRunnings() {
        return this.mIsJobRunnings;
    }

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getResourceNames() {
        return this.mResourceNames;
    }

    public String[] getResourceTypes() {
        return this.mResourceTypes;
    }

    public String[] getCheckinEndTimes() {
        return this.mCheckinEndTimes;
    }

    public String[] getCheckinStatuses() {
        return this.mCheckinStatuses;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getPreviousRunning() {
        return this.mPreviousRunning;
    }

    public void setCheckinJobIDs(String[] jobIDs) {
        this.mCheckinJobIDs = jobIDs;
    }

    public void setPreviousRunning(boolean previous) {
        this.mPreviousRunning = previous;
    }

    public void generateList() throws RaplixException {
        this.mCheckInInfos = this.mCheckinJobIDs.length == 0 ? sCompCheckInServices.getRecentCheckIns() : this.getCheckInJobs(this.mCheckinJobIDs);
        this.generateOutputArrays();
    }

    private void generateOutputArrays() {
        int jobsListSize = this.mCheckInInfos.length;
        this.mCheckinJobIDs = new String[jobsListSize];
        this.mIsJobRunnings = new boolean[jobsListSize];
        this.mHostNames = new String[jobsListSize];
        this.mResourceNames = new String[jobsListSize];
        this.mResourceTypes = new String[jobsListSize];
        this.mCheckinEndTimes = new String[jobsListSize];
        this.mCheckinStatuses = new String[jobsListSize];
        for (int i = 0; i < jobsListSize; ++i) {
            CompCheckInInfo info = this.mCheckInInfos[i];
            CompStatus status = info.getStatus();
            boolean isRunning = true;
            String endTime = "";
            if (!(status instanceof CompPending)) {
                isRunning = false;
                endTime = Util.formatDate(new Date(status.getEndTime()));
            }
            this.mCheckinJobIDs[i] = info.getID().toString();
            this.mIsJobRunnings[i] = isRunning;
            this.mHostNames[i] = StringUtil.normalizeEmpty(info.getHostName());
            this.mResourceNames[i] = info.getComponentName();
            this.mResourceTypes[i] = info.getComponentType();
            this.mCheckinEndTimes[i] = endTime;
            this.mCheckinStatuses[i] = ResourceCheckinJobsBean.getStatusAsString(status);
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mCheckinJobIDs);
    }

    public void cancelCheckInJobs(String[] jobIDs) throws RaplixException {
        if (jobIDs == null) {
            return;
        }
        int numJobs = jobIDs.length;
        CompCheckInID[] jobs = new CompCheckInID[numJobs];
        for (int i = 0; i < numJobs; ++i) {
            jobs[i] = new CompCheckInID(jobIDs[i]);
        }
        sCompCheckInServices.cancel(jobs);
    }

    private void checkInCurrent(ComponentID[] componentIDs) throws RaplixException {
        if (componentIDs == null) {
            return;
        }
        int numComponents = componentIDs.length;
        Vector<String> jobList = new Vector<String>();
        for (int i = 0; i < numComponents; ++i) {
            SummaryComponent c = componentIDs[i].getByIDQuery().selectSummaryView();
            SourceInfo si = c.getSourceInfo();
            String componentType = c.getExtendsTypeName();
            if (!ComponentTypesListBean.hasCheckinCurrentCapability(componentType, si)) continue;
            String jobID = sComponentExportServices.checkInCurrent(componentIDs[i]).toString();
            jobList.addElement(jobID);
        }
        this.setCheckinJobIDs(jobList.toArray(new String[0]));
        this.generateList();
    }

    public void checkInCurrent(String[] compIDs) throws RaplixException {
        if (compIDs == null) {
            return;
        }
        int numComponents = compIDs.length;
        ComponentID[] componentIDs = new ComponentID[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            componentIDs[i] = new ComponentID(compIDs[i]);
        }
        this.checkInCurrent(componentIDs);
    }

    private static String getStatusAsString(CompStatus status) {
        String statusStr = "";
        if (status instanceof CompError) {
            statusStr = JOB_STATUS_FAILED;
        } else if (status instanceof CompPending) {
            statusStr = JOB_STATUS_IN_PROGRESS;
        } else if (status instanceof CompCancelled) {
            statusStr = JOB_STATUS_CANCELLED;
        } else if (status instanceof CompComplete) {
            statusStr = JOB_STATUS_SUCCEEDED;
        } else if (status instanceof CompWasRedundant) {
            statusStr = JOB_STATUS_WAS_REDUNDANT;
        }
        return statusStr;
    }

    private CompCheckInInfo[] getCheckInJobs(String[] jobIDs) throws RaplixException {
        int numJobs = jobIDs.length;
        CompCheckInID[] checkInJobIDs = new CompCheckInID[numJobs];
        for (int i = 0; i < numJobs; ++i) {
            checkInJobIDs[i] = new CompCheckInID(jobIDs[i]);
        }
        return sCompCheckInServices.getRecentCheckIns(checkInJobIDs);
    }

    public boolean getIsRunning() {
        boolean anyJobsRunning = false;
        int numJobs = this.mIsJobRunnings.length;
        for (int i = 0; i < numJobs; ++i) {
            if (!this.mIsJobRunnings[i]) continue;
            anyJobsRunning = true;
            break;
        }
        return anyJobsRunning;
    }

    public boolean getHasErrors() {
        boolean anyJobsFailed = false;
        int numJobs = this.mCheckinStatuses.length;
        for (int i = 0; i < numJobs; ++i) {
            if (!this.mCheckinStatuses[i].equals(JOB_STATUS_FAILED)) continue;
            anyJobsFailed = true;
            break;
        }
        return anyJobsFailed;
    }
}

