/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.resources;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.resources.ResourceCheckinJobsBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class ResourceCheckinJobsAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String RSRC_CHECKINJOB_ERRORMSG_DISPLAY = "error.resources.checkinjobs.load";
    private static final String RSRC_CHECKINJOB_ERRORMSG_CHECKIN_CURRENT = "error.resources.checkinjobs.load";
    private static final String RSRC_CHECKINJOB_ERRORMSG_CANCEL_CHECKIN_JOBS = "error.resources.checkinjobs.load";

    public void doUIAction(HttpServletRequest inRequest, ServletInfo servletInfo) throws RaplixException {
        String mode = ResourceCheckinJobsAction.assertGetParam(inRequest, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through ResourceCheckinJobsAction: " + mode, this);
        }
        if (mode.equals("display")) {
            this.handleDisplay(servletInfo, inRequest);
        } else if (mode.equals("checkincurrent")) {
            this.handleCheckinCurrent(servletInfo, inRequest);
        } else if (mode.equals("cancelcheckinjobs")) {
            this.handleCancelCheckinJobs(servletInfo, inRequest);
        } else {
            throw new IllegalArgumentException("Invalid Mode: " + mode);
        }
    }

    private void handleDisplay(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        boolean running;
        ResourceCheckinJobsBean rcjb = (ResourceCheckinJobsBean)servletInfo.getBean();
        String jobID = request.getParameter("checkInJobIDs");
        String jobMCID = request.getParameter("multiLocation");
        String selected = request.getParameter("selected");
        boolean bl = running = request.getParameter("previousRunning") != null;
        if (jobID != null) {
            rcjb.setCheckinJobIDs(new String[]{jobID});
        } else if (jobMCID != null) {
            MultiCheckbox incoming = (MultiCheckbox)request.getSession().getAttribute(jobMCID);
            rcjb.setCheckinJobIDs(incoming.getValues());
        }
        rcjb.generateList();
        rcjb.setPreviousRunning(running);
        MultiCheckbox jobsMC = rcjb.getMultiCheckbox();
        if (selected != null) {
            jobsMC.setSelected(selected);
        }
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(jobsMC.getID(), jobsMC);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleCheckinCurrent(ServletInfo servletInfo, HttpServletRequest inRequest) throws RaplixException {
        ResourceCheckinJobsBean rcjb = (ResourceCheckinJobsBean)servletInfo.getBean();
        String[] resourceIDs = null;
        String componentID = inRequest.getParameter("componentID");
        if (componentID != null) {
            resourceIDs = new String[]{componentID};
        } else {
            String resourceMCID = ResourceCheckinJobsAction.assertGetParam(inRequest, "multiLocation");
            String selected = ResourceCheckinJobsAction.assertGetParam(inRequest, "selected");
            MultiCheckbox resourceMC = (MultiCheckbox)inRequest.getSession().getAttribute(resourceMCID);
            resourceMC.setSelected(selected);
            resourceIDs = resourceMC.getSelected();
        }
        rcjb.checkInCurrent(resourceIDs);
        MultiCheckbox jobsMC = rcjb.getMultiCheckbox();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(inRequest.getSession());
        ssb.put(jobsMC.getID(), jobsMC);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleCancelCheckinJobs(ServletInfo servletInfo, HttpServletRequest request) throws RaplixException {
        ResourceCheckinJobsBean rcjb = (ResourceCheckinJobsBean)servletInfo.getBean();
        String jobID = request.getParameter("id");
        String jobsMCID = ResourceCheckinJobsAction.assertGetParam(request, "multiLocation");
        String selected = request.getParameter("selected");
        String[] cancelledIDs = null;
        MultiCheckbox jobsMC = (MultiCheckbox)request.getSession().getAttribute(jobsMCID);
        if (jobID != null) {
            cancelledIDs = new String[]{jobID};
        } else {
            jobsMC.setSelected(selected);
            cancelledIDs = jobsMC.getSelected();
        }
        rcjb.cancelCheckInJobs(cancelledIDs);
        rcjb.setCheckinJobIDs(jobsMC.getValues());
        rcjb.generateList();
        MultiCheckbox updatedJobsMC = rcjb.getMultiCheckbox();
        ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
        ssb.put(updatedJobsMC.getID(), updatedJobsMC);
        servletInfo.setDestPage(this.getDefaultPage());
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new ResourceCheckinJobsBean();
    }

    public String getDefaultPage() {
        return "/resources/resourceCheckinJobs.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = ResourceCheckinJobsAction.assertGetParam(request, "mode");
        if (mode.equals("display")) {
            return "error.resources.checkinjobs.load";
        }
        if (mode.equals("checkincurrent")) {
            return "error.resources.checkinjobs.load";
        }
        if (mode.equals("cancelcheckinjobs")) {
            return "error.resources.checkinjobs.load";
        }
        throw new IllegalArgumentException("Invalid Mode: " + mode);
    }

    protected boolean isPopup(HttpServletRequest request) {
        return true;
    }
}

