/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.plugindb.MultiPluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginOrder;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;

public class PluginsListBean
extends ServletListBean {
    private static final PluginOrder DEFAULT_SORT_ORDER = PluginOrder.BY_NAME_ASC;
    private static final String deleteCandidateHeader = "plugins.delCandidate.header";
    private String[] mPluginIDs = new String[0];
    private String[] mPluginNames = new String[0];
    private String[] mPluginVersions = new String[0];
    private String[] mPluginMenuOrders = new String[0];
    private String[] mPluginDescriptions = new String[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private boolean mWriteOnPlugin = true;
    private String mMode = "";

    public String[] getPluginIDs() {
        return this.mPluginIDs;
    }

    public String[] getPluginNames() {
        return this.mPluginNames;
    }

    public String[] getPluginVersions() {
        return this.mPluginVersions;
    }

    public String[] getPluginMenuOrders() {
        return this.mPluginMenuOrders;
    }

    public String[] getPluginDescriptions() {
        return this.mPluginDescriptions;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void generateList() throws RaplixException {
        MultiPluginQuery mpq = MultiPluginQuery.all();
        this.prepQuery(mpq, this.getSortOrderByName(PluginOrder.FACTORY, this.getSortName()));
        this.generateOutputArrays(mpq.selectSummaryView());
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin();
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mPluginIDs);
    }

    private void generateOutputArrays(SummaryPlugin[] spa) {
        int arrySize = spa.length;
        this.mPluginIDs = new String[arrySize];
        this.mPluginNames = new String[arrySize];
        this.mPluginVersions = new String[arrySize];
        this.mPluginMenuOrders = new String[arrySize];
        this.mPluginDescriptions = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryPlugin sp = spa[i];
            this.mPluginIDs[i] = sp.getID().toString();
            this.mPluginNames[i] = sp.getName();
            this.mPluginVersions[i] = sp.getVersionNumber().getAsString();
            this.mPluginMenuOrders[i] = sp.getMenuOrder();
            this.mPluginDescriptions[i] = sp.getDescription();
        }
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }
}

