/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.Severity;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionInfo;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionStatus;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.HttpMultipartRequestWrapper;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.plugins.PluginDetailsBean;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class PluginsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_IMPORT_MAJOR = "error.plugins.import.major";
    public static final String MSG_ERROR_FILE_NOT_FOUND = "error.plugins.import.filenotfound.minor";
    public static final String MSG_ERROR_IMPORT_CANCEL_MAJOR = "error.plugins.import.cancel.major";
    public static final String MSG_ERROR_DETAILS_MAJOR = "error.plugins.details.major";
    public static final String MSG_ERROR_EDIT_MAJOR = "error.plugins.edit.major";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.plugins.save.major";
    public static final String MSG_ERROR_TRYING_TO_CANCEL = "error.plugins.abortpending.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HttpMultipartRequestWrapper wrapper;
        try {
            wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
        }
        catch (IOException ioe) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("wrapRequest throwing IOException in PluginsHandleAction's doUIAction", ioe, this);
            }
            throw new RaplixException(ioe);
        }
        String mode = wrapper.assertGetParameter("mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PluginsHandleAction: " + mode, this);
        }
        if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("import")) {
            this.handleImport(request, servletInfo);
        } else if (mode.equals("importStart")) {
            this.handleImportStart(wrapper, servletInfo);
        } else if (mode.equals("importRefresh")) {
            this.handleImportRefresh(request, servletInfo);
        } else if (mode.equals("importCancelRequest")) {
            this.handleImportCancelRequest(request, servletInfo);
        } else if (mode.equals("importCancelled")) {
            this.handleImportCancelled(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("showcert")) {
            this.handleCertPopup(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to PluginsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        PluginDetailsBean pdb = new PluginDetailsBean();
        return pdb;
    }

    public String getDefaultPage() {
        return "/plugins/pluginDetails.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        HttpMultipartRequestWrapper wrapper;
        block7: {
            wrapper = null;
            try {
                wrapper = HttpMultipartRequestWrapper.wrapRequest(request);
            }
            catch (IOException ioe) {
                if (!Logger.isDebugEnabled(this)) break block7;
                Logger.debug("IOException in getMajorError.", ioe, this);
            }
        }
        String mode = wrapper == null ? "details" : wrapper.assertGetParameter("mode");
        if (mode.equals("details")) {
            return MSG_ERROR_DETAILS_MAJOR;
        }
        if (mode.equals("import") || mode.equals("importStart") || mode.equals("importRefresh")) {
            return MSG_ERROR_IMPORT_MAJOR;
        }
        if (mode.equals("importCancelRequest") || mode.equals("importCancelled")) {
            return MSG_ERROR_IMPORT_CANCEL_MAJOR;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT_MAJOR;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        throw new IllegalArgumentException("Unknown mode passed to PluginsHandleAction.");
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String id = PluginsHandleAction.assertGetParam(request, "id");
        pdb.loadDetails(id);
        pdb.setMode("details");
        servletInfo.setDestPage("/plugins/pluginDetails.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleImport(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        pdb.setMode("import");
        servletInfo.setDestPage("/plugins/pluginImport.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleImportStart(HttpMultipartRequestWrapper wrapper, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        File localFile = wrapper.getParameterLocalFile("pluginJAR");
        String pluginJARFilePath = wrapper.getParameterClientFileName("pluginJAR");
        pdb.setPluginJARFilePath(pluginJARFilePath);
        if (localFile == null) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT_MAJOR);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_FILE_NOT_FOUND);
            this.handleImport(wrapper.getRequest(), servletInfo);
            return;
        }
        try {
            pdb.importPlugin(localFile);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT_MAJOR);
            servletInfo.getErrors().addMinorError(re);
            this.handleImport(wrapper.getRequest(), servletInfo);
            return;
        }
        catch (IOException ioe) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT_MAJOR);
            servletInfo.getErrors().addMinorError(new RaplixException(ioe));
            this.handleImport(wrapper.getRequest(), servletInfo);
            return;
        }
        pdb.setMode("importStart");
        servletInfo.setDestPage("/plugins/pluginImportProgress.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleImportRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String pluginImportSessionID = PluginsHandleAction.assertGetParam(request, "id");
        String pluginJARFilePath = PluginsHandleAction.assertGetParam(request, "filePath");
        pdb.setPluginImportSessionID(pluginImportSessionID);
        pdb.setPluginJARFilePath(pluginJARFilePath);
        PluginImportSessionInfo info = pdb.getImportSessionInfo();
        PluginImportSessionStatus status = info.getStatus();
        if (status.equals(PluginImportSessionStatus.COMPLETE)) {
            servletInfo.setDestPage(UriUtil.pluginDetailsURI(info.getPluginID().toString()));
            servletInfo.setShouldRedirect(true);
            servletInfo.setSaveInSession(false);
        } else if (status.equals(PluginImportSessionStatus.NOT_STARTED) || status.equals(PluginImportSessionStatus.IMPORT_RUNNING)) {
            pdb.setMode("importRefresh");
            servletInfo.setDestPage("/plugins/pluginImportProgress.jsp");
            servletInfo.setShouldRedirect(false);
            servletInfo.setSaveInSession(false);
        } else if (status.equals(PluginImportSessionStatus.ABORT_REQUESTED)) {
            pdb.setMode("importRefresh");
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_TRYING_TO_CANCEL, Severity.INFO);
            servletInfo.setDestPage("/plugins/pluginImportProgress.jsp");
            servletInfo.setShouldRedirect(false);
            servletInfo.setSaveInSession(false);
        } else if (status.equals(PluginImportSessionStatus.ABORTED)) {
            this.handleImportCancelled(request, servletInfo);
        } else if (status.equals(PluginImportSessionStatus.FAILED)) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_IMPORT_MAJOR);
            servletInfo.getErrors().addMinorError(info.getException().getMessage());
            this.handleImport(request, servletInfo);
        }
    }

    private void handleImportCancelRequest(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String pluginImportSessionID = PluginsHandleAction.assertGetParam(request, "id");
        String pluginJARFilePath = PluginsHandleAction.assertGetParam(request, "filePath");
        pdb.setPluginImportSessionID(pluginImportSessionID);
        pdb.setPluginJARFilePath(pluginJARFilePath);
        pdb.setMode("importRefresh");
        pdb.cancelImport();
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_TRYING_TO_CANCEL, Severity.INFO);
        servletInfo.setDestPage("/plugins/pluginImportProgress.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleImportCancelled(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setDestPage("/Plugins");
        servletInfo.setShouldRedirect(true);
        servletInfo.setSaveInSession(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String id = PluginsHandleAction.assertGetParam(request, "id");
        pdb.loadDetails(id);
        pdb.setMode("edit");
        servletInfo.setDestPage("/plugins/pluginDetails.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String pluginID = PluginsHandleAction.assertGetParam(request, "id");
        String menuOrder = PluginsHandleAction.assertGetParam(request, "order");
        String updateCount = PluginsHandleAction.assertGetParam(request, "updateCount");
        pdb.loadDetails(pluginID);
        pdb.setPluginID(pluginID);
        pdb.setPluginMenuOrder(menuOrder);
        pdb.setUpdateCount(Integer.parseInt(updateCount));
        pdb.setMode("details");
        try {
            pdb.persist();
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(pme.getMessage());
            pdb.setMode("edit");
        }
        servletInfo.setDestPage("/plugins/pluginDetails.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleCertPopup(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        PluginDetailsBean pdb = (PluginDetailsBean)servletInfo.getBean();
        String pluginID = PluginsHandleAction.assertGetParam(request, "id");
        pdb.loadDetails(pluginID);
        servletInfo.setDestPage("/plugins/pluginCertDetails.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }
}

