/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.plugins.PluginsListBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public class PluginsAction
extends UIActionListServlet
implements ActionModeConstants {
    private static final String MSG_ERROR_LIST_MAJOR = "error.plugins.load.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "";
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through PluginsAction: " + mode, this);
        }
        this.handleList(request, servletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new PluginsListBean();
    }

    public String getDefaultPage() {
        return "/plugins/plugins.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        return MSG_ERROR_LIST_MAJOR;
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        PluginsListBean plb = (PluginsListBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        this.loadListParameters(request, plb);
        plb.generateList();
        servletInfo.setDestPage("/plugins/plugins.jsp");
        servletInfo.setSaveInSession(false);
    }
}

