/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PluginReadmeDownloadAction
extends LoggedOnServlet
implements ActionModeConstants {
    public static final String FILENAME = "ReadMe.txt";
    private static final String MSG_ERROR_MAJOR = "error.plugins.download.major";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String pluginID = PluginReadmeDownloadAction.assertGetParam(request, "id");
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Trying to retrieve plugin with id:" + pluginID, this);
            }
            Plugin p = new PluginID(pluginID).getByIDQuery().select();
            response.setContentType("plain/text; charset=UTF-8");
            PrintWriter out = response.getWriter();
            out.print(p.getReadMeText());
        }
        catch (RaplixException re) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Exception caught in PluginReadmeDownloadAction", re, this);
            }
            ServletErrors errors = new ServletErrors();
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(re.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
    }
}

