/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRefIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.MultiPluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginDescriptor;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginIDSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImportSessionInfo;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.X509Certificate;

public class PluginDetailsBean
extends ServletBean {
    private String mPluginJARFilePath = "";
    private String mPluginImportSessionID = "";
    private String mPluginID = "";
    private Plugin mPlugin = null;
    private String mPluginName = "";
    private String mPluginVersion = "";
    private String mPluginMenuOrder = "";
    private String mPluginDescription = "";
    private String mPluginVendor = "";
    private String mPluginCertificateIssuer = "";
    private String mPluginCertificateSubject = "";
    private String mPluginCertificateText = "";
    private String mCustomPagePath = "";
    private String mMenuItemName = "";
    private String[] mPlanIDs = new String[0];
    private String[] mPlanNames = new String[0];
    private String[] mPlanVersions = new String[0];
    private String[] mComponentIDs = new String[0];
    private String[] mComponentNames = new String[0];
    private String[] mComponentVersions = new String[0];
    private String[] mComponentTypeIDs = new String[0];
    private String[] mComponentTypeNames = new String[0];
    private String[] mSystemServiceIDs = new String[0];
    private String[] mSystemServiceNames = new String[0];
    private String[] mHostSetIDs = new String[0];
    private String[] mHostSetNames = new String[0];
    private String[] mHostSearchIDs = new String[0];
    private String[] mHostSearchNames = new String[0];
    private String[] mHostTypeIDs = new String[0];
    private String[] mHostTypeNames = new String[0];
    private String[] mFolderIDs = new String[0];
    private String[] mFolderNames = new String[0];
    private String[] mDependOnPluginIDs = new String[0];
    private String[] mDependOnPluginNames = new String[0];
    private boolean mHasReadme = false;
    private boolean mWriteOnPlugin = true;
    private String mMode = "";
    private int mUpdateCount = 0;

    public String getID() {
        if (!this.mPluginID.equals("")) {
            return this.mPluginID;
        }
        return super.getID();
    }

    public PluginImportSessionInfo getImportSessionInfo() throws RaplixException {
        PluginImportSessionID pisid = new PluginImportSessionID(this.mPluginImportSessionID);
        return pisid.getInfo();
    }

    public String getPluginImportSessionID() {
        return this.mPluginImportSessionID;
    }

    public String getPluginJARFilePath() {
        return this.mPluginJARFilePath;
    }

    public String getPluginID() {
        return this.getID();
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginVersion() {
        return this.mPluginVersion;
    }

    public String getPluginMenuOrder() {
        return this.mPluginMenuOrder;
    }

    public String getPluginDescription() {
        return this.mPluginDescription;
    }

    public String getPluginVendor() {
        return this.mPluginVendor;
    }

    public String getPluginCertificateIssuer() {
        return this.mPluginCertificateIssuer;
    }

    public String getPluginCertificateSubject() {
        return this.mPluginCertificateSubject;
    }

    public String getPluginCertificateText() {
        return this.mPluginCertificateText;
    }

    public String getCustomPagePath() {
        return this.mCustomPagePath;
    }

    public String getMenuItemName() {
        return this.mMenuItemName;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getPlanVersions() {
        return this.mPlanVersions;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String[] getComponentVersions() {
        return this.mComponentVersions;
    }

    public String[] getComponentTypeIDs() {
        return this.mComponentTypeIDs;
    }

    public String[] getComponentTypeNames() {
        return this.mComponentTypeNames;
    }

    public String[] getSystemServiceIDs() {
        return this.mSystemServiceIDs;
    }

    public String[] getSystemServiceNames() {
        return this.mSystemServiceNames;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public String[] getHostSearchIDs() {
        return this.mHostSearchIDs;
    }

    public String[] getHostSearchNames() {
        return this.mHostSearchNames;
    }

    public String[] getHostTypeIDs() {
        return this.mHostTypeIDs;
    }

    public String[] getHostTypeNames() {
        return this.mHostTypeNames;
    }

    public String[] getFolderIDs() {
        return this.mFolderIDs;
    }

    public String[] getFolderNames() {
        return this.mFolderNames;
    }

    public String[] getDependOnPluginIDs() {
        return this.mDependOnPluginIDs;
    }

    public String[] getDependOnPluginNames() {
        return this.mDependOnPluginNames;
    }

    public boolean getHasReadme() {
        return this.mHasReadme;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public String getMode() {
        return this.mMode;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public void setPluginImportSessionID(String inValue) {
        this.mPluginImportSessionID = inValue;
    }

    public void setPluginID(String inValue) {
        this.mPluginID = inValue;
    }

    public void setPluginMenuOrder(String inValue) {
        this.mPluginMenuOrder = inValue;
    }

    public void setPluginJARFilePath(String inValue) {
        this.mPluginJARFilePath = inValue;
    }

    public void setMode(String inValue) {
        this.mMode = inValue;
    }

    public void setUpdateCount(int inValue) {
        this.mUpdateCount = inValue;
    }

    public void importPlugin(File file) throws RaplixException, IOException {
        PluginDescriptor pd = new PluginDescriptor(new FileInputStream(file), true);
        this.mPluginImportSessionID = Plugin.importPlugin(pd).toString();
    }

    public void cancelImport() throws RaplixException {
        PluginImportSessionID pisid = new PluginImportSessionID(this.mPluginImportSessionID);
        pisid.cancel();
    }

    public void loadDetails(String pluginID) throws RaplixException {
        PluginID pid = new PluginID(pluginID);
        SinglePluginQuery spq = pid.getByIDQuery();
        this.mPlugin = spq.select();
        this.mPluginID = pid.toString();
        this.mPluginName = this.mPlugin.getName();
        this.mPluginVersion = this.mPlugin.getVersionNumber().getAsString();
        this.mPluginMenuOrder = this.mPlugin.getMenuOrder();
        this.mPluginDescription = this.mPlugin.getDescription() == null ? "" : this.mPlugin.getDescription();
        this.mPluginVendor = this.mPlugin.getVendor();
        if (this.mPlugin.getCertificate() != null) {
            if (this.mPlugin.getCertificate() instanceof X509Certificate) {
                X509Certificate X509Cert = (X509Certificate)this.mPlugin.getCertificate();
                this.mPluginCertificateIssuer = this.parseCertCN(X509Cert.getIssuerDN().getName());
                this.mPluginCertificateSubject = X509Cert.getSubjectDN().getName();
            }
            this.mPluginCertificateText = this.mPlugin.getCertificate().toString();
        }
        this.mMenuItemName = this.mPlugin.getMenuItem();
        this.mHasReadme = this.mPlugin.getReadMeText() != null;
        this.mUpdateCount = this.mPlugin.getUpdateCount();
        if (this.mPlugin.getCustomPagePath() != null) {
            this.mCustomPagePath = this.mPlugin.getID() + File.separator + this.mPlugin.getVersionNumber().getAsString() + File.separator + "shortcuts.html";
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin();
        this.loadPlans();
        this.loadComponents();
        this.loadComponentTypes();
        this.loadSystemServices();
        this.loadHostSets();
        this.loadHostSearches();
        this.loadHostTypes();
        this.loadFolders();
        this.loadPluginDependencies();
    }

    private String parseCertCN(String issuerDN) {
        String certCN = issuerDN.trim();
        int pos = certCN.indexOf("CN=");
        if (pos == 0) {
            certCN = certCN.substring(3);
        }
        if ((pos = certCN.indexOf(", O=")) > -1) {
            certCN = certCN.substring(0, pos);
        }
        return certCN;
    }

    private void loadPlans() throws RaplixException {
        ExecutionPlanIDSet epids = this.mPlugin.getPlans();
        MultiExecutionPlanQuery mepq = epids.getByIDsQuery();
        SummaryExecutionPlan[] sepa = mepq.selectSummaryView();
        int arrySize = sepa.length;
        this.mPlanIDs = new String[arrySize];
        this.mPlanNames = new String[arrySize];
        this.mPlanVersions = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryExecutionPlan sep = sepa[i];
            this.mPlanIDs[i] = sep.getID().toString();
            this.mPlanNames[i] = sep.getPath().getFullPathString() + sep.getName();
            this.mPlanVersions[i] = sep.getVersionNumber().getAsString();
        }
    }

    private void loadComponents() throws RaplixException {
        ComponentIDSet cids = this.mPlugin.getComponents();
        MultiComponentQuery mcq = cids.getByIDsQuery();
        SummaryComponent[] sca = mcq.selectSummaryView();
        int arrySize = sca.length;
        this.mComponentIDs = new String[arrySize];
        this.mComponentNames = new String[arrySize];
        this.mComponentVersions = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryComponent sc = sca[i];
            this.mComponentIDs[i] = sc.getID().toString();
            this.mComponentNames[i] = sc.getPath().getFullPathString() + sc.getName();
            this.mComponentVersions[i] = sc.getVersionNumber().getAsString();
        }
    }

    private void loadComponentTypes() throws RaplixException {
        ComponentTypeRefIDSet ctrids = this.mPlugin.getComponentTypes();
        MultiComponentTypeRefQuery mctrq = ctrids.getByIDsQuery();
        ComponentTypeRef[] ctra = mctrq.select();
        int arrySize = ctra.length;
        this.mComponentTypeIDs = new String[arrySize];
        this.mComponentTypeNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            ComponentTypeRef ctr = ctra[i];
            this.mComponentTypeIDs[i] = ctr.getID().toString();
            this.mComponentTypeNames[i] = ctr.getName();
        }
    }

    private void loadSystemServices() throws RaplixException {
        SystemServiceRefIDSet ssrids = this.mPlugin.getSystemServices();
        MultiSystemServiceRefQuery mssrq = ssrids.getByIDsQuery();
        SystemServiceRef[] ssra = mssrq.select();
        int arrySize = ssra.length;
        this.mSystemServiceIDs = new String[arrySize];
        this.mSystemServiceNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SystemServiceRef ssr = ssra[i];
            this.mSystemServiceIDs[i] = ssr.getID().toString();
            this.mSystemServiceNames[i] = ssr.getName();
        }
    }

    private void loadHostSets() throws RaplixException {
        HostSetIDSet hsids = this.mPlugin.getHostSets();
        MultiHostSetQuery mhsq = hsids.getByIDsQuery();
        SummaryHostSet[] shsa = mhsq.selectSummaryView();
        int arrySize = shsa.length;
        this.mHostSetIDs = new String[arrySize];
        this.mHostSetNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryHostSet shs = shsa[i];
            this.mHostSetIDs[i] = shs.getID().toString();
            this.mHostSetNames[i] = shs.getName();
        }
    }

    private void loadHostSearches() throws RaplixException {
        HostSearchIDSet hsids = this.mPlugin.getHostSearches();
        MultiHostSearchQuery mhsq = hsids.getByIDsQuery();
        SummaryHostSearch[] shsa = mhsq.selectSummaryView();
        int arrySize = shsa.length;
        this.mHostSearchIDs = new String[arrySize];
        this.mHostSearchNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryHostSearch shs = shsa[i];
            this.mHostSearchIDs[i] = shs.getID().toString();
            this.mHostSearchNames[i] = shs.getName();
        }
    }

    private void loadHostTypes() throws RaplixException {
        HostTypeIDSet htids = this.mPlugin.getHostTypes();
        MultiHostTypeQuery mhtq = htids.getByIDsQuery();
        SummaryHostType[] shta = mhtq.selectSummaryView();
        int arrySize = shta.length;
        this.mHostTypeIDs = new String[arrySize];
        this.mHostTypeNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryHostType sht = shta[i];
            this.mHostTypeIDs[i] = sht.getID().toString();
            this.mHostTypeNames[i] = sht.getName();
        }
    }

    private void loadFolders() throws RaplixException {
        FolderIDSet fids = this.mPlugin.getFolders();
        MultiFolderQuery mfq = fids.getByIDsQuery();
        SummaryFolder[] sfa = mfq.selectSummaryView();
        int arrySize = sfa.length;
        this.mFolderIDs = new String[arrySize];
        this.mFolderNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryFolder sf = sfa[i];
            this.mFolderIDs[i] = sf.getID().toString();
            this.mFolderNames[i] = sf.getParentFolderID().getFullPathString() + sf.getName();
        }
    }

    private void loadPluginDependencies() throws RaplixException {
        PluginIDSet pids = this.mPlugin.getDependencies();
        MultiPluginQuery mpq = pids.getByIDsQuery();
        SummaryPlugin[] spa = mpq.selectSummaryView();
        int arrySize = spa.length;
        this.mDependOnPluginIDs = new String[arrySize];
        this.mDependOnPluginNames = new String[arrySize];
        for (int i = 0; i < arrySize; ++i) {
            SummaryPlugin sp = spa[i];
            this.mDependOnPluginIDs[i] = sp.getID().toString();
            this.mDependOnPluginNames[i] = sp.getName();
        }
    }

    public void persist() throws RaplixException {
        this.mPlugin.setMenuOrder(this.mPluginMenuOrder);
        this.mPlugin.setUpdateCount(this.mUpdateCount);
        this.mPlugin.save();
    }
}

