/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.plugins;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SummaryPlugin;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class PluginDeleteNode
extends StandardObjectDeleteNode {
    public static final int DELETE_CONFIRM_COLSPAN = 4;
    private String mVersion = "";
    private String mMenuOrder = "";

    public PluginDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
        SummaryPlugin sp = (SummaryPlugin)this.getObject(candidate);
        this.mVersion = sp.getVersionNumber().getAsString();
        this.mMenuOrder = sp.getMenuOrder();
        this.preRender();
    }

    public int getDeleteConfirmColspan() {
        return 4;
    }

    public String getDeleteContext() {
        return "pluginDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        PluginID pid = (PluginID)candidate.getParent().getObjectID();
        return pid.getByIDQuery().selectSummaryView();
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.pluginDetailsURI(this.mObjectID.toString());
        String toolTip = "Show plug-in details";
        String nameLink = Util.standardLink(viewURI, toolTip, this.mName, "name=\"nameLink-" + this.mObjectID + "\"");
        String verLink = Util.standardLink(viewURI, toolTip, this.mVersion);
        String orderLink = Util.standardLink(viewURI, toolTip, this.mMenuOrder);
        String descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(verLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(orderLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

