/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.node.admin.NodeServiceException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.ui.web.LoggedOnServlet;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.util.logger.Logger;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LogDownloadAction
extends LoggedOnServlet
implements ParameterConstants {
    public static final String MSG_ERROR_MAJOR = "error.hostTrace.download";

    public void executeServlet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String mode = request.getParameter("mode");
        String id = LogDownloadAction.assertGetParam(request, "id");
        try {
            NodeAdminSubsystem mNodeAdmin = LogDownloadAction.getApplication().getNodeAdminSubsystem();
            response.setContentType("text/plain");
            response.setContentLength((int)mNodeAdmin.getLogFileSnapshot(new AppInstanceID(id)).getTotalSize());
            mNodeAdmin.downloadLogFile(new AppInstanceID(id), (OutputStream)response.getOutputStream());
        }
        catch (NodeServiceException e) {
            ServletErrors errors = new ServletErrors();
            Logger.debug("Exception caught in LogDownloadAction: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
        catch (RPCException e) {
            ServletErrors errors = new ServletErrors();
            Logger.debug("Exception caught in LogDownloadAction: " + e.getMessage(), e, this);
            errors.setMajorErrorKey(MSG_ERROR_MAJOR);
            errors.addMinorError(e.getMessage());
            request.setAttribute("error.location", (Object)errors);
            this.forwardRequest(request, response, "/errorhome.jsp");
        }
    }
}

