/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSearchesListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostTypesListBean;
import com.raplix.util.enum.NoSuchEnumException;
import org.apache.struts.util.MessageResources;

public class HostsListBean
extends ServletListBean {
    private static final HostOrder DEFAULT_SORT_ORDER = HostOrder.BY_APP_TYPE_ASC;
    private String[] mHostNames = new String[0];
    private String[] mHostDescriptions = new String[0];
    private String[] mHostIDs = new String[0];
    private String[] mTypeNamesOfHost = new String[0];
    private String[] mHostOSNames = new String[0];
    private String[] mHostOSVersions = new String[0];
    private String[] mHostOSArchitectures = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private boolean[] mIsPrepared = new boolean[0];
    private String[] mAppInstances = new String[0];
    private String[] mTypeNames = new String[0];
    private String[] mTypeIDs = new String[0];
    private String[] mFilterNames = new String[0];
    private String[] mFilterIDs = new String[0];
    private String[] mPlatformHostSetNames = new String[0];
    private String[] mPlatformHostSetIDs = new String[0];
    private String[] mAppTypeNames = new String[0];
    private String mCurrentFilterName = "";
    private String mCurrentFilterID = "";
    private String mSinglePrepareHostID = null;
    private String mSingleUpdateHostID = null;
    private boolean mShowPreparedness = false;
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mFindAppType = "";
    private String mFindHostTypeID = "";
    private String mFindPlatformHostSetID = "";
    private String mMode = "";
    private String mIsSearchFiltered = "false";
    private boolean mHasExecuteOnSystemFolder = true;
    private boolean mHasWriteOnHosts = true;

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getHostOSNames() {
        return this.mHostOSNames;
    }

    public String[] getHostOSVersions() {
        return this.mHostOSVersions;
    }

    public String[] getHostOSArchitectures() {
        return this.mHostOSArchitectures;
    }

    public String[] getHostDescriptions() {
        return this.mHostDescriptions;
    }

    public String[] getHostIDs() {
        return this.mHostIDs;
    }

    public String[] getTypeNamesOfHosts() {
        return this.mTypeNamesOfHost;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public boolean[] getIsPrepared() {
        return this.mIsPrepared;
    }

    public String[] getAppInstances() {
        return this.mAppInstances;
    }

    public String[] getTypeNames() {
        return this.mTypeNames;
    }

    public String[] getTypeIDs() {
        return this.mTypeIDs;
    }

    public String[] getFilterNames() {
        return this.mFilterNames;
    }

    public String[] getFilterIDs() {
        return this.mFilterIDs;
    }

    public String[] getPlatformHostSetNames() {
        return this.mPlatformHostSetNames;
    }

    public String[] getPlatformHostSetIDs() {
        return this.mPlatformHostSetIDs;
    }

    public String[] getAppTypeNames() {
        return this.mAppTypeNames;
    }

    public String getCurrentFilterName() {
        return this.mCurrentFilterName;
    }

    public String getCurrentFilterID() {
        return this.mCurrentFilterID;
    }

    public String getSinglePrepareHostID() {
        return this.mSinglePrepareHostID;
    }

    public String getSingleUpdateHostID() {
        return this.mSingleUpdateHostID;
    }

    public boolean getShowPreparedness() {
        return this.mShowPreparedness;
    }

    public String getTypeID() {
        return "we use struts";
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String getFindAppType() {
        return this.mFindAppType;
    }

    public String getFindHostTypeID() {
        return this.mFindHostTypeID;
    }

    public String getFindPlatformHostSetID() {
        return this.mFindPlatformHostSetID;
    }

    public String getIsSearchFiltered() {
        return this.mIsSearchFiltered;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getHasExecuteOnSystemFolder() {
        return this.mHasExecuteOnSystemFolder;
    }

    public boolean getHasWriteOnHosts() {
        return this.mHasWriteOnHosts;
    }

    public void setFindAppType(String findAppType) {
        this.mFindAppType = findAppType;
    }

    public void setFindPlatformHostSetID(String findPlatformHostSetID) {
        this.mFindPlatformHostSetID = findPlatformHostSetID;
    }

    public void setFindHostTypeID(String findHostTypeID) {
        this.mFindHostTypeID = findHostTypeID;
    }

    public void setCurrentFilterID(String s) {
        this.mCurrentFilterID = s;
    }

    public void setSinglePrepareHostID(String s) {
        this.mSinglePrepareHostID = s;
    }

    public void setSingleUpdateHostID(String s) {
        this.mSingleUpdateHostID = s;
    }

    public void setShowPreparedness(boolean b) {
        this.mShowPreparedness = b;
    }

    public void setIsSearchFiltered(String isSearchFiltered) {
        this.mIsSearchFiltered = isSearchFiltered;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void generateList() throws RaplixException {
        MultiHostQuery query = MultiHostQuery.all();
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.select());
    }

    public void loadAllHosts() throws RaplixException {
        MultiHostQuery query = MultiHostQuery.all();
        this.generateOutputArrays(query.select());
    }

    public void generateListWithSearch() throws RaplixException {
        MultiHostQuery query;
        if (this.mCurrentFilterID == null || this.mCurrentFilterID.equals("") || this.mCurrentFilterID.equals("---")) {
            this.mCurrentFilterName = "";
            query = MultiHostQuery.all();
        } else {
            HostSearch search = new HostSearchID(this.mCurrentFilterID).getByIDQuery().select();
            this.mCurrentFilterName = search.getName();
            query = search.getCriteria().getAllHostsQuery();
        }
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.select());
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery inQuery) throws RaplixException {
        ObjectID id;
        MultiHostQuery query = (MultiHostQuery)inQuery;
        if (!this.mFindAppType.equals("") && !this.mFindAppType.equals("---")) {
            AppType[] appTypeArray = new AppType[1];
            try {
                AppType app;
                appTypeArray[0] = app = AppType.FACTORY.get(this.mFindAppType.toUpperCase());
                query.setAppTypeFilter(appTypeArray);
            }
            catch (NoSuchEnumException e) {
                // empty catch block
            }
            query.setAppTypeFilter(appTypeArray);
        }
        if (!this.mFindHostTypeID.equals("") && !this.mFindHostTypeID.equals("---")) {
            id = new HostTypeID(this.mFindHostTypeID);
            query.setHostTypeFilter((HostTypeID)id);
        }
        if (!this.mFindPlatformHostSetID.equals("") && !this.mFindPlatformHostSetID.equals("---")) {
            id = new HostSetID(this.mFindPlatformHostSetID);
            query.setHostSetFilter((HostSetID)id);
        }
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(HostOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return true;
    }

    public void loadHostPageArrays() throws RaplixException {
        HostTypesListBean typesList = new HostTypesListBean();
        typesList.fetchAllHostTypes();
        this.mTypeNames = typesList.getHostTypeNames();
        this.mTypeIDs = typesList.getHostTypeIDs();
        HostSearchesListBean searchesList = new HostSearchesListBean();
        searchesList.loadAllHostSearches();
        this.mFilterNames = searchesList.getSearchNames();
        this.mFilterIDs = searchesList.getSearchIDs();
        HostSetsListBean setsList = new HostSetsListBean();
        setsList.loadAllPlatforms();
        this.mPlatformHostSetNames = setsList.getNames();
        this.mPlatformHostSetIDs = setsList.getIDs();
        this.mPlatformHostSetIDs[0] = "---";
        this.mPlatformHostSetNames[0] = "";
        AppType[] allAppTypes = AppType.FACTORY.getAll();
        this.mAppTypeNames = new String[allAppTypes.length];
        for (int i = 0; i < allAppTypes.length; ++i) {
            this.mAppTypeNames[i] = allAppTypes[i].toString().toLowerCase();
        }
    }

    private void generateOutputArrays(Host[] inHosts) throws RaplixException {
        this.mHostNames = new String[inHosts.length];
        this.mHostDescriptions = new String[inHosts.length];
        this.mHostIDs = new String[inHosts.length];
        this.mIsHidden = new boolean[inHosts.length];
        this.mIsPrepared = new boolean[inHosts.length];
        this.mTypeNamesOfHost = new String[inHosts.length];
        this.mHostOSNames = new String[inHosts.length];
        this.mHostOSVersions = new String[inHosts.length];
        this.mHostOSArchitectures = new String[inHosts.length];
        this.mAppInstances = new String[inHosts.length];
        for (int i = 0; i < inHosts.length; ++i) {
            this.mHostNames[i] = inHosts[i].getName();
            this.mHostDescriptions[i] = inHosts[i].getDescription();
            this.mHostIDs[i] = inHosts[i].getID().toString();
            this.mIsHidden[i] = inHosts[i].getVisibility().equals(Visibility.HIDDEN);
            this.mTypeNamesOfHost[i] = inHosts[i].getHostType().getName();
            MachineInfo mi = inHosts[i].getMachineInfo();
            if (mi == null) {
                this.mHostOSNames[i] = "";
                this.mHostOSVersions[i] = "";
                this.mHostOSArchitectures[i] = "";
            } else {
                this.mHostOSNames[i] = mi.getOSName();
                this.mHostOSVersions[i] = mi.getOSVersion();
                this.mHostOSArchitectures[i] = mi.getOSArch();
            }
            this.mAppInstances[i] = HostsListBean.createAppInstanceString(inHosts[i]);
            this.mIsPrepared[i] = this.mShowPreparedness ? this.isPrepared(inHosts[i]) : true;
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mHostIDs);
        this.mHasExecuteOnSystemFolder = PermissionChecker.hasExecuteOnSystemFolder();
        this.mHasWriteOnHosts = PermissionChecker.hasWriteOnHosts();
    }

    private boolean isPrepared(Host host) throws RaplixException {
        return host.getAppRA() == null || host.isPrepared();
    }

    static String createAppInstanceString(Host host) {
        StringBuffer sb = new StringBuffer();
        MessageResources messages = ApplicationResources.getMessageResources();
        if (host.getAppMS() != null) {
            sb.append(messages.getMessage("label.hosts.ms.acronym"));
        }
        if (host.getAppLD() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(messages.getMessage("label.hosts.ld.acronym"));
        }
        if (host.getAppRA() != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(messages.getMessage("label.hosts.ra.acronym"));
        }
        if (host.isVirtual()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(messages.getMessage("label.hosts.virtual"));
        }
        return sb.toString();
    }
}

