/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class HostsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CREATE = "error.hosts.create";
    public static final String MSG_ERROR_CREATE_TYPE = "error.hosts.create.type";
    public static final String MSG_ERROR_EDIT = "error.hosts.edit";
    public static final String MSG_ERROR_CANCEL = "error.hosts.cancel";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.hosts.save.major";
    public static final String MSG_ERROR_SAVE_DELETED_OBJECT = "error.hosts.save.deletedObject";
    private static final String MSG_ERROR_NO_RA_CONNECTION_TYPE = "error.hosts.save.noRAconnectionType";
    private static final String MSG_ERROR_NO_LD_CONNECTION_TYPE = "error.hosts.save.noLDconnectionType";
    public static final String MSG_ERROR_SAVE_BAD_RA_PORT = "error.hosts.save.badRAPort";
    public static final String MSG_ERROR_SAVE_BAD_LD_PORT = "error.hosts.save.badLDPort";
    public static final String MSG_ERROR_HISTORY = "error.hosts.history";
    public static final String MSG_ERROR_SHOW_PARENT = "error.hosts.showParent";

    public ServletBean createBean(HttpServletRequest request) {
        NotificationRPCInterface notInf = HostsHandleAction.getApplication().getNotificationInterface();
        return new HostsBean(notInf);
    }

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = HostsHandleAction.assertGetParam(request, "mode");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through HostsHandleAction: " + mode, this);
        }
        servletInfo.setSaveInSession(false);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("history")) {
            this.handleHistory(request, servletInfo);
        } else if (mode.equals("view")) {
            this.handleView(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("changetype")) {
            this.handleChangeType(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else if (mode.equals("saveasconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("showparent")) {
            this.handleShowParent(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostsHandleAction.");
        }
    }

    public String getDefaultPage() {
        return "/hosts/hostDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = HostsHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("history")) {
            return MSG_ERROR_HISTORY;
        }
        if (mode.equals("view")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("changetype")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveasconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("refresh")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("showparent")) {
            return MSG_ERROR_SHOW_PARENT;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostsHandleAction.");
    }

    private void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String typeID = request.getParameter("typeID");
        String description = request.getParameter("description");
        if (typeID.equals("---")) {
            typeID = SystemPluginConstants.getInstance().DEFAULT_HOST_TYPE_ID.toString();
        }
        hb.createHost(name, description, typeID);
        hb.loadPermissionLookaheads();
        servletInfo.setDestPage("/hosts/hostEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        hb.setMode("details");
        String id = HostsHandleAction.assertGetParam(request, "id");
        hb.fetchHost(id);
        servletInfo.setDestPage("/hosts/hostDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        String id = HostsHandleAction.assertGetParam(request, "id");
        hb.fetchHost(id);
        servletInfo.setDestPage("/hosts/hostEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleHistory(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        String id = HostsHandleAction.assertGetParam(request, "id");
        hb.fetchHost(id);
        hb.fetchHostHistoryInfo();
        servletInfo.setDestPage("/hosts/hostHistory.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleView(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        String id = HostsHandleAction.assertGetParam(request, "id");
        hb.fetchHost(id);
        hb.setMode("view");
        servletInfo.setDestPage("/hosts/hostConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        if (!this.isValidValues(hb, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            hb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        try {
            hb.saveHost();
        }
        catch (UpdateIncompleteException uie) {
            servletInfo.getErrors().addMinorError(uie);
            hb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (RaplixException ex) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(ex.getMessage());
            hb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String dest = this.determineDestination(hb);
        servletInfo.setDestPage(dest);
        servletInfo.setShouldRedirect(true);
    }

    private void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        hb.setPreviousIsNew(false);
        hb.setIsNew(true);
        servletInfo.setDestPage("/hosts/hostConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleChangeType(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        hb.setMode("edit");
        servletInfo.setDestPage("/hosts/hostEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setDestPage("/Hosts");
        servletInfo.setShouldRedirect(true);
    }

    private void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        hb.setMode("edit");
        hb.setIsNew(hb.getPreviousIsNew());
        servletInfo.setDestPage("/hosts/hostEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        if (!this.isValidValues(hb, servletInfo.getErrors())) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            hb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        try {
            hb.saveHost();
        }
        catch (RaplixException ex) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(ex.getMessage());
            hb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String dest = this.determineDestination(hb);
        servletInfo.setDestPage(dest);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        hb.setMode("edit");
        servletInfo.setDestPage("/hosts/hostEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleShowParent(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostsBean hb = (HostsBean)servletInfo.getBean();
        this.readFromRequest(request, hb);
        String newID = "";
        try {
            newID = HostsBean.getSummaryHostByName(hb.getParentHostName()).getID().toString();
        }
        catch (RaplixException ex) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SHOW_PARENT);
            servletInfo.getErrors().addMinorError(ex.getMessage());
            hb.setMode("details");
            servletInfo.setDestPage("/hosts/hostDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostDetails?mode=details&id=" + newID);
        servletInfo.setShouldRedirect(true);
    }

    private void readFromRequest(HttpServletRequest request, HostsBean hb) throws RaplixException {
        String name;
        hb.setName(HostsHandleAction.assertGetParam(request, "name"));
        hb.setDescription(HostsHandleAction.assertGetParam(request, "description"));
        hb.setID(HostsHandleAction.assertGetParam(request, "id"));
        hb.setIsNew(HostsHandleAction.assertGetParam(request, "isNew").equals("true"));
        hb.setPreviousIsNew(request.getParameter("previousIsNew") != null);
        hb.setIsHidden(request.getParameter("isHidden") != null);
        hb.setUpdateCount(Integer.parseInt(HostsHandleAction.assertGetParam(request, "updateCount")));
        hb.setMode(HostsHandleAction.assertGetParam(request, "mode"));
        hb.setHostPhysicality(HostsHandleAction.assertGetParam(request, "hostPhysicality"));
        hb.setParentHostName(HostsHandleAction.assertGetParam(request, "parentHostName"));
        hb.setPrepareHost(request.getParameter("prepareHost") != null);
        hb.setOSName(HostsHandleAction.assertGetParam(request, "OSName"));
        hb.setOSVersion(HostsHandleAction.assertGetParam(request, "OSVersion"));
        hb.setOSArchitecture(HostsHandleAction.assertGetParam(request, "OSArchitecture"));
        hb.setLastPrepared(HostsHandleAction.assertGetParam(request, "lastPrepared"));
        hb.setHasExecuteOnSystemFolder(new Boolean(request.getParameter("hasExecuteOnSystemFolder")));
        hb.setHasWriteOnHosts(new Boolean(request.getParameter("hasWriteOnHosts")));
        hb.setInstalledComponentID(request.getParameter("installedComponentID"));
        hb.setComponentName(request.getParameter("componentName"));
        hb.setIsMS(HostsHandleAction.assertGetParam(request, "isMasterServer").equals("true"));
        hb.setMasterServerIPAddress(HostsHandleAction.assertGetParam(request, "masterServerIPAddress"));
        hb.setMasterServerPort(HostsHandleAction.assertGetParam(request, "masterServerPort"));
        hb.setIsLD(request.getParameter("isLocalDistributor") != null);
        hb.setLocalDistributorAppID(HostsHandleAction.assertGetParam(request, "localDistributorID"));
        hb.setLocalDistributorConnectionType(HostsHandleAction.assertGetParam(request, "localDistributorConnectionType"));
        hb.setLocalDistributorIPAddress(HostsHandleAction.assertGetParam(request, "localDistributorIPAddress"));
        hb.setLocalDistributorParentType(HostsHandleAction.assertGetParam(request, "localDistributorParentType"));
        hb.setLocalDistributorParentHost(HostsHandleAction.assertGetParam(request, "localDistributorParentHost"));
        hb.setLocalDistributorParams(HostsHandleAction.assertGetParam(request, "localDistributorParams"));
        hb.setLocalDistributorPort(HostsHandleAction.assertGetParam(request, "localDistributorPort"));
        hb.setLDUpdateCount(Integer.parseInt(HostsHandleAction.assertGetParam(request, "localDistributorUpdateCount")));
        hb.setIsRA(request.getParameter("isRemoteAgent") != null);
        hb.setRemoteAgentAppID(HostsHandleAction.assertGetParam(request, "remoteAgentID"));
        hb.setRemoteAgentConnectionType(HostsHandleAction.assertGetParam(request, "remoteAgentConnectionType"));
        hb.setRemoteAgentIPAddress(HostsHandleAction.assertGetParam(request, "remoteAgentIPAddress"));
        hb.setRemoteAgentParentType(HostsHandleAction.assertGetParam(request, "remoteAgentParentType"));
        hb.setRemoteAgentParentHost(HostsHandleAction.assertGetParam(request, "remoteAgentParentHost"));
        hb.setRemoteAgentParams(HostsHandleAction.assertGetParam(request, "remoteAgentParams"));
        hb.setRemoteAgentPort(HostsHandleAction.assertGetParam(request, "remoteAgentPort"));
        hb.setRAUpdateCount(Integer.parseInt(HostsHandleAction.assertGetParam(request, "remoteAgentUpdateCount")));
        hb.fetchHostsWithParentApps();
        hb.fetchChildrenInfo(HostsHandleAction.assertGetParam(request, "id"));
        String[] newHostSetIDs = Util.arrayifyCommaSeparated(HostsHandleAction.assertGetParam(request, "newHostSetIDs"));
        if (newHostSetIDs != null) {
            hb.setHostSetIDs(newHostSetIDs);
            hb.updateHostSetInfo();
        }
        hb.setTypeID(HostsHandleAction.assertGetParam(request, "typeID"));
        int i = 0;
        Vector<String> names = new Vector<String>();
        Vector<Boolean> highlights = new Vector<Boolean>();
        Vector<String> values = new Vector<String>();
        while ((name = request.getParameter("attrname" + i)) != null) {
            boolean highlight = request.getParameter("attrHighlights" + i) != null;
            String value = HostsHandleAction.assertGetParam(request, "attrvalue" + i);
            names.add(name);
            highlights.add(new Boolean(highlight));
            values.add(value);
            ++i;
        }
        Boolean[] boolObjs = highlights.toArray(new Boolean[0]);
        boolean[] attrHighlights = new boolean[boolObjs.length];
        for (i = 0; i < boolObjs.length; ++i) {
            attrHighlights[i] = boolObjs[i];
        }
        hb.setAttrNames(names.toArray(new String[0]));
        hb.setAttrHighlights(attrHighlights);
        hb.setAttrValues(values.toArray(new String[0]));
        hb.updateHostTypeInfo();
    }

    private boolean isValidValues(HostsBean hb, ServletErrors errors) {
        boolean isAllValid = true;
        if (hb.getHostPhysicality().equals("physical")) {
            String ct;
            int port;
            if (hb.getIsLocalDistributor()) {
                if (hb.getLocalDistributorConnectionType().equals("none")) {
                    errors.addMinorErrorKey(MSG_ERROR_NO_LD_CONNECTION_TYPE);
                    isAllValid = false;
                }
                try {
                    port = Integer.parseInt(hb.getLocalDistributorPort());
                    ct = hb.getLocalDistributorConnectionType();
                    AppInstance.validatePort(port, hb.getStringAsConnectionType(ct));
                }
                catch (NumberFormatException e) {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_BAD_LD_PORT);
                    isAllValid = false;
                }
                catch (HostDBException e) {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_BAD_LD_PORT);
                    isAllValid = false;
                }
            }
            if (hb.getIsRemoteAgent()) {
                if (hb.getRemoteAgentConnectionType().equals("none")) {
                    errors.addMinorErrorKey(MSG_ERROR_NO_RA_CONNECTION_TYPE);
                    isAllValid = false;
                }
                try {
                    port = Integer.parseInt(hb.getRemoteAgentPort());
                    ct = hb.getRemoteAgentConnectionType();
                    AppInstance.validatePort(port, hb.getStringAsConnectionType(ct));
                }
                catch (NumberFormatException e) {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_BAD_RA_PORT);
                    isAllValid = false;
                }
                catch (HostDBException e) {
                    errors.addMinorErrorKey(MSG_ERROR_SAVE_BAD_RA_PORT);
                    isAllValid = false;
                }
            }
        }
        return isAllValid;
    }

    private String determineDestination(HostsBean hb) throws RaplixException {
        String dest = "/Hosts";
        NodeManagementServices nms = HostsHandleAction.getApplication().getNodeManagementServices();
        if (hb.getPrepareHost()) {
            try {
                AppInstanceID raID = new AppInstanceID(hb.getRemoteAgentAppID());
                AppInstanceID ldID = new AppInstanceID(hb.getLocalDistributorAppID());
                if (hb.getIsRemoteAgent() && nms.needsUpgrade(raID) || hb.getIsLocalDistributor() && nms.needsUpgrade(ldID)) {
                    dest = dest + "?singleUpdateHostID=" + hb.getID();
                    return dest;
                }
            }
            catch (RaplixException re) {
                // empty catch block
            }
            if (hb.getIsRemoteAgent()) {
                dest = dest + "?singlePrepareHostID=" + hb.getID();
                return dest;
            }
        }
        return dest;
    }
}

