/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UIActionException;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostHistoryBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostTypesListBean;
import com.raplix.util.ArrayEdit;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import org.apache.struts.util.MessageResources;

public class HostsBean
extends ServletBean {
    public static final String CONN_NONE = "none";
    private static final String CONN_RAW = "raw";
    public static final String CONN_SSH = "ssh";
    private static final String CONN_SSL = "ssl";
    private static final String MSG_ERROR_HOST_NOT_FOUND = "ui.web.error.hosts.hostnotfound";
    private NotificationRPCInterface mNotInf = null;
    protected HostHistoryBean mHistoryBean = null;
    private String mName = "";
    private String mDescription = "";
    private String mID = "";
    private boolean mIsNew = false;
    private boolean mPreviousIsNew = false;
    private boolean mIsHidden = false;
    private boolean mIsSupported = false;
    private int mUpdateCount = 0;
    private String mMode = "";
    private String mHostPhysicality = "physical";
    private boolean mPrepareHost = false;
    private String mOSName = "";
    private String mOSVersion = "";
    private String mOSArchitecture = "";
    private String mLastPrepared = "";
    private String[] mChildrenNames = new String[0];
    private String[] mChildrenIDs = new String[0];
    private String mParentHostName = "";
    private String mTypeID = "";
    private String mTypeName = "";
    private String mComponentName = null;
    private String mComponentID = null;
    private String mInstalledComponentID = null;
    private String[] mAttrNames = new String[0];
    private String[] mAttrDefaults = new String[0];
    private boolean[] mAttrHighlights = new boolean[0];
    private String[] mAttrValues = new String[0];
    private String[] mHostTypeNames = new String[0];
    private String[] mHostTypeIDs = new String[0];
    private String[] mHostSetNames = new String[0];
    private String[] mHostSetIDs = new String[0];
    private String[] mOtherHostSetNames = new String[0];
    private String[] mOtherHostSetIDs = new String[0];
    private boolean mIsRA = false;
    private boolean mIsLD = false;
    private boolean mIsMS = false;
    private String mMSappID = "";
    private String mLDappID = "";
    private String mRAappID = "";
    private int mLDUpdateCount = 0;
    private int mRAUpdateCount = 0;
    private String mLDConnectionType = "none";
    private String mRAConnectionType = "none";
    private String mMSIPAddress = "";
    private String mLDIPAddress = "";
    private String mRAIPAddress = "";
    private String mMSPort = "";
    private String mRAPort = "";
    private String mLDPort = "";
    private String mRAParentType = "Master Server";
    private String mLDParentType = "Master Server";
    private String[] mAllMSHostNames = new String[0];
    private String[] mAllLDHostNames = new String[0];
    private String mRAParentHost = "";
    private String mLDParentHost = "";
    private String mRAParams = "";
    private String mLDParams = "";
    private boolean mHasExecuteOnSystemFolder = true;
    private boolean mHasWriteOnHosts = true;

    public HostsBean(NotificationRPCInterface notInf) {
        this.mNotInf = notInf;
    }

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getPreviousIsNew() {
        return this.mPreviousIsNew;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public String getMode() {
        return this.mMode;
    }

    public String[] getNothing() {
        return new String[0];
    }

    public String getHostPhysicality() {
        return this.mHostPhysicality;
    }

    public boolean getPrepareHost() {
        return this.mPrepareHost;
    }

    public String getOSName() {
        return this.mOSName;
    }

    public String getOSVersion() {
        return this.mOSVersion;
    }

    public String getOSArchitecture() {
        return this.mOSArchitecture;
    }

    public String getLastPrepared() {
        return this.mLastPrepared;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public String getComponentID() {
        return this.mComponentID;
    }

    public String getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public boolean getIsSupported() {
        return this.mIsSupported;
    }

    public String[] getChildrenNames() {
        return this.mChildrenNames;
    }

    public String[] getChildrenIDs() {
        return this.mChildrenIDs;
    }

    public String getParentHostName() {
        return this.mParentHostName;
    }

    public String getTypeID() {
        return this.mTypeID;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public String[] getAttrNames() {
        return this.mAttrNames;
    }

    public String[] getAttrDefaults() {
        return this.mAttrDefaults;
    }

    public boolean[] getAttrHighlights() {
        return this.mAttrHighlights;
    }

    public String[] getAttrValues() {
        return this.mAttrValues;
    }

    public String[] getHostTypeNames() {
        return this.mHostTypeNames;
    }

    public String[] getHostTypeIDs() {
        return this.mHostTypeIDs;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String[] getOtherHostSetNames() {
        return this.mOtherHostSetNames;
    }

    public String[] getOtherHostSetIDs() {
        return this.mOtherHostSetIDs;
    }

    public boolean getIsRemoteAgent() {
        return this.mIsRA;
    }

    public boolean getIsLocalDistributor() {
        return this.mIsLD;
    }

    public boolean getIsMasterServer() {
        return this.mIsMS;
    }

    public String[] getAllParentTypes() {
        return new String[]{"Master Server", "Local Distributor"};
    }

    public String[] getAllParentTypeLabels() {
        MessageResources messages = ApplicationResources.getMessageResources();
        return new String[]{messages.getMessage("label.hostDetails.ms"), messages.getMessage("label.hostDetails.ld")};
    }

    public String[] getAllConnectionTypes() {
        return new String[]{CONN_NONE, CONN_RAW, CONN_SSH, CONN_SSL};
    }

    public String[] getAllConnectionTypeLabels() {
        MessageResources messages = ApplicationResources.getMessageResources();
        return new String[]{"", messages.getMessage("label.hostDetails.raw"), messages.getMessage("label.hostDetails.ssh"), messages.getMessage("label.hostDetails.ssl")};
    }

    public String getMasterServerAppID() {
        return this.mMSappID;
    }

    public String getLocalDistributorAppID() {
        return this.mLDappID;
    }

    public String getRemoteAgentAppID() {
        return this.mRAappID;
    }

    public int getLDUpdateCount() {
        return this.mLDUpdateCount;
    }

    public int getRAUpdateCount() {
        return this.mRAUpdateCount;
    }

    public String getLocalDistributorConnectionType() {
        return this.mLDConnectionType;
    }

    public String getRemoteAgentConnectionType() {
        return this.mRAConnectionType;
    }

    public String getMasterServerIPAddress() {
        return this.mMSIPAddress;
    }

    public String getLocalDistributorIPAddress() {
        return this.mLDIPAddress;
    }

    public String getRemoteAgentIPAddress() {
        return this.mRAIPAddress;
    }

    public String getMasterServerPort() {
        return this.mMSPort;
    }

    public String getLocalDistributorPort() {
        return this.mLDPort;
    }

    public String getRemoteAgentPort() {
        return this.mRAPort;
    }

    public String getRemoteAgentParentType() {
        return this.mRAParentType;
    }

    public String getRemoteAgentParentHost() {
        return this.mRAParentHost;
    }

    public String getRemoteAgentParams() {
        return this.mRAParams;
    }

    public String getLocalDistributorParentType() {
        return this.mLDParentType;
    }

    public String getLocalDistributorParentHost() {
        return this.mLDParentHost;
    }

    public String getLocalDistributorParams() {
        return this.mLDParams;
    }

    public String[] getAllMSHostNames() {
        return this.mAllMSHostNames;
    }

    public String[] getAllLDHostNames() {
        return this.mAllLDHostNames;
    }

    public boolean getHasExecuteOnSystemFolder() {
        return this.mHasExecuteOnSystemFolder;
    }

    public boolean getHasWriteOnHosts() {
        return this.mHasWriteOnHosts;
    }

    public HostHistoryBean getHostHistoryBean() {
        if (this.mHistoryBean == null) {
            this.mHistoryBean = new HostHistoryBean(this.mNotInf);
        }
        return this.mHistoryBean;
    }

    public void setName(String inName) {
        this.mName = inName;
    }

    public void setDescription(String inDescription) {
        this.mDescription = inDescription;
    }

    public void setID(String in) {
        this.mID = in;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setPreviousIsNew(boolean previousIsNew) {
        this.mPreviousIsNew = previousIsNew;
    }

    public void setIsHidden(boolean in) {
        this.mIsHidden = in;
    }

    public void setUpdateCount(int in) {
        this.mUpdateCount = in;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setHostPhysicality(String in) {
        this.mHostPhysicality = in;
    }

    public void setPrepareHost(boolean prepareHost) {
        this.mPrepareHost = prepareHost;
    }

    public void setOSName(String OSName) {
        this.mOSName = OSName;
    }

    public void setOSVersion(String OSVersion) {
        this.mOSVersion = OSVersion;
    }

    public void setOSArchitecture(String OSArchitecture) {
        this.mOSArchitecture = OSArchitecture;
    }

    public void setIsSupported(boolean IsSupported) {
        this.mIsSupported = IsSupported;
    }

    public void setLastPrepared(String lastPrepared) {
        this.mLastPrepared = lastPrepared;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public void setInstalledComponentID(String installComponentID) {
        this.mInstalledComponentID = installComponentID;
    }

    public void setParentHostName(String in) {
        this.mParentHostName = in;
    }

    public void setTypeID(String inTypeID) {
        this.mTypeID = inTypeID;
    }

    public void setAttrNames(String[] inNames) {
        this.mAttrNames = inNames;
    }

    public void setAttrDefaults(String[] in) {
        this.mAttrDefaults = in;
    }

    public void setAttrHighlights(boolean[] in) {
        this.mAttrHighlights = in;
    }

    public void setAttrValues(String[] in) {
        this.mAttrValues = in;
    }

    public void setHostSetIDs(String[] hostSetIDs) {
        this.mHostSetIDs = hostSetIDs;
    }

    public void setIsRA(boolean in) {
        this.mIsRA = in;
    }

    public void setIsLD(boolean in) {
        this.mIsLD = in;
    }

    public void setIsMS(boolean in) {
        this.mIsMS = in;
    }

    public void setMasterServerAppID(String in) {
        this.mMSappID = in;
    }

    public void setLocalDistributorAppID(String in) {
        this.mLDappID = in;
    }

    public void setRemoteAgentAppID(String in) {
        this.mRAappID = in;
    }

    public void setLDUpdateCount(int in) {
        this.mLDUpdateCount = in;
    }

    public void setRAUpdateCount(int in) {
        this.mRAUpdateCount = in;
    }

    public void setLocalDistributorConnectionType(String in) {
        this.mLDConnectionType = in;
    }

    public void setRemoteAgentConnectionType(String in) {
        this.mRAConnectionType = in;
    }

    public void setMasterServerIPAddress(String in) {
        this.mMSIPAddress = in;
    }

    public void setLocalDistributorIPAddress(String in) {
        this.mLDIPAddress = in;
    }

    public void setRemoteAgentIPAddress(String in) {
        this.mRAIPAddress = in;
    }

    public void setMasterServerPort(String in) {
        this.mMSPort = in;
    }

    public void setLocalDistributorPort(String in) {
        this.mLDPort = in;
    }

    public void setRemoteAgentPort(String in) {
        this.mRAPort = in;
    }

    public void setRemoteAgentParentType(String in) {
        this.mRAParentType = in;
    }

    public void setRemoteAgentParentHost(String in) {
        this.mRAParentHost = in;
    }

    public void setRemoteAgentParams(String in) {
        this.mRAParams = in;
    }

    public void setLocalDistributorParentType(String in) {
        this.mLDParentType = in;
    }

    public void setLocalDistributorParentHost(String in) {
        this.mLDParentHost = in;
    }

    public void setLocalDistributorParams(String in) {
        this.mLDParams = in;
    }

    public void setHasExecuteOnSystemFolder(boolean in) {
        this.mHasExecuteOnSystemFolder = in;
    }

    public void setHasWriteOnHosts(boolean in) {
        this.mHasWriteOnHosts = in;
    }

    public void createHost(String name, String description, String typeID) throws RaplixException {
        this.mName = name;
        this.mDescription = description;
        this.mID = "";
        this.mIsNew = true;
        this.mIsHidden = false;
        this.mUpdateCount = 0;
        this.mHostPhysicality = "physical";
        this.mOSName = "";
        this.mOSVersion = "";
        this.mOSArchitecture = "";
        this.mIsSupported = false;
        this.mLastPrepared = ApplicationResources.getMessage("label.hosts.notprepared");
        this.mPrepareHost = true;
        this.fetchHostTypeInfo(new HostTypeID(typeID).getByIDQuery().select());
        this.fetchHostSetInfo(new HostSetIDSet());
        this.fetchHostsWithParentApps();
    }

    public void fetchHost(String id) throws RaplixException {
        Host host = new HostID(id).getByIDQuery().select();
        this.mName = host.getName();
        this.mDescription = host.getDescription();
        this.mID = id;
        this.mIsNew = false;
        this.mIsHidden = host.getVisibility().equals(Visibility.HIDDEN);
        this.mUpdateCount = host.getUpdateCount();
        this.mHostPhysicality = host.isVirtual() ? "virtual" : "physical";
        this.mParentHostName = host.isVirtual() ? host.getParentHostID().getByIDQuery().selectSummaryView().getName() : "";
        this.loadPermissionLookaheads();
        if (host.getInstalledComponentID() != null) {
            this.mInstalledComponentID = host.getInstalledComponentID().toString();
            InstalledComponent targetComp = host.getInstalledComponentID().getByIDQuery().select();
            this.mComponentID = targetComp.getComponentID().toString();
            SummaryComponent targetableInstComp = targetComp.getComponentID().getByIDQuery().selectSummaryView();
            this.mComponentName = targetableInstComp.getFullName();
        }
        this.fetchChildrenInfo(id);
        this.fetchAppInstanceInfo(host);
        this.fetchHostTypeInfo(host.getHostType());
        this.fetchHostSetInfo(host.getHostSetIDSet());
        this.fetchOverrideValues(host);
        this.fetchHostsWithParentApps();
        this.fetchMachineInfo(host);
    }

    public void fetchHostHistoryInfo() throws RaplixException {
        this.mHistoryBean = new HostHistoryBean(this.mNotInf);
        this.mHistoryBean.loadHostHistory(this.mID);
    }

    public void updateHostTypeInfo() throws RaplixException {
        HostType newType = new HostTypeID(this.mTypeID).getByIDQuery().select();
        this.fetchHostTypeInfo(newType);
    }

    public void updateHostSetInfo() throws RaplixException {
        HostSetIDSet setSet = this.convertToHostSetSet(this.mHostSetIDs);
        this.fetchHostSetInfo(setSet);
    }

    public void fetchChildrenInfo(String id) throws RaplixException {
        if (id == null || id.equals("") || id.equals("---")) {
            this.mChildrenNames = new String[0];
            this.mChildrenIDs = new String[0];
            return;
        }
        SummaryHost[] children = new HostID(id).getVirtualChildHostsQuery().selectSummaryView();
        this.mChildrenNames = new String[children.length];
        this.mChildrenIDs = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            this.mChildrenNames[i] = children[i].getName();
            this.mChildrenIDs[i] = children[i].getID().toString();
        }
    }

    public void fetchHostsWithParentApps() throws RaplixException {
        SummaryHost master = HostsBean.getSummaryHostByID(Host.MASTER_SERVER_ID);
        this.mAllMSHostNames = new String[]{master.getName()};
        MultiHostQuery query = MultiHostQuery.all();
        query.setAppTypeFilter(new AppType[]{AppType.LD});
        query.setObjectOrder(HostOrder.BY_NAME_ASC);
        SummaryHost[] hostsWithLDs = query.selectSummaryView();
        if (hostsWithLDs.length > 0) {
            this.mAllLDHostNames = new String[hostsWithLDs.length];
            for (int i = 0; i < hostsWithLDs.length; ++i) {
                this.mAllLDHostNames[i] = hostsWithLDs[i].getName();
            }
        } else {
            this.mAllLDHostNames = new String[]{""};
        }
    }

    private void fetchMachineInfo(Host host) throws RaplixException {
        this.mOSName = "";
        this.mOSVersion = "";
        this.mOSArchitecture = "";
        this.mIsSupported = false;
        this.mLastPrepared = ApplicationResources.getMessage("label.hosts.notprepared");
        if (!this.mIsRA) {
            this.mLastPrepared = ApplicationResources.getMessage("label.hosts.notavailable");
            this.mPrepareHost = false;
            return;
        }
        this.mPrepareHost = true;
        MachineInfo machineInfo = host.getMachineInfo();
        if (machineInfo != null) {
            this.mOSName = machineInfo.getOSName();
            this.mOSVersion = machineInfo.getOSVersion();
            this.mOSArchitecture = machineInfo.getOSArch();
            this.mIsSupported = host.getID().isSupported();
            if (host.isPrepared()) {
                this.mLastPrepared = Util.formatDate(host.getMachineInfoTimestamp());
                this.mPrepareHost = false;
            }
        }
    }

    public void saveHost() throws RaplixException {
        AppInstance tmpLD;
        AppInstance tmpRA;
        Host host = this.mIsNew ? new Host() : new HostID(this.mID).getByIDQuery().select();
        this.copySettingsIntoHost(host);
        try {
            host.save();
        }
        catch (UpdateIncompleteException uie) {
            this.syncUpdateCounts(host);
            throw uie;
        }
        this.mID = host.getID().toString();
        AppInstance tmpMS = host.getAppMS();
        if (tmpMS != null) {
            this.mMSappID = tmpMS.getID().toString();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("MS ID is: " + this.mMSappID, this);
            }
        }
        if ((tmpRA = host.getAppRA()) != null) {
            this.mRAappID = tmpRA.getID().toString();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("RA ID is: " + this.mRAappID, this);
            }
        }
        if ((tmpLD = host.getAppLD()) != null) {
            this.mLDappID = tmpLD.getID().toString();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("LD ID is: " + this.mLDappID, this);
            }
        }
    }

    public static SummaryHost getSummaryHostByName(String name) throws RaplixException {
        try {
            return SingleHostQuery.byName(name).selectSummaryView();
        }
        catch (PersistenceManagerException ex) {
            throw new UIActionException(MSG_ERROR_HOST_NOT_FOUND, new String[]{name});
        }
    }

    public static Host getHostByName(String name) throws RaplixException {
        try {
            return SingleHostQuery.byName(name).select();
        }
        catch (PersistenceManagerException ex) {
            throw new UIActionException(MSG_ERROR_HOST_NOT_FOUND, new String[]{name});
        }
    }

    public static SummaryHost getSummaryHostByID(HostID id) throws RaplixException {
        return id.getByIDQuery().selectSummaryView();
    }

    public static SummaryHost getSummaryHostByID(String id) throws RaplixException {
        return HostsBean.getSummaryHostByID(new HostID(id));
    }

    private void fetchAppInstanceInfo(Host host) throws RaplixException {
        AppInstance tmpMS = host.getAppMS();
        if (tmpMS == null) {
            this.mIsMS = false;
        } else {
            this.mIsMS = true;
            this.mMSIPAddress = tmpMS.getIPAddress();
            this.mMSPort = "" + tmpMS.getPort();
            this.mMSappID = tmpMS.getID().toString();
        }
        AppInstance tmpLD = host.getAppLD();
        if (tmpLD == null) {
            this.mIsLD = false;
        } else {
            this.mIsLD = true;
            this.mLDappID = tmpLD.getID().toString();
            this.mLDConnectionType = this.getConnectionTypeAsString(tmpLD.getConnectionType());
            this.mLDIPAddress = tmpLD.getIPAddress();
            this.mLDPort = "" + tmpLD.getPort();
            this.mLDParams = tmpLD.getParameters();
            this.mLDUpdateCount = tmpLD.getUpdateCount();
            AppInstance parent = tmpLD.getParentID().getByIDQuery().select();
            this.mLDParentType = parent.getType().equals(AppType.LD) ? "Local Distributor" : "Master Server";
            this.mLDParentHost = HostsBean.getSummaryHostByID(parent.getHostID()).getName();
        }
        AppInstance tmpRA = host.getAppRA();
        if (tmpRA == null) {
            this.mIsRA = false;
        } else {
            this.mIsRA = true;
            this.mRAappID = tmpRA.getID().toString();
            this.mRAConnectionType = this.getConnectionTypeAsString(tmpRA.getConnectionType());
            this.mRAIPAddress = tmpRA.getIPAddress();
            this.mRAPort = "" + tmpRA.getPort();
            this.mRAParams = tmpRA.getParameters();
            this.mRAUpdateCount = tmpRA.getUpdateCount();
            AppInstance parent = tmpRA.getParentID().getByIDQuery().select();
            this.mRAParentType = parent.getType().equals(AppType.LD) ? "Local Distributor" : "Master Server";
            this.mRAParentHost = HostsBean.getSummaryHostByID(parent.getHostID()).getName();
        }
    }

    private void fetchHostTypeInfo(HostType hostType) throws RaplixException {
        HostTypesListBean typesList = new HostTypesListBean();
        typesList.fetchAllHostTypes();
        this.mHostTypeNames = typesList.getHostTypeNames();
        this.mHostTypeIDs = typesList.getHostTypeIDs();
        this.mTypeID = hostType.getID().toString();
        this.mTypeName = hostType.getName();
        this.mHostTypeIDs = (String[])ArrayEdit.prepend(this.mHostTypeIDs, this.mTypeID, false);
        this.mHostTypeNames = (String[])ArrayEdit.prepend(this.mHostTypeNames, this.mTypeName, false);
        this.loadHostTypeAttributes(hostType);
    }

    private void loadHostTypeAttributes(HostType hostType) {
        int numVars = hostType.getVarNames().length;
        String[] newNames = new String[numVars];
        String[] newDefaults = new String[numVars];
        String[] newValues = new String[numVars];
        boolean[] newHighlights = new boolean[numVars];
        for (int i = 0; i < numVars; ++i) {
            newNames[i] = hostType.getVarNames()[i];
            newDefaults[i] = hostType.getVarValue(newNames[i]);
            int pos = Util.indexOf(hostType.getVarNames()[i], this.mAttrNames);
            if (pos != -1 && this.mAttrHighlights[pos]) {
                newValues[i] = this.mAttrValues[pos];
                newHighlights[i] = true;
                continue;
            }
            newValues[i] = newDefaults[i];
            newHighlights[i] = false;
        }
        this.mAttrNames = newNames;
        this.mAttrDefaults = newDefaults;
        this.mAttrValues = newValues;
        this.mAttrHighlights = newHighlights;
    }

    private void fetchHostSetInfo(HostSetIDSet hostSets) throws RaplixException {
        Vector<String> memberIDs = new Vector<String>();
        Vector<String> memberNames = new Vector<String>();
        Vector<String> otherIDs = new Vector<String>();
        Vector<String> otherNames = new Vector<String>();
        HostSetsListBean setsList = new HostSetsListBean();
        setsList.loadAllHostSets();
        String[] allNames = setsList.getNames();
        String[] allIDs = setsList.getIDs();
        for (int i = 0; i < allIDs.length; ++i) {
            if (hostSets.contains(new HostSetID(allIDs[i]))) {
                memberIDs.add(allIDs[i]);
                memberNames.add(allNames[i]);
                continue;
            }
            otherIDs.add(allIDs[i]);
            otherNames.add(allNames[i]);
        }
        this.mHostSetNames = memberNames.toArray(new String[0]);
        this.mHostSetIDs = memberIDs.toArray(new String[0]);
        this.mOtherHostSetNames = otherNames.toArray(new String[0]);
        this.mOtherHostSetIDs = otherIDs.toArray(new String[0]);
    }

    private void fetchOverrideValues(Host host) {
        String[] overrideNames = host.getOverrideVarNames();
        for (int i = 0; i < overrideNames.length; ++i) {
            int pos = Util.indexOf(overrideNames[i], this.mAttrNames);
            this.mAttrHighlights[pos] = true;
            this.mAttrValues[pos] = host.getOverrideVarValue(overrideNames[i]);
        }
    }

    private void copySettingsIntoHost(Host host) throws RaplixException {
        if (host.getInstalledComponentID() == null) {
            host.setName(this.mName);
            host.setDescription(this.mDescription);
            host.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
            host.setUpdateCount(this.mUpdateCount);
            if (this.mHostPhysicality.equals("virtual")) {
                host.setParentHostID(HostsBean.getSummaryHostByName(this.mParentHostName).getID());
            } else {
                host.setParentHostID(null);
            }
            HostSetIDSet setSet = this.convertToHostSetSet(this.mHostSetIDs);
            host.setHostSetIDSet(setSet);
            if (this.mHostPhysicality.equals("physical")) {
                this.copyAppInstanceInfoIntoHost(host);
            }
            this.copyHostTypeInfoIntoHost(host);
        } else {
            host.setDescription(this.mDescription);
            host.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
            host.setUpdateCount(this.mUpdateCount);
            HostSetIDSet setSet = this.convertToHostSetSet(this.mHostSetIDs);
            host.setHostSetIDSet(setSet);
            this.copyHostTypeAttributeOverrides(host);
        }
    }

    private void copyAppInstanceInfoIntoHost(Host host) throws RaplixException {
        AppInstance oldRA;
        AppInstance oldLD = host.getAppLD();
        if (oldLD == null) {
            if (this.mIsLD) {
                AppInstance newLD = new AppInstance(AppType.LD);
                this.copyLDValuesIntoApp(newLD);
                host.addAppInstance(newLD);
            }
        } else if (this.mIsLD) {
            this.copyLDValuesIntoApp(oldLD);
            host.addAppInstance(oldLD);
        } else {
            host.removeAppInstance(AppType.LD);
        }
        if ((oldRA = host.getAppRA()) == null) {
            if (this.mIsRA) {
                AppInstance newRA = new AppInstance(AppType.RA);
                this.copyRAValuesIntoApp(newRA);
                host.addAppInstance(newRA);
            }
        } else if (this.mIsRA) {
            this.copyRAValuesIntoApp(oldRA);
            host.addAppInstance(oldRA);
        } else {
            host.removeAppInstance(AppType.RA);
        }
    }

    private void copyLDValuesIntoApp(AppInstance app) throws RaplixException {
        app.setConnectionType(this.getStringAsConnectionType(this.mLDConnectionType));
        app.setParameters(this.mLDParams);
        app.setParentID(this.getAppID(this.mLDParentHost, this.mLDParentType));
        app.setRoxAddress(new RoxAddress(this.mLDIPAddress, Integer.parseInt(this.mLDPort)));
        app.setUpdateCount(this.mLDUpdateCount);
    }

    private void copyRAValuesIntoApp(AppInstance app) throws RaplixException {
        app.setConnectionType(this.getStringAsConnectionType(this.mRAConnectionType));
        app.setParameters(this.mRAParams);
        app.setParentID(this.getAppID(this.mRAParentHost, this.mRAParentType));
        app.setRoxAddress(new RoxAddress(this.mRAIPAddress, Integer.parseInt(this.mRAPort)));
        app.setUpdateCount(this.mRAUpdateCount);
    }

    private void copyHostTypeInfoIntoHost(Host host) throws RaplixException {
        HostType newType = new HostTypeID(this.mTypeID).getByIDQuery().select();
        host.setHostType(newType);
        this.copyHostTypeAttributeOverrides(host);
    }

    private void copyHostTypeAttributeOverrides(Host host) throws RaplixException {
        host.removeAllOverrideVarValues();
        for (int i = 0; i < this.mAttrNames.length; ++i) {
            if (!this.mAttrHighlights[i]) continue;
            host.setOverrideVarValue(this.mAttrNames[i], this.mAttrValues[i]);
        }
    }

    private AppInstanceID getAppID(String parentHostName, String parentType) throws RaplixException {
        AppInstanceID parentID = null;
        Host parentHost = null;
        parentHost = HostsBean.getHostByName(parentHostName);
        parentID = parentType.equals("Master Server") ? (parentHost.getAppMS() == null ? null : parentHost.getAppMS().getID()) : (parentHost.getAppLD() == null ? null : parentHost.getAppLD().getID());
        return parentID;
    }

    private HostSetIDSet convertToHostSetSet(String[] hostSetIDs) {
        Vector<HostSetID> ids = new Vector<HostSetID>();
        for (int i = 0; i < hostSetIDs.length; ++i) {
            ids.add(new HostSetID(hostSetIDs[i]));
        }
        return new HostSetIDSet(ids);
    }

    private void syncUpdateCounts(Host host) {
        AppInstance tmpRA;
        this.mID = host.getID().toString();
        this.mUpdateCount = host.getUpdateCount();
        AppInstance tmpLD = host.getAppLD();
        if (tmpLD != null) {
            this.mLDUpdateCount = tmpLD.getUpdateCount();
        }
        if ((tmpRA = host.getAppRA()) != null) {
            this.mRAUpdateCount = tmpRA.getUpdateCount();
        }
    }

    private String getConnectionTypeAsString(ConnectionType ct) {
        if (ConnectionType.RAW.equals(ct)) {
            return CONN_RAW;
        }
        if (ConnectionType.SSH.equals(ct)) {
            return CONN_SSH;
        }
        return CONN_SSL;
    }

    ConnectionType getStringAsConnectionType(String s) {
        if (s.equals(CONN_RAW)) {
            return ConnectionType.RAW;
        }
        if (s.equals(CONN_SSH)) {
            return ConnectionType.SSH;
        }
        return ConnectionType.SSL;
    }

    void loadPermissionLookaheads() {
        if (!this.mID.equals("")) {
            this.mHasExecuteOnSystemFolder = PermissionChecker.hasExecuteOnSystemFolderForHost(new HostID(this.mID));
        }
        this.mHasWriteOnHosts = PermissionChecker.hasWriteOnHosts();
    }
}

