/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.hosts.HostsListBean;
import com.raplix.util.string.StringUtil;
import javax.servlet.http.HttpServletRequest;

public final class HostsAction
extends UIActionListServlet
implements ActionModeConstants {
    public static final String MSG_ERROR = "error.hosts.list";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "";
        }
        this.handleList(request, servletInfo);
    }

    public void setAdditionalFilters(HttpServletRequest request, ServletListBean slb) {
        HostsListBean hlb = (HostsListBean)slb;
        String isSearchFiltered = request.getParameter("isSearchFiltered");
        if (isSearchFiltered != null) {
            hlb.setIsSearchFiltered(isSearchFiltered);
            if (isSearchFiltered.equals("true")) {
                hlb.setCurrentFilterID(request.getParameter("currentFilterID"));
            }
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        HostsListBean bean = (HostsListBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        this.loadListParameters(request, bean);
        bean.setSinglePrepareHostID(request.getParameter("singlePrepareHostID"));
        bean.setSingleUpdateHostID(request.getParameter("singleUpdateHostID"));
        bean.setShowPreparedness(request.getParameter("showPreparedness") != null);
        bean.generateListWithSearch();
        bean.loadHostPageArrays();
        MultiCheckbox mc = bean.getMultiCheckbox();
        if (mc != null) {
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(mc.getID(), mc);
        }
        servletInfo.setDestPage("/hosts/hosts.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    protected void setAdditionalFindFilters(HttpServletRequest request, ServletListBean bean) {
        String appType = request.getParameter("appType");
        String hostTypeID = request.getParameter("typeID");
        String platformHostSetID = request.getParameter("platformHostSetID");
        ((HostsListBean)bean).setFindAppType(StringUtil.normalizeEmpty(request.getParameter("appType")));
        ((HostsListBean)bean).setFindHostTypeID(StringUtil.normalizeEmpty(request.getParameter("typeID")));
        ((HostsListBean)bean).setFindPlatformHostSetID(StringUtil.normalizeEmpty(request.getParameter("platformHostSetID")));
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new HostsListBean();
    }

    public String getDefaultPage() {
        return "/hosts/hosts.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        return MSG_ERROR;
    }
}

