/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;

public class HostUpdateBean
extends ServletBean {
    private String mAppInstanceID = "";
    private String mHostID = "";
    private String mTaskID = "";
    private String mTaskDetails = "";
    private boolean mRunning = false;
    private boolean mPreviousRunning = false;
    private String[] mHostNames = new String[0];
    private String[] mHostTypes = new String[0];
    private String[] mHostStatuses = new String[0];
    private String[] mHostStatusDetails = new String[0];
    private boolean[] mHostRunnings = new boolean[0];
    private boolean mCancelling = false;
    private String mMode = "";
    private final NodeManagementServices mNodeAdmin;

    public HostUpdateBean(NodeManagementServices nodeAdmin) {
        this.mNodeAdmin = nodeAdmin;
    }

    public String getID() {
        if (this.mTaskID.equals("")) {
            return super.getID();
        }
        return this.mTaskID;
    }

    public String getAppInstanceID() {
        return this.mAppInstanceID;
    }

    public String getTaskID() {
        return this.mTaskID;
    }

    public String getTaskDetails() {
        return this.mTaskDetails;
    }

    public boolean getRunning() {
        return this.mRunning;
    }

    public String[] getHostNames() {
        return this.mHostNames;
    }

    public String[] getHostTypes() {
        return this.mHostTypes;
    }

    public String[] getHostStatuses() {
        return this.mHostStatuses;
    }

    public String[] getHostStatusDetails() {
        return this.mHostStatusDetails;
    }

    public boolean[] getHostRunnings() {
        return this.mHostRunnings;
    }

    public boolean getCancelling() {
        return this.mCancelling;
    }

    public boolean getPreviousRunning() {
        return this.mPreviousRunning;
    }

    public void setTaskID(String taskID) {
        this.mTaskID = taskID;
    }

    public void setAppInstanceID(String appID) {
        this.mAppInstanceID = appID;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setCancelling(boolean cancelling) {
        this.mCancelling = cancelling;
    }

    public void setPreviousRunning(boolean previous) {
        this.mPreviousRunning = previous;
    }

    public void fetchOutput() throws RaplixException {
        UpgradeTaskStatus uts = this.mNodeAdmin.getUpgradeTaskStatus(new UpgradeTaskID(this.mTaskID));
        this.mRunning = !uts.getTaskState().equals(UpgradeTaskState.COMPLETED);
        this.mTaskDetails = uts.getDetail();
        if (this.mTaskDetails == null || this.mTaskDetails.equals("")) {
            this.mTaskDetails = uts.getTaskState().equals(UpgradeTaskState.FIND_UPGRADE_NODES) ? ApplicationResources.getMessage("hostUpdate.task.searching") : "";
        }
        UpgradeNodeStatus[] uns = uts.getAllNodeStatus();
        this.mHostNames = new String[uns.length];
        this.mHostTypes = new String[uns.length];
        this.mHostStatuses = new String[uns.length];
        this.mHostStatusDetails = new String[uns.length];
        this.mHostRunnings = new boolean[uns.length];
        boolean hasPartial = false;
        for (int i = 0; i < uns.length; ++i) {
            this.mHostNames[i] = uns[i].getName();
            this.mHostTypes[i] = uns[i].getType().toString().toLowerCase();
            this.mHostStatuses[i] = this.upgradeNodeStateToString(uns[i].getState());
            this.mHostStatusDetails[i] = uns[i].getDetail();
            if (this.mHostStatusDetails[i] == null) {
                this.mHostStatusDetails[i] = "";
            } else if (Logger.isDebugEnabled(this)) {
                Logger.debug("Host " + i + " status is [" + this.mHostStatusDetails[i] + "]", this);
            }
            this.mHostRunnings[i] = this.upgradeNodeStateToRunning(uns[i].getState());
            if (!uns[i].getState().equals(UpgradeNodeState.PARTIALLY_COMPLETED)) continue;
            hasPartial = true;
        }
        if (hasPartial) {
            String head = ApplicationResources.getMessage("hostUpdate.task.hasPartial.head");
            String body = ApplicationResources.getMessage("hostUpdate.task.hasPartial.body");
            this.mTaskDetails = this.mTaskDetails + Util.headingMessage(head) + Util.standardMessage(body);
        }
    }

    private String upgradeNodeStateToString(UpgradeNodeState s) {
        if (s.equals(UpgradeNodeState.ACTION_REQUIRED)) {
            return ApplicationResources.getMessage("hostUpdate.node.action");
        }
        if (s.equals(UpgradeNodeState.DEPLOYED)) {
            return ApplicationResources.getMessage("hostUpdate.node.deployed");
        }
        if (s.equals(UpgradeNodeState.FAILED)) {
            return ApplicationResources.getMessage("hostUpdate.node.failed");
        }
        if (s.equals(UpgradeNodeState.IN_PROGRESS)) {
            return ApplicationResources.getMessage("hostUpdate.node.inprogress");
        }
        if (s.equals(UpgradeNodeState.NOT_STARTED)) {
            return ApplicationResources.getMessage("hostUpdate.node.notstarted");
        }
        if (s.equals(UpgradeNodeState.PARTIALLY_COMPLETED)) {
            return ApplicationResources.getMessage("hostUpdate.node.partial");
        }
        if (s.equals(UpgradeNodeState.SUCCESSFUL)) {
            return ApplicationResources.getMessage("hostUpdate.node.successful");
        }
        if (s.equals(UpgradeNodeState.UNPROCESSED)) {
            return ApplicationResources.getMessage("hostUpdate.node.unprocessed");
        }
        if (s.equals(UpgradeNodeState.UPGRADED)) {
            return ApplicationResources.getMessage("hostUpdate.node.upgraded");
        }
        if (s.equals(UpgradeNodeState.UPGRADING)) {
            return ApplicationResources.getMessage("hostUpdate.node.upgrading");
        }
        return "[unknown]";
    }

    private boolean upgradeNodeStateToRunning(UpgradeNodeState s) {
        return !s.equals(UpgradeNodeState.UPGRADED) && !s.equals(UpgradeNodeState.FAILED) && !s.equals(UpgradeNodeState.SUCCESSFUL) && !s.equals(UpgradeNodeState.ACTION_REQUIRED);
    }

    public void kickOffUpdate() throws RaplixException {
        this.mTaskID = this.mAppInstanceID.equals("") ? this.mNodeAdmin.upgradeEntireNetwork().toString() : this.mNodeAdmin.upgradeNode(new AppInstanceID(this.mAppInstanceID)).toString();
    }

    public void kickOffHostUpdate(String hostID) throws RaplixException {
        Host host = new HostID(hostID).getByIDQuery().select();
        AppInstance tmpRA = host.getAppRA();
        AppInstance tmpLD = host.getAppLD();
        this.mTaskID = tmpRA != null && tmpLD != null ? this.mNodeAdmin.upgradeMultipleNodes(new AppInstanceID[]{tmpRA.getID(), tmpLD.getID()}).toString() : (tmpRA != null ? this.mNodeAdmin.upgradeNode(tmpRA.getID()).toString() : this.mNodeAdmin.upgradeNode(tmpLD.getID()).toString());
    }

    public void cancelUpdate() throws RaplixException {
        this.mNodeAdmin.abortUpgradeTask(new UpgradeTaskID(this.mTaskID));
        this.mCancelling = true;
    }
}

