/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.hosts.HostUpdateBean;
import javax.servlet.http.HttpServletRequest;

public class HostUpdateAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_UPDATE = "error.hostUpdate.prompt";
    public static final String MSG_ERROR_REFRESH = "error.hostUpdate.refresh";
    public static final String MSG_ERROR_CANCEL = "error.hostUpdate.cancel";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "update";
        }
        if (mode.equals("update")) {
            this.handleUpdate(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostUpdateAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        NodeManagementServices nodeAdmin = HostUpdateAction.getApplication().getNodeManagementServices();
        HostUpdateBean hub = new HostUpdateBean(nodeAdmin);
        return hub;
    }

    public String getDefaultPage() {
        return "/hosts/hostUpdate.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = inRequest.getParameter("mode");
        if (mode == null) {
            mode = "update";
        }
        if (mode.equals("update")) {
            return MSG_ERROR_UPDATE;
        }
        if (mode.equals("refresh")) {
            return MSG_ERROR_REFRESH;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostUpdateAction.");
    }

    private void handleUpdate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostUpdateBean hub = (HostUpdateBean)servletInfo.getBean();
        String hostID = request.getParameter("hostID");
        if (hostID != null) {
            hub.kickOffHostUpdate(hostID);
        } else {
            String appID = request.getParameter("id");
            if (appID == null) {
                appID = "";
            }
            hub.setAppInstanceID(appID);
            hub.kickOffUpdate();
        }
        hub.fetchOutput();
        servletInfo.setDestPage("/hosts/hostUpdate.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostUpdateBean hub = (HostUpdateBean)servletInfo.getBean();
        String taskID = HostUpdateAction.assertGetParam(request, "id");
        hub.setTaskID(taskID);
        if (request.getParameter("cancelling") != null) {
            hub.setCancelling(true);
        }
        if (request.getParameter("previousRunning") != null) {
            hub.setPreviousRunning(true);
        }
        hub.fetchOutput();
        servletInfo.setDestPage("/hosts/hostUpdate.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostUpdateBean hub = (HostUpdateBean)servletInfo.getBean();
        String taskID = HostUpdateAction.assertGetParam(request, "id");
        hub.setTaskID(taskID);
        hub.cancelUpdate();
        hub.setPreviousRunning(false);
        hub.fetchOutput();
        servletInfo.setDestPage("/hosts/hostUpdate.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }
}

