/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;

public class HostTypesListBean
extends ServletListBean {
    private String[] mNames = new String[0];
    private String[] mDescriptions = new String[0];
    private String[] mIDs = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private String mBaseClassName = "";
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private boolean mHasWriteOnHostTypes = true;
    private String mMode = "";
    private static HostTypeOrder DEFAULT_SORT_ORDER = HostTypeOrder.BY_NAME_ASC;

    public String[] getHostTypeNames() {
        return this.mNames;
    }

    public String[] getHostTypeDescriptions() {
        return this.mDescriptions;
    }

    public String[] getHostTypeIDs() {
        return this.mIDs;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public String getHostTypeBaseClass() {
        return this.mBaseClassName;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getHasWriteOnHostTypes() {
        return this.mHasWriteOnHostTypes;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    protected void generateList() throws RaplixException {
        MultiHostTypeQuery mhtq = MultiHostTypeQuery.all();
        this.prepQuery(mhtq, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(mhtq.selectSummaryView());
    }

    public void fetchAllHostTypes() throws RaplixException {
        MultiHostTypeQuery mhtq = MultiHostTypeQuery.all();
        this.generateOutputArrays(mhtq.selectSummaryView());
    }

    private void generateOutputArrays(SummaryHostType[] hostTypes) {
        this.mNames = new String[hostTypes.length];
        this.mDescriptions = new String[hostTypes.length];
        this.mIDs = new String[hostTypes.length];
        this.mIsHidden = new boolean[hostTypes.length];
        for (int i = 0; i < hostTypes.length; ++i) {
            this.mNames[i] = hostTypes[i].getName();
            this.mDescriptions[i] = hostTypes[i].getDescription();
            this.mIDs[i] = hostTypes[i].getID().toString();
            this.mIsHidden[i] = hostTypes[i].getVisibility().equals(Visibility.HIDDEN);
        }
        this.mBaseClassName = SystemPluginConstants.DEFAULT_HOST_TYPE_NAME;
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mIDs);
        this.mHasWriteOnHostTypes = PermissionChecker.hasWriteOnHostTypes();
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(HostTypeOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return true;
    }
}

