/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.hosts.HostTypesBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public final class HostTypesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CREATE = "error.hostTypes.create";
    public static final String MSG_ERROR_EDIT = "error.hostTypes.edit";
    public static final String MSG_ERROR_CANCEL = "error.hostTypes.cancel";
    public static final String MSG_ERROR_ADDATTR = "error.hostTypes.addAttr";
    public static final String MSG_ERROR_REMOVE = "error.hostTypes.remove";
    public static final String MSG_ERROR_MOVE = "error.hostTypes.move";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.hostTypes.save.major";
    public static final String MSG_ERROR_SAVE_ATTR_REQ = "error.hostTypes.save.attrname.required";
    public static final String MSG_ERROR_SAVE_ATTR_RES = "error.hostTypes.save.attrname.reserved";
    public static final String MSG_ERROR_SAVE_ATTR_UNQ = "error.hostTypes.save.attrname.unique";
    public static final String MSG_ERROR_SAVE_ATTR_REQ_NAME = "error.hostTypes.save.attrname.required.name";
    public static final String MSG_ERROR_SAVE_DELETED_OBJECT = "error.hostTypes.save.deletedObject";

    public ServletBean createBean(HttpServletRequest request) {
        return new HostTypesBean();
    }

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = HostTypesHandleAction.assertGetParam(request, "mode");
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        htb.setMode(mode);
        servletInfo.setSaveInSession(false);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through HostTypesHandleAction: " + mode, this);
        }
        if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("addattr")) {
            this.handleAddAttr(request, servletInfo);
        } else if (mode.equals("remove")) {
            this.handleRemove(request, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveConfirmed(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to HostTypesHandleAction.");
        }
    }

    public String getDefaultPage() {
        return "/hosts/hostTypeDetails.jsp";
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = HostTypesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("addattr")) {
            return MSG_ERROR_ADDATTR;
        }
        if (mode.equals("remove")) {
            return MSG_ERROR_REMOVE;
        }
        if (mode.equals("move")) {
            return MSG_ERROR_MOVE;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to HostTypesHandleAction.");
    }

    private void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        htb.setName(request.getParameter("name"));
        htb.setDescription(request.getParameter("description"));
        htb.setIsNew(true);
        htb.loadPermissionLookaheads();
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        String id = HostTypesHandleAction.assertGetParam(request, "id");
        htb.fetchHostType(id);
        htb.setIsNew(false);
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleAddAttr(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        if (htb.newNameIsDuplicate()) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ADDATTR);
            servletInfo.getErrors().addMinorErrorROXKey("hostdb.DUPLICATE_VAR_NAME", new String[]{htb.getNewName()});
        } else {
            try {
                htb.appendNewAttribute();
            }
            catch (RaplixException e) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ADDATTR);
                servletInfo.getErrors().addMinorError(e.getMessage());
                htb.setMode("edit");
                servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
        }
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        String id = HostTypesHandleAction.assertGetParam(request, "id");
        String isNew = HostTypesHandleAction.assertGetParam(request, "isNew");
        if (isNew.equals("false")) {
            htb.fetchHostType(id);
        }
        this.readFromRequest(htb, request);
        try {
            htb.saveHostType();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            htb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            htb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostTypes");
        servletInfo.setShouldRedirect(true);
    }

    private void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        servletInfo.setDestPage("/hosts/hostTypeConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleRemove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        int index = this.parseIntegerParam(htb, request, "swap1");
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Removing " + index, this);
        }
        htb.removeAttribute(index);
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        int index1 = this.parseIntegerParam(htb, request, "swap1");
        int index2 = this.parseIntegerParam(htb, request, "swap2");
        htb.swapAttributes(index1, index2);
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.setDestPage("/HostTypes");
        servletInfo.setShouldRedirect(true);
    }

    private void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        htb.loadPermissionLookaheads();
        servletInfo.setDestPage("/hosts/hostTypeDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSaveConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTypesBean htb = (HostTypesBean)servletInfo.getBean();
        this.readFromRequest(htb, request);
        try {
            htb.saveHostType();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            htb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostTypeConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            htb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostTypeConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostTypes");
        servletInfo.setShouldRedirect(true);
    }

    private void readFromRequest(HostTypesBean htb, HttpServletRequest request) {
        String name;
        htb.setID(HostTypesHandleAction.assertGetParam(request, "id"));
        htb.setName(HostTypesHandleAction.assertGetParam(request, "name"));
        htb.setDescription(HostTypesHandleAction.assertGetParam(request, "description"));
        htb.setPluginID(request.getParameter("pluginID"));
        htb.setPluginName(request.getParameter("pluginName"));
        htb.setWriteOnPlugin(request.getParameter("writeOnPlugin") != null);
        htb.setHasWriteOnHostTypes(request.getParameter("hasWriteOnHostTypes") != null);
        htb.setUpdateCount(Integer.parseInt(HostTypesHandleAction.assertGetParam(request, "updateCount")));
        htb.setIsHidden(request.getParameter("isHidden") != null);
        htb.setIsNew("true".equals(HostTypesHandleAction.assertGetParam(request, "isNew")));
        htb.setIsBaseClass("true".equals(HostTypesHandleAction.assertGetParam(request, "isBaseClass")));
        htb.setNewName(request.getParameter("newName"));
        htb.setNewDefault(request.getParameter("newDefault"));
        int i = 0;
        Vector<String> names = new Vector<String>();
        Vector<String> defaults = new Vector<String>();
        while ((name = request.getParameter("attrname" + i)) != null) {
            String defaultx = HostTypesHandleAction.assertGetParam(request, "attrdefault" + i);
            names.add(name);
            defaults.add(defaultx);
            ++i;
        }
        htb.setNamesAndDefaults(names, defaults);
    }

    private int parseIntegerParam(HostTypesBean htb, HttpServletRequest request, String paramName) {
        int i = Integer.parseInt(HostTypesHandleAction.assertGetParam(request, paramName));
        if (i >= htb.getAttrNames().length) {
            i = htb.getAttrNames().length - 1;
        }
        if (i < 0) {
            i = 0;
        }
        return i;
    }
}

