/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVar;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeVarList;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.util.logger.Logger;
import java.util.Vector;

public final class HostTypesBean
extends ServletBean {
    private HostType mHostType = null;
    private String mName = "";
    private String mDescription = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mHasWriteOnHostTypes = true;
    private String mNewName = "";
    private String mNewDefault = "";
    private Vector mAttrNames = new Vector();
    private Vector mDefaults = new Vector();
    private String mMode = "";
    private boolean mIsHidden = false;
    private boolean mIsNew = false;
    private boolean mIsBaseClass = false;
    private int mUpdateCount = 0;

    public void setID(String id) {
        this.mObjectID = new HostTypeID(id);
    }

    public void setIsHidden(boolean isHidden) {
        this.mIsHidden = isHidden;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setDescription(String desc) {
        this.mDescription = desc;
    }

    public void setPluginID(String id) {
        this.mPluginID = id;
    }

    public void setPluginName(String name) {
        this.mPluginName = name;
    }

    public void setWriteOnPlugin(boolean write) {
        this.mWriteOnPlugin = write;
    }

    public void setHasWriteOnHostTypes(boolean write) {
        this.mHasWriteOnHostTypes = write;
    }

    public void setNewName(String newName) {
        this.mNewName = newName;
    }

    public void setNewDefault(String newDefault) {
        this.mNewDefault = newDefault;
    }

    public void setHostType(HostType hostType) {
        this.mHostType = hostType;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setIsBaseClass(boolean isBase) {
        this.mIsBaseClass = isBase;
    }

    public void setUpdateCount(int updateCount) {
        this.mUpdateCount = updateCount;
    }

    public void setNamesAndDefaults(Vector names, Vector defaults) {
        this.mAttrNames = names;
        this.mDefaults = defaults;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getNewName() {
        return this.mNewName;
    }

    public String getNewDefault() {
        return this.mNewDefault;
    }

    public HostType getHostType() {
        return this.mHostType;
    }

    public String[] getAttrNames() {
        return this.mAttrNames.toArray(new String[0]);
    }

    public String[] getDefaults() {
        return this.mDefaults.toArray(new String[0]);
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsBaseClass() {
        return this.mIsBaseClass;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getHasWriteOnHostTypes() {
        return this.mHasWriteOnHostTypes;
    }

    public void fetchHostType(String id) throws RaplixException {
        Logger.debug("fetchHostType begin for " + id, this);
        this.mObjectID = new HostTypeID(id);
        this.mHostType = ((HostTypeID)this.mObjectID).getByIDQuery().select();
        if (this.mHostType.getID().equals(SystemPluginConstants.getInstance().DEFAULT_HOST_TYPE_ID)) {
            this.mIsBaseClass = true;
        }
        this.mName = this.mHostType.getName();
        this.mDescription = this.mHostType.getDescription();
        PluginID pluginID = this.mHostType.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.loadPermissionLookaheads();
        HostTypeVarList htvl = this.mHostType.getVarList();
        String[] names = htvl.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            this.mAttrNames.add(names[i]);
            this.mDefaults.add(htvl.getVarValue(names[i]));
        }
        this.mIsHidden = this.mHostType.getVisibility().equals(Visibility.HIDDEN);
        this.mUpdateCount = this.mHostType.getUpdateCount();
    }

    public void saveHostType() throws RaplixException {
        if (this.mHostType == null) {
            this.mHostType = new HostType();
        }
        this.mHostType.setSimpleName(this.mName);
        this.mHostType.setDescription(this.mDescription);
        HostTypeVarList htvl = new HostTypeVarList();
        for (int i = 0; i < this.mAttrNames.size(); ++i) {
            HostTypeVar htv = new HostTypeVar((String)this.mAttrNames.elementAt(i), (String)this.mDefaults.elementAt(i));
            htvl.add(i, htv);
        }
        this.mHostType.setVarList(htvl);
        this.mHostType.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
        this.mHostType.setUpdateCount(this.mUpdateCount);
        this.mHostType.save(false);
    }

    public void appendNewAttribute() throws RaplixException {
        HostTypeVar.validateName(this.mNewName);
        HostTypeVar.validateDefaultValue(this.mNewDefault);
        this.mAttrNames.add(this.mNewName);
        this.mDefaults.add(this.mNewDefault);
        this.mNewName = "";
        this.mNewDefault = "";
    }

    public void removeAttribute(int removeIndex) {
        this.mAttrNames.remove(removeIndex);
        this.mDefaults.remove(removeIndex);
    }

    public void swapAttributes(int index1, int index2) {
        Object temp = this.mAttrNames.elementAt(index1);
        this.mAttrNames.setElementAt(this.mAttrNames.elementAt(index2), index1);
        this.mAttrNames.setElementAt(temp, index2);
        temp = this.mDefaults.elementAt(index1);
        this.mDefaults.setElementAt(this.mDefaults.elementAt(index2), index1);
        this.mDefaults.setElementAt(temp, index2);
    }

    public boolean newNameIsDuplicate() {
        for (int i = 0; i < this.mAttrNames.size(); ++i) {
            if (!this.mNewName.equals((String)this.mAttrNames.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    void loadPermissionLookaheads() {
        if (this.mHostType != null) {
            this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(this.mHostType);
        }
        this.mHasWriteOnHostTypes = PermissionChecker.hasWriteOnHostTypes();
    }
}

