/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostTypeID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class HostTypeDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;

    public HostTypeDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
    }

    public int getDeleteConfirmColspan() {
        return 2;
    }

    public String getDeleteContext() {
        return "hostTypeDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        HostTypeID hostTypeID = (HostTypeID)candidate.getParent().getObjectID();
        return hostTypeID.getByIDQuery().selectSummaryView();
    }

    public void preRender() throws RaplixException {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.hostTypeDetailsURI(this.mObjectID.toString());
        String editURI = UriUtil.hostTypeEditURI(this.mObjectID.toString());
        String toolTip = "Show host type details";
        String nameLink = Util.standardLink(editURI, toolTip, this.mName, "name=\"nameLink-" + this.mObjectID + "\"");
        String descLink = Util.standardLink(editURI, toolTip, this.mDescription);
        if (this.mObjectID.equals(SystemPluginConstants.getInstance().DEFAULT_HOST_TYPE_ID)) {
            nameLink = Util.standardLink(viewURI, toolTip, this.mName);
            descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        }
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

