/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TraceResult;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.node.admin.LogFileSnapshot;
import com.raplix.rolloutexpress.node.admin.NodeStatus;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class HostTraceBean
extends ServletBean {
    private String mID = "";
    private String mMode = "";
    private NodeManagementServices mNodeAdmin = null;
    private TransportServices mTransServ = null;
    private TraceResult mTraceResult = null;
    private String mIPAddress = "";
    private String mPort = "";
    private String mHostName = "";
    private String mAppType = "";
    public static final String MS_APPTYPE = "master server";
    public static final String RA_APPTYPE = "remote agent";
    public static final String LD_APPTYPE = "local distributor";
    private boolean mTraceSucceeded = false;
    private boolean[] mIsSuccess = new boolean[0];
    private String[] mIPAddresses = new String[0];
    private String[] mPorts = new String[0];
    private String[] mTimes = new String[0];
    private String mVersion = "";
    private String mUser = "";
    private long mCacheMax = 1L;
    private long mCacheFilled = 0L;
    private long mCachePercentage = 0L;
    private long mSnapshotSize = 0L;
    private String[] mConfigNames = new String[0];
    private String[] mConfigValues = new String[0];
    private boolean mClearingCache = false;
    private String mLog = "";
    private long mLogTruncation = 0L;

    public HostTraceBean(TransportServices transServ, NodeManagementServices nodeAdmin) {
        this.mTransServ = transServ;
        this.mNodeAdmin = nodeAdmin;
    }

    public void setMode(String s) {
        this.mMode = s;
    }

    public void setTransportServices(TransportServices transServ) {
        this.mTransServ = transServ;
    }

    public void setTraceResult(TraceResult tr) {
        this.mTraceResult = tr;
    }

    public void setIPAddress(String s) {
        this.mIPAddress = s;
    }

    public void setPort(String s) {
        this.mPort = s;
    }

    public void setHostName(String s) {
        this.mHostName = s;
    }

    public void setTraceSucceeded(boolean b) {
        this.mTraceSucceeded = b;
    }

    public void setIsSuccess(boolean[] b) {
        this.mIsSuccess = b;
    }

    public void setIPAddresses(String[] s) {
        this.mIPAddresses = s;
    }

    public void setPorts(String[] s) {
        this.mPorts = s;
    }

    public void setTimes(String[] s) {
        this.mTimes = s;
    }

    public String getID() {
        return this.mID;
    }

    public String getMode() {
        return this.mMode;
    }

    public TransportServices getTransportServices() {
        return this.mTransServ;
    }

    public TraceResult getTraceResult() {
        return this.mTraceResult;
    }

    public String getIPAddress() {
        return this.mIPAddress;
    }

    public String getPort() {
        return this.mPort;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public String getAppType() {
        return this.mAppType;
    }

    public boolean getTraceSucceeded() {
        return this.mTraceSucceeded;
    }

    public boolean[] getIsSuccess() {
        return this.mIsSuccess;
    }

    public String[] getIPAddresses() {
        return this.mIPAddresses;
    }

    public String[] getPorts() {
        return this.mPorts;
    }

    public String[] getTimes() {
        return this.mTimes;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getUser() {
        return this.mUser;
    }

    public long getCacheMax() {
        return this.mCacheMax;
    }

    public long getCacheFilled() {
        return this.mCacheFilled;
    }

    public long getCachePercentage() {
        return this.mCachePercentage;
    }

    public long getSnapshotSize() {
        return this.mSnapshotSize;
    }

    public String[] getConfigNames() {
        return this.mConfigNames;
    }

    public String[] getConfigValues() {
        return this.mConfigValues;
    }

    public boolean getClearingCache() {
        return this.mClearingCache;
    }

    public String getLog() {
        return this.mLog;
    }

    public long getLogTruncation() {
        return this.mLogTruncation;
    }

    public void doTrace() throws RaplixException {
        this.mTraceResult = this.mTransServ.traceroute(new RoxAddress(this.mIPAddress, Integer.parseInt(this.mPort)));
    }

    public void processResult(ServletInfo servletInfo) {
        this.setIPAddress(this.getTraceResult().getDestinationId().ipString());
        this.setTraceSucceeded(this.getTraceResult().isSuccess());
        Vector<Boolean> isSuccess = new Vector<Boolean>();
        Vector<String> IPAddresses = new Vector<String>();
        Vector<String> Ports = new Vector<String>();
        Vector<String> Times = new Vector<String>();
        Enumeration enumeration = this.getTraceResult().hops();
        PingResult pr = null;
        while (enumeration.hasMoreElements()) {
            pr = (PingResult)enumeration.nextElement();
            isSuccess.add(new Boolean(pr.isSuccess()));
            IPAddresses.add(pr.getDestinationId().ipString());
            Ports.add(Integer.toString(pr.getDestinationId().getPort()));
            Times.add(Long.toString(pr.timeTakenMillis()));
        }
        if (!this.getTraceSucceeded() && pr != null) {
            servletInfo.getErrors().setMajorErrorKey("error.hostTrace.unreachable");
            servletInfo.getErrors().addMinorError(pr.failureCodeString());
        }
        boolean[] b = new boolean[isSuccess.size()];
        for (int i = 0; i < isSuccess.size(); ++i) {
            b[i] = (Boolean)isSuccess.elementAt(i);
        }
        this.setIsSuccess(b);
        this.setIPAddresses(IPAddresses.toArray(new String[0]));
        this.setPorts(Ports.toArray(new String[0]));
        this.setTimes(Times.toArray(new String[0]));
    }

    public void fetchInstance(String id) throws RaplixException {
        AppInstance instance = new AppInstanceID(id).getByIDQuery().select();
        this.mID = id;
        this.mIPAddress = instance.getIPAddress();
        this.mPort = new Integer(instance.getPort()).toString();
        this.mHostName = HostsBean.getSummaryHostByID(instance.getHostID()).getName();
        this.mAppType = instance.getType().equals(AppType.LD) ? LD_APPTYPE : (instance.getType().equals(AppType.RA) ? RA_APPTYPE : MS_APPTYPE);
    }

    public void fetchConfig() throws RaplixException {
        NodeStatus ns = this.mNodeAdmin.getNodeStatus(new AppInstanceID(this.mID));
        this.mVersion = ns.getAppVersion();
        this.mUser = ns.getUserRunningAs();
        this.mCacheMax = ns.getResCacheMaxSize();
        this.mCacheFilled = ns.getResCacheCurrentSize();
        if (this.mCacheMax > 0L) {
            this.mCachePercentage = this.mCacheFilled * 100L / this.mCacheMax;
        }
        this.mSnapshotSize = ns.getResSnapshotCurrentSize();
        Hashtable ht = ns.getConfigProperties();
        Enumeration enumeration = ht.keys();
        Vector v = new Vector();
        while (enumeration.hasMoreElements()) {
            v.add(enumeration.nextElement());
        }
        this.mConfigNames = v.toArray(new String[0]);
        Arrays.sort(this.mConfigNames);
        this.mConfigValues = new String[this.mConfigNames.length];
        for (int i = 0; i < this.mConfigNames.length; ++i) {
            this.mConfigValues[i] = (String)ht.get(this.mConfigNames[i]);
        }
        this.mTraceSucceeded = true;
    }

    public void clearCache(String id) throws RaplixException {
        this.mNodeAdmin.clearResourceCache(new AppInstanceID(id));
        this.mClearingCache = true;
    }

    public void fetchLog() throws RaplixException {
        LogFileSnapshot lfs = this.mNodeAdmin.getLogFileSnapshot(new AppInstanceID(this.mID));
        this.mLog = lfs.getContent();
        this.mLogTruncation = lfs.getOffset() > 0L ? lfs.getTotalSize() - lfs.getOffset() : 0L;
        this.mTraceSucceeded = true;
    }
}

