/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.transport.HostNotFound;
import com.raplix.rolloutexpress.net.transport.TraceFailed;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.hosts.HostTraceBean;
import com.raplix.util.logger.Logger;
import javax.servlet.http.HttpServletRequest;

public final class HostTraceAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CONNECTION = "error.hostTrace.connection";
    public static final String MSG_ERROR_UNREACHABLE = "error.hostTrace.unreachable";
    public static final String MSG_ERROR_NOT_FOUND = "error.hostTrace.notFound";
    public static final String MSG_ERROR_CONFIGURATION = "error.hostTrace.configuration";
    public static final String MSG_ERROR_LOG = "error.hostTrace.log";
    public static final String MSG_ERROR_CLEARCACHE = "error.hostTrace.clearcache";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "connection";
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through HostTraceAction: " + mode, this);
        }
        servletInfo.setSaveInSession(false);
        if (mode.equals("connection")) {
            this.handleConnection(request, servletInfo);
        } else if (mode.equals("configuration")) {
            this.handleConfiguration(request, servletInfo);
        } else if (mode.equals("log")) {
            this.handleLog(request, servletInfo);
        } else if (mode.equals("clearcache")) {
            this.handleClearCache(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostTraceAction.");
        }
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = inRequest.getParameter("mode");
        if (mode == null) {
            mode = "connection";
        }
        if (mode.equals("connection")) {
            return MSG_ERROR_CONNECTION;
        }
        if (mode.equals("configuration")) {
            return MSG_ERROR_CONFIGURATION;
        }
        if (mode.equals("log")) {
            return MSG_ERROR_LOG;
        }
        if (mode.equals("clearcache")) {
            return MSG_ERROR_CLEARCACHE;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to HostTraceAction.");
    }

    private void handleConnection(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTraceBean htb = (HostTraceBean)servletInfo.getBean();
        String id = HostTraceAction.assertGetParam(request, "id");
        htb.setMode("connection");
        htb.fetchInstance(id);
        try {
            htb.doTrace();
        }
        catch (TraceFailed tf) {
            htb.setTraceResult(tf.getPartialResult());
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_UNREACHABLE);
            servletInfo.getErrors().addMinorError(tf.getMessage());
        }
        catch (HostNotFound hnf) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CONNECTION);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NOT_FOUND);
        }
        if (htb.getTraceResult() != null) {
            htb.processResult(servletInfo);
        }
        servletInfo.setDestPage("/hosts/hostTrace.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleConfiguration(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTraceBean htb = (HostTraceBean)servletInfo.getBean();
        String id = HostTraceAction.assertGetParam(request, "id");
        htb.setMode("configuration");
        htb.fetchInstance(id);
        try {
            htb.fetchConfig();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CONFIGURATION);
            servletInfo.getErrors().addMinorError(re.getMessage());
        }
        servletInfo.setDestPage("/hosts/hostConfiguration.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleLog(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTraceBean htb = (HostTraceBean)servletInfo.getBean();
        String id = HostTraceAction.assertGetParam(request, "id");
        htb.setMode("log");
        htb.fetchInstance(id);
        try {
            htb.fetchLog();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_LOG);
            servletInfo.getErrors().addMinorError(re.getMessage());
        }
        servletInfo.setDestPage("/hosts/hostLog.jsp");
        servletInfo.setShouldRedirect(false);
        servletInfo.setSaveInSession(false);
    }

    private void handleClearCache(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostTraceBean htb = (HostTraceBean)servletInfo.getBean();
        String id = HostTraceAction.assertGetParam(request, "id");
        try {
            htb.clearCache(id);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_CLEARCACHE);
            servletInfo.getErrors().addMinorError(re.getMessage());
        }
        this.handleConfiguration(request, servletInfo);
    }

    public ServletBean createBean(HttpServletRequest request) {
        TransportServices transServ = HostTraceAction.getApplication().getTransportServices();
        NodeManagementServices nodeAdmin = HostTraceAction.getApplication().getNodeManagementServices();
        HostTraceBean htb = new HostTraceBean(transServ, nodeAdmin);
        return htb;
    }

    public String getDefaultPage() {
        return "/hosts/hostTrace.jsp";
    }

    protected boolean isPopup(HttpServletRequest request) {
        return true;
    }
}

