/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRefID;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.util.ArrayEdit;
import java.util.HashSet;
import java.util.Vector;

public class HostSetsListBean
extends ServletListBean {
    private static ObjectOrder DEFAULT_SORT_ORDER = HostSetOrder.BY_NAME_ASC;
    private String[] mNames = new String[0];
    private String[] mDescriptions = new String[0];
    private String[] mIDs = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mMode = "";
    private boolean mHasWriteOnHostSets = true;

    public String[] getNames() {
        return this.mNames;
    }

    public String[] getDescriptions() {
        return this.mDescriptions;
    }

    public String[] getIDs() {
        return this.mIDs;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public boolean getHasWriteOnHostSets() {
        return this.mHasWriteOnHostSets;
    }

    public void generateList() throws RaplixException {
        MultiHostSetQuery query = MultiHostSetQuery.all();
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.selectSummaryView());
    }

    public void loadAllHostSets() throws RaplixException {
        MultiHostSetQuery query = MultiHostSetQuery.all();
        this.generateOutputArrays(query.selectSummaryView());
    }

    public void loadAllSupportedHostSets() throws RaplixException {
        MultiHostSetQuery query = MultiHostSetQuery.all();
        query.setIsSupportedFilter(Boolean.TRUE);
        this.generateOutputArrays(query.selectSummaryView());
    }

    public void loadAllHostSetsPlusExtras(String[] extraIDs) throws RaplixException {
        HashSet<String> hs = new HashSet<String>();
        Vector<SummaryHostSet> extraSets = new Vector<SummaryHostSet>();
        for (int i = 0; i < extraIDs.length; ++i) {
            if (hs.contains(extraIDs[i])) continue;
            hs.add(extraIDs[i]);
            SummaryHostSet shs = HostSetsBean.getSummaryHostSetByID(extraIDs[i]);
            if (!shs.getVisibility().equals(Visibility.HIDDEN)) continue;
            extraSets.add(shs);
        }
        MultiHostSetQuery query = MultiHostSetQuery.all();
        this.generateOutputArrays(query.selectSummaryView(), extraSets);
    }

    public void loadAllPlatforms() throws RaplixException {
        MultiHostSetQuery query = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID.getDescendantsQuery();
        SummaryHostSet[] sets = query.selectSummaryView();
        this.loadAllPlatformsHelper(sets);
    }

    public void loadAllSupportedPlatforms(HostSetID hsID, ComponentType ct) throws RaplixException {
        ComponentTypeRefID ctrid = SingleComponentTypeRefQuery.byName(ct.getTypeName()).select().getID();
        MultiHostSetQuery mhsq = ctrid.getPlatformsQuery();
        mhsq.setIsSupportedFilter(Boolean.TRUE);
        Object[] sets = mhsq.selectSummaryView();
        SummaryHostSet sHS = hsID.getByIDQuery().selectSummaryView();
        if (!sHS.isSupported()) {
            sets = (SummaryHostSet[])ArrayEdit.add(sets, sHS);
        }
        this.loadAllPlatformsHelper((SummaryHostSet[])sets);
    }

    public void loadSupportedPlatforms(HostSetID platformID) throws RaplixException {
        MultiHostSetQuery mhsq = platformID.getDescendantsQuery();
        mhsq.setIsSupportedFilter(Boolean.TRUE);
        SummaryHostSet[] sets = mhsq.selectSummaryView();
        this.loadAllPlatformsHelper(sets);
    }

    public void loadAllSupportedPlatforms(HostSetID hsID) throws RaplixException {
        MultiHostSetQuery query = SystemPluginConstants.getInstance().ALL_PLATFORMS_ID.getDescendantsQuery();
        query.setIsSupportedFilter(Boolean.TRUE);
        Object[] sets = query.selectSummaryView();
        SummaryHostSet sHS = hsID.getByIDQuery().selectSummaryView();
        if (!sHS.isSupported()) {
            sets = (SummaryHostSet[])ArrayEdit.add(sets, sHS);
        }
        this.loadAllPlatformsHelper((SummaryHostSet[])sets);
    }

    private void loadAllPlatformsHelper(SummaryHostSet[] sets) throws RPCException, PersistenceManagerException {
        for (int i = 0; i < sets.length; ++i) {
            if (!sets[i].getID().equals(SystemPluginConstants.getInstance().ALL_PLATFORMS_ID)) continue;
            SummaryHostSet all = sets[i];
            for (int j = i - 1; j >= 0; --j) {
                sets[j + 1] = sets[j];
            }
            sets[0] = all;
            break;
        }
        this.generateOutputArrays(sets);
    }

    private void generateOutputArrays(SummaryHostSet[] sets) {
        this.mNames = new String[sets.length];
        this.mDescriptions = new String[sets.length];
        this.mIDs = new String[sets.length];
        this.mIsHidden = new boolean[sets.length];
        for (int i = 0; i < sets.length; ++i) {
            this.mNames[i] = sets[i].getName();
            this.mDescriptions[i] = sets[i].getDescription();
            this.mIDs[i] = sets[i].getID().toString();
            this.mIsHidden[i] = sets[i].getVisibility().equals(Visibility.HIDDEN);
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mIDs);
        this.mHasWriteOnHostSets = PermissionChecker.hasWriteOnHostSets();
    }

    private void generateOutputArrays(SummaryHostSet[] sets, Vector extra) {
        int i;
        this.mNames = new String[sets.length + extra.size()];
        this.mDescriptions = new String[sets.length + extra.size()];
        this.mIDs = new String[sets.length + extra.size()];
        this.mIsHidden = new boolean[sets.length + extra.size()];
        for (i = 0; i < extra.size(); ++i) {
            SummaryHostSet shs = (SummaryHostSet)extra.elementAt(i);
            this.mNames[i] = shs.getName();
            this.mDescriptions[i] = shs.getDescription();
            this.mIDs[i] = shs.getID().toString();
            this.mIsHidden[i] = shs.getVisibility().equals(Visibility.HIDDEN);
        }
        for (i = 0; i < sets.length; ++i) {
            this.mNames[i + extra.size()] = sets[i].getName();
            this.mDescriptions[i + extra.size()] = sets[i].getDescription();
            this.mIDs[i + extra.size()] = sets[i].getID().toString();
            this.mIsHidden[i + extra.size()] = sets[i].getVisibility().equals(Visibility.HIDDEN);
        }
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(HostSetOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return true;
    }
}

