/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletErrors;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class HostSetsHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CREATE = "error.hostSets.create";
    public static final String MSG_ERROR_EDIT = "error.hostSets.edit";
    public static final String MSG_ERROR_CANCEL = "error.hostSets.cancel";
    public static final String MSG_ERROR_REMOVE = "error.hostSets.remove";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.hostSets.save.major";
    public static final String MSG_ERROR_ADD_MEMBER = "error.hostSets.addMember";
    public static final String MSG_ERROR_ADD_MEMBER_INVALID_HOST = "error.hostSets.addMember.invalidHost";
    public static final String MSG_ERROR_ADD_MEMBER_NO_HOST = "error.hostSets.addMember.noHost";
    public static final String MSG_ERROR_ADD_MEMBER_NO_HOSTSET = "error.hostSets.addMember.noHostSet";
    public static final String MSG_ERROR_ADD_MEMBER_NO_HOSTSEARCH = "error.hostSets.addMember.noHostSearch";
    public static final String MSG_ERROR_ADD_MEMBER_HOST_EXISTS = "error.hostSets.addMember.hostExists";
    public static final String MSG_ERROR_ADD_MEMBER_HOSTSET_EXISTS = "error.hostSets.addMember.hostSetExists";
    public static final String MSG_ERROR_ADD_MEMBER_HOSTSEARCH_EXISTS = "error.hostSets.addMember.hostSearchExists";
    public static final String MSG_ERROR_CHANGE_MEMBER = "error.hostSets.changeMember";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = HostSetsHandleAction.assertGetParam(request, "mode");
        Logger.debug("Coming through HostSetsHandleAction: " + mode, this);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("addmember")) {
            this.handleAddMember(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("viewmember")) {
            this.handleViewMember(request, servletInfo);
        } else if (mode.equals("refresh")) {
            this.handleRefresh(request, servletInfo);
        } else if (mode.equals("removemember")) {
            this.handleRemoveMember(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveAsConfirmed(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to HostSetsHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new HostSetsBean();
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = HostSetsHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("addmember")) {
            return MSG_ERROR_ADD_MEMBER;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("viewmember")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("refresh")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("removemember")) {
            return MSG_ERROR_REMOVE;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to HostSetsHandleAction.");
    }

    public String getDefaultPage() {
        return "/hosts/hostSetDetails.jsp";
    }

    protected void handleSaveAsConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        hsb.generateMemberHosts();
        try {
            hsb.persist();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            hsb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostSetConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hsb.setMode("saveas");
            servletInfo.setDestPage("/hosts/hostSetConfirm.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostSets");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        hsb.generateMemberHosts();
        try {
            hsb.persist();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            hsb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hsb.setMode("edit");
            servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostSets");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        hsb.generateMemberHosts();
        hsb.setIsNew(true);
        servletInfo.setDestPage("/hosts/hostSetConfirm.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRemoveMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        String idxStr = HostSetsHandleAction.assertGetParam(request, "editIndex");
        int index = Integer.parseInt(idxStr);
        hsb.removeMember(index);
        hsb.generateMemberHosts();
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleViewMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        String idxStr = HostSetsHandleAction.assertGetParam(request, "editIndex");
        int index = Integer.parseInt(idxStr);
        hsb.loadHighlightedMemberHosts(index);
        hsb.generateMemberHosts();
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRefresh(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        hsb.loadHostSetsAndSearchesArrays();
        hsb.generateMemberHosts();
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAddMember(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        String memberType = HostSetsHandleAction.assertGetParam(request, "newMemberType");
        String memberName = null;
        String memberID = null;
        if (memberType.equals("host")) {
            memberName = HostSetsHandleAction.assertGetParam(request, "newHostValue");
        } else {
            memberID = memberType.equals("host set") ? request.getParameter("newHostSetValue") : request.getParameter("newHostSearchValue");
        }
        this.addNewMembers(hsb, servletInfo.getErrors(), memberName, memberID, memberType);
        hsb.generateMemberHosts();
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/HostSets");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        this.loadRequestParameters(request, hsb);
        hsb.generateMemberHosts();
        hsb.setMode("edit");
        hsb.setIsNew(false);
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        hsb.createHostSet(name, description);
        hsb.setMode("add");
        hsb.loadHostSetsAndSearchesArrays();
        hsb.loadPermissionLookaheads(null);
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSetsBean hsb = (HostSetsBean)servletInfo.getBean();
        String id = request.getParameter("id");
        hsb.loadSingleHostSet(id);
        hsb.loadHostSetsAndSearchesArrays();
        hsb.setMode("edit");
        servletInfo.setDestPage("/hosts/hostSetDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void loadRequestParameters(HttpServletRequest request, HostSetsBean hsb) throws RaplixException {
        String name;
        hsb.setName(HostSetsHandleAction.assertGetParam(request, "name"));
        hsb.setDescription(HostSetsHandleAction.assertGetParam(request, "description"));
        hsb.setPluginID(request.getParameter("pluginID"));
        hsb.setPluginName(request.getParameter("pluginName"));
        hsb.setWriteOnPlugin(request.getParameter("writeOnPlugin") != null);
        hsb.setHasWriteOnHostSets(request.getParameter("hasWriteOnHostSets") != null);
        hsb.setID(HostSetsHandleAction.assertGetParam(request, "id"));
        hsb.setIsNew("true".equals(HostSetsHandleAction.assertGetParam(request, "isNew")));
        hsb.setIsHidden(request.getParameter("isHidden") != null);
        hsb.setMode(HostSetsHandleAction.assertGetParam(request, "mode"));
        hsb.setUpdateCount(Integer.parseInt(HostSetsHandleAction.assertGetParam(request, "updateCount")));
        hsb.setNewMemberHostName(request.getParameter("newHostValue"));
        hsb.setNewMemberHostSetID(request.getParameter("newHostSetValue"));
        hsb.setNewMemberHostSearchID(request.getParameter("newHostSearchValue"));
        int i = 0;
        Vector<String> names = new Vector<String>();
        Vector<String> ids = new Vector<String>();
        Vector<String> types = new Vector<String>();
        while ((name = request.getParameter("membername" + i)) != null) {
            String id = HostSetsHandleAction.assertGetParam(request, "memberid" + i);
            String type = HostSetsHandleAction.assertGetParam(request, "membertype" + i);
            names.add(name);
            ids.add(id);
            types.add(type);
            ++i;
        }
        hsb.setMemberNames(names);
        hsb.setMemberIDs(ids);
        hsb.setMemberTypes(types);
        hsb.loadHostSetsAndSearchesArrays();
    }

    private boolean addNewMembers(HostSetsBean hsb, ServletErrors errors, String newMemberName, String newMemberID, String newMemberType) {
        boolean isAllValid = true;
        boolean memberAdded = false;
        if (newMemberType.equals("host")) {
            if (newMemberName == null || newMemberName.equals("")) {
                errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_NO_HOST);
                isAllValid = false;
            } else {
                String[] hosts = Util.arrayifyCommaSemiSeparated(newMemberName);
                for (int i = 0; i < hosts.length; ++i) {
                    try {
                        SummaryHost tmpHost = HostsBean.getSummaryHostByName(hosts[i]);
                        if (!Arrays.asList(hsb.getMemberIDs()).contains(tmpHost.getID().toString())) {
                            hsb.addMember(newMemberType, tmpHost.getID().toString(), hosts[i]);
                            memberAdded = true;
                            continue;
                        }
                        errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_HOST_EXISTS, hosts[i]);
                        isAllValid = false;
                        continue;
                    }
                    catch (RaplixException e) {
                        Logger.debug("Couldn't find hostName (" + hosts[i] + ") in hostDB", this);
                        errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_INVALID_HOST, hosts[i]);
                        isAllValid = false;
                    }
                }
            }
        } else if (newMemberType.equals("host search")) {
            if (newMemberID == null) {
                errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_NO_HOSTSEARCH);
                isAllValid = false;
            } else if (Arrays.asList(hsb.getMemberIDs()).contains(newMemberID)) {
                errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_HOSTSEARCH_EXISTS, this.translate(newMemberID, hsb.getHostSearchIDs(), hsb.getHostSearchNames()));
                isAllValid = false;
            } else {
                hsb.addMember(newMemberType, newMemberID, this.translate(newMemberID, hsb.getHostSearchIDs(), hsb.getHostSearchNames()));
                memberAdded = true;
            }
        } else if (newMemberType.equals("host set")) {
            if (newMemberID == null) {
                errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_NO_HOSTSET);
                isAllValid = false;
            } else if (Arrays.asList(hsb.getMemberIDs()).contains(newMemberID)) {
                errors.addMinorErrorKey(MSG_ERROR_ADD_MEMBER_HOSTSET_EXISTS, this.translate(newMemberID, hsb.getHostSetIDs(), hsb.getHostSetNames()));
                isAllValid = false;
            } else {
                hsb.addMember(newMemberType, newMemberID, this.translate(newMemberID, hsb.getHostSetIDs(), hsb.getHostSetNames()));
                memberAdded = true;
            }
        } else {
            isAllValid = false;
        }
        if (isAllValid) {
            hsb.setNewMemberHostName("");
            hsb.setNewMemberHostSetID("");
            hsb.setNewMemberHostSearchID("");
        } else {
            errors.setMajorErrorKey(MSG_ERROR_ADD_MEMBER);
        }
        return memberAdded;
    }

    private String translate(String id, String[] allIDs, String[] allNames) {
        for (int i = 0; i < allIDs.length; ++i) {
            if (!allIDs[i].equals(id)) continue;
            if (i < allNames.length && allNames[i] != null) {
                return allNames[i];
            }
            return "";
        }
        return "";
    }
}

