/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSearchesListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;
import java.util.Vector;

public class HostSetsBean
extends ServletBean {
    public static final String TYPE_HOST = "host";
    public static final String TYPE_HOSTSET = "host set";
    public static final String TYPE_HOSTSEARCH = "host search";
    private String mName = "";
    private String mDesc = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mHasWriteOnHostSets = true;
    private String mID = "";
    private boolean mIsNew = false;
    private boolean mIsHidden = false;
    private String mMode = "";
    private int mUpdateCount = -1;
    private Vector mMemberIDs = new Vector();
    private Vector mMemberNames = new Vector();
    private Vector mMemberTypes = new Vector();
    private String[] mHostSetNames = new String[0];
    private String[] mHostSetIDs = new String[0];
    private String[] mHostSearchNames = new String[0];
    private String[] mHostSearchIDs = new String[0];
    private String mNewMemberHostName = "";
    private String mNewMemberHostSetID = "";
    private String mNewMemberHostSearchID = "";
    private String[] mCurrentHostNames = new String[0];
    private String[] mCurrentlyHighlightedHosts = new String[0];
    private int mRemoteAgentCount = 0;
    private int mLocalDistributorCount = 0;
    private int mPhysicalCount = 0;
    private int mVirtualCount = 0;

    public void setName(String in) {
        this.mName = in;
    }

    public void setDescription(String in) {
        this.mDesc = in;
    }

    public void setPluginID(String id) {
        this.mPluginID = id;
    }

    public void setPluginName(String name) {
        this.mPluginName = name;
    }

    public void setWriteOnPlugin(boolean write) {
        this.mWriteOnPlugin = write;
    }

    public void setHasWriteOnHostSets(boolean write) {
        this.mHasWriteOnHostSets = write;
    }

    public void setID(String in) {
        this.mID = in;
    }

    public void setIsNew(boolean in) {
        this.mIsNew = in;
    }

    public void setIsHidden(boolean in) {
        this.mIsHidden = in;
    }

    public void setMode(String in) {
        this.mMode = in;
    }

    public void setUpdateCount(int in) {
        this.mUpdateCount = in;
    }

    public void setMemberIDs(Vector in) {
        this.mMemberIDs = in;
    }

    public void setMemberNames(Vector in) {
        this.mMemberNames = in;
    }

    public void setMemberTypes(Vector in) {
        this.mMemberTypes = in;
    }

    public void setNewMemberHostName(String in) {
        this.mNewMemberHostName = in;
    }

    public void setNewMemberHostSetID(String in) {
        this.mNewMemberHostSetID = in;
    }

    public void setNewMemberHostSearchID(String in) {
        this.mNewMemberHostSearchID = in;
    }

    public String getID() {
        if (this.mID.equals("")) {
            return super.getID();
        }
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDesc;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getHasWriteOnHostSets() {
        return this.mHasWriteOnHostSets;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public String getMode() {
        return this.mMode;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public String[] getMemberIDs() {
        return this.mMemberIDs.toArray(new String[0]);
    }

    public String[] getMemberNames() {
        return this.mMemberNames.toArray(new String[0]);
    }

    public String[] getMemberTypes() {
        return this.mMemberTypes.toArray(new String[0]);
    }

    public String[] getHostSearchNames() {
        return this.mHostSearchNames;
    }

    public String[] getHostSearchIDs() {
        return this.mHostSearchIDs;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String getNewHostValue() {
        return this.mNewMemberHostName;
    }

    public String getNewHostSetValue() {
        return this.mNewMemberHostSetID;
    }

    public String getNewHostSearchValue() {
        return this.mNewMemberHostSearchID;
    }

    public String[] getCurrentHostNames() {
        return this.mCurrentHostNames;
    }

    public String[] getCurrentlyHighlightedHosts() {
        return this.mCurrentlyHighlightedHosts;
    }

    public int getRemoteAgentCount() {
        return this.mRemoteAgentCount;
    }

    public int getLocalDistributorCount() {
        return this.mLocalDistributorCount;
    }

    public int getPhysicalCount() {
        return this.mPhysicalCount;
    }

    public int getVirtualCount() {
        return this.mVirtualCount;
    }

    public void loadHostSetsAndSearchesArrays() throws RaplixException {
        HostSetsListBean setsList = new HostSetsListBean();
        setsList.loadAllHostSets();
        this.mHostSetNames = setsList.getNames();
        this.mHostSetIDs = setsList.getIDs();
        HostSearchesListBean searchesList = new HostSearchesListBean();
        searchesList.loadAllHostSearches();
        this.mHostSearchNames = searchesList.getSearchNames();
        this.mHostSearchIDs = searchesList.getSearchIDs();
    }

    public void createHostSet(String name, String description) {
        this.mName = name;
        this.mDesc = description;
        this.mID = "";
        this.mIsNew = true;
        this.mIsHidden = false;
        this.mUpdateCount = 0;
    }

    public void loadSingleHostSet(String inHostSetID) throws RaplixException {
        HostSet set = new HostSetID(inHostSetID).getByIDQuery().select();
        this.mName = set.getName();
        this.mDesc = set.getDescription();
        PluginID pluginID = set.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.loadPermissionLookaheads(set);
        this.mID = set.getID().toString();
        this.mIsNew = false;
        this.mIsHidden = set.getVisibility().equals(Visibility.HIDDEN);
        this.mUpdateCount = set.getUpdateCount();
        HostIDSet subHostIDs = set.getMemberHostIDSet();
        HostSetIDSet subHostSetIDs = set.getMemberHostSetIDSet();
        HostSearchIDSet subHostSearchIDs = set.getMemberHostSearchIDSet();
        this.mMemberTypes = new Vector();
        this.mMemberIDs = new Vector();
        this.mMemberNames = new Vector();
        SummaryHost[] hosts = subHostIDs.getByIDsQuery().selectSummaryView();
        for (int i = 0; i < hosts.length; ++i) {
            this.mMemberTypes.add(TYPE_HOST);
            this.mMemberIDs.add(hosts[i].getID().toString());
            this.mMemberNames.add(hosts[i].getName());
        }
        SummaryHostSet[] hostSets = subHostSetIDs.getByIDsQuery().selectSummaryView();
        for (int i = 0; i < hostSets.length; ++i) {
            this.mMemberTypes.add(TYPE_HOSTSET);
            this.mMemberIDs.add(hostSets[i].getID().toString());
            this.mMemberNames.add(hostSets[i].getName());
        }
        SummaryHostSearch[] hostSearchs = subHostSearchIDs.getByIDsQuery().selectSummaryView();
        for (int i = 0; i < hostSearchs.length; ++i) {
            this.mMemberTypes.add(TYPE_HOSTSEARCH);
            this.mMemberIDs.add(hostSearchs[i].getID().toString());
            this.mMemberNames.add(hostSearchs[i].getName());
        }
        this.loadMemberHosts(set);
    }

    public void addMember(String type, String id, String name) {
        this.mMemberTypes.add(type);
        this.mMemberIDs.add(id);
        this.mMemberNames.add(name);
    }

    public void removeMember(int removeIdx) {
        this.mMemberIDs.remove(removeIdx);
        this.mMemberNames.remove(removeIdx);
        this.mMemberTypes.remove(removeIdx);
    }

    public void persist() throws RaplixException {
        HostSet set = this.mIsNew ? new HostSet() : new HostSetID(this.mID).getByIDQuery().select();
        this.copySettingsIntoHostSet(set);
        set.save();
    }

    public void loadHighlightedMemberHosts(int index) throws RaplixException {
        String type = (String)this.mMemberTypes.elementAt(index);
        String id = (String)this.mMemberIDs.elementAt(index);
        String name = (String)this.mMemberNames.elementAt(index);
        SummaryHost[] hosts = type.equals(TYPE_HOSTSET) ? new HostSetID(id).getByIDQuery().select().getAllHostsQuery().selectSummaryView() : new HostSearchID(id).getByIDQuery().select().getCriteria().getAllHostsQuery().selectSummaryView();
        this.mCurrentlyHighlightedHosts = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            this.mCurrentlyHighlightedHosts[i] = hosts[i].getName();
        }
    }

    public void generateMemberHosts() throws RaplixException {
        HostSet set = new HostSet();
        this.copySettingsIntoHostSet(set);
        this.loadMemberHosts(set);
    }

    public static SummaryHostSet getSummaryHostSetByName(String name) throws RaplixException {
        return SingleHostSetQuery.byName(name).selectSummaryView();
    }

    public static SummaryHostSet getSummaryHostSetByID(String id) throws RaplixException {
        return HostSetsBean.getSummaryHostSetByID(new HostSetID(id));
    }

    public static SummaryHostSet getSummaryHostSetByID(HostSetID id) throws RaplixException {
        return id.getByIDQuery().selectSummaryView();
    }

    private void loadMemberHosts(HostSet set) throws RaplixException {
        Host[] hosts = set.getAllHostsQuery().select();
        this.mCurrentHostNames = new String[hosts.length];
        this.mRemoteAgentCount = 0;
        this.mLocalDistributorCount = 0;
        this.mVirtualCount = 0;
        this.mPhysicalCount = 0;
        for (int i = 0; i < hosts.length; ++i) {
            this.mCurrentHostNames[i] = hosts[i].getName();
            if (hosts[i].getAppRA() != null) {
                ++this.mRemoteAgentCount;
            }
            if (hosts[i].getAppLD() != null) {
                ++this.mLocalDistributorCount;
            }
            if (hosts[i].isVirtual()) {
                ++this.mVirtualCount;
                continue;
            }
            ++this.mPhysicalCount;
        }
    }

    private void copySettingsIntoHostSet(HostSet set) {
        set.setSimpleName(this.mName);
        set.setDescription(this.mDesc);
        set.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
        set.setUpdateCount(this.mUpdateCount);
        HostIDSet subHostIDs = new HostIDSet();
        HostSetIDSet subHostSetIDs = new HostSetIDSet();
        HostSearchIDSet subHostSearchIDs = new HostSearchIDSet();
        for (int i = 0; i < this.mMemberIDs.size(); ++i) {
            if (this.mMemberTypes.elementAt(i).equals(TYPE_HOST)) {
                subHostIDs.add(new HostID((String)this.mMemberIDs.elementAt(i)));
                continue;
            }
            if (this.mMemberTypes.elementAt(i).equals(TYPE_HOSTSET)) {
                subHostSetIDs.add(new HostSetID((String)this.mMemberIDs.elementAt(i)));
                continue;
            }
            subHostSearchIDs.add(new HostSearchID((String)this.mMemberIDs.elementAt(i)));
        }
        set.setMemberHostIDSet(subHostIDs);
        set.setMemberHostSetIDSet(subHostSetIDs);
        set.setMemberHostSearchIDSet(subHostSearchIDs);
    }

    void loadPermissionLookaheads(HostSet set) {
        if (set != null) {
            this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(set);
        }
        this.mHasWriteOnHostSets = PermissionChecker.hasWriteOnHostSets();
    }
}

