/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class HostSetDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;

    public HostSetDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
    }

    public int getDeleteConfirmColspan() {
        return 2;
    }

    public String getDeleteContext() {
        return "hostSetDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        HostSetID hostSetID = (HostSetID)candidate.getParent().getObjectID();
        return hostSetID.getByIDQuery().selectSummaryView();
    }

    public void preRender() throws RaplixException {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.hostSetEditURI(this.mObjectID.toString());
        String toolTip = "Show host set details";
        String nameLink = Util.standardLink(editURI, toolTip, this.mName, "name=\"nameLink-" + this.mObjectID + "\"");
        String descLink = Util.standardLink(editURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

