/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchOrder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;

public class HostSearchesListBean
extends ServletListBean {
    private static HostSearchOrder DEFAULT_SORT_ORDER = HostSearchOrder.BY_NAME_ASC;
    private String[] mNames = new String[0];
    private String[] mDescriptions = new String[0];
    private String[] mIDs = new String[0];
    private boolean[] mIsHidden = new boolean[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mMode = "";
    private boolean mHasWriteOnHostSearches = true;

    public String[] getSearchNames() {
        return this.mNames;
    }

    public String[] getSearchDescriptions() {
        return this.mDescriptions;
    }

    public String[] getSearchIDs() {
        return this.mIDs;
    }

    public boolean[] getIsHidden() {
        return this.mIsHidden;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public boolean getHasWriteOnHostSearches() {
        return this.mHasWriteOnHostSearches;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void generateList() throws RaplixException {
        MultiHostSearchQuery query = MultiHostSearchQuery.all();
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generateOutputArrays(query.selectSummaryView());
    }

    public void loadAllHostSearches() throws RaplixException {
        MultiHostSearchQuery query = MultiHostSearchQuery.all();
        this.generateOutputArrays(query.selectSummaryView());
    }

    private void generateOutputArrays(SummaryHostSearch[] searches) {
        this.mNames = new String[searches.length];
        this.mDescriptions = new String[searches.length];
        this.mIDs = new String[searches.length];
        this.mIsHidden = new boolean[searches.length];
        for (int i = 0; i < searches.length; ++i) {
            this.mNames[i] = searches[i].getName();
            this.mDescriptions[i] = searches[i].getDescription();
            this.mIDs[i] = searches[i].getID().toString();
            this.mIsHidden[i] = searches[i].getVisibility().equals(Visibility.HIDDEN);
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mIDs);
        this.mHasWriteOnHostSearches = PermissionChecker.hasWriteOnHostSearches();
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(HostSearchOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return true;
    }
}

