/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.hosts.HostSearchesBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class HostSearchesHandleAction
extends UIActionServlet
implements ActionModeConstants {
    public static final String MSG_ERROR_CREATE = "error.hostSearches.create";
    public static final String MSG_ERROR_EDIT = "error.hostSearches.edit";
    public static final String MSG_ERROR_CANCEL = "error.hostSearches.cancel";
    public static final String MSG_ERROR_REMOVE_QUERY = "error.hostSearches.removeQuery";
    public static final String MSG_ERROR_SAVE_MAJOR = "error.hostSearches.save.major";
    public static final String MSG_ERROR_ADD_QUERY = "error.hostSearches.addQuery";
    public static final String MSG_ERROR_ADD_QUERY_BAD_PATTERN = "error.hostSearches.addQuery.badPattern";
    public static final String MSG_ERROR_DISPLAY_HOSTS = "error.hostSearches.displayHosts";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = HostSearchesHandleAction.assertGetParam(request, "mode");
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Coming through HostSearchesHandleAction: " + mode, this);
        }
        servletInfo.setSaveInSession(false);
        if (mode.equals("add")) {
            this.handleAdd(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("addquery")) {
            this.handleAddQuery(request, servletInfo);
        } else if (mode.equals("removequery")) {
            this.handleRemoveQuery(request, servletInfo);
        } else if (mode.equals("changequery")) {
            this.handleChangeQuery(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("saveas")) {
            this.handleSaveAs(request, servletInfo);
        } else if (mode.equals("saveconfirmed")) {
            this.handleSaveConfirmed(request, servletInfo);
        } else if (mode.equals("notconfirmed")) {
            this.handleNotConfirmed(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode passed to HostSearchesHandleAction.");
        }
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new HostSearchesBean();
    }

    public String getMajorError(HttpServletRequest inRequest) {
        String mode = HostSearchesHandleAction.assertGetParam(inRequest, "mode");
        if (mode.equals("add")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("addquery")) {
            return MSG_ERROR_ADD_QUERY;
        }
        if (mode.equals("removequery")) {
            return MSG_ERROR_REMOVE_QUERY;
        }
        if (mode.equals("changequery")) {
            return MSG_ERROR_DISPLAY_HOSTS;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveas")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("saveconfirmed")) {
            return MSG_ERROR_SAVE_MAJOR;
        }
        if (mode.equals("notconfirmed")) {
            return MSG_ERROR_CANCEL;
        }
        throw new IllegalArgumentException("Unknown mode passed to HostSearchesHandleAction.");
    }

    public String getDefaultPage() {
        return "/hosts/hostSearchDetails.jsp";
    }

    protected void handleAdd(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        hsb.setIsNew(true);
        String name = request.getParameter("name");
        String desc = request.getParameter("description");
        hsb.createHostSearch(name, desc);
        this.readQueryArgsFromRequest(request, hsb);
        hsb.loadPermissionLookaheads();
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage(this.getDetailsPage(request));
        servletInfo.setShouldRedirect(false);
    }

    protected void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/HostSearches");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        String id = HostSearchesHandleAction.assertGetParam(request, "id");
        hsb.loadAllAttributes();
        hsb.loadHostSearch(id);
        hsb.setIsNew(false);
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage("/hosts/hostSearchDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    protected void handleAddQuery(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        if (!hsb.addNewQuery()) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ADD_QUERY);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_ADD_QUERY_BAD_PATTERN);
        }
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage(this.getDetailsPage(request));
        servletInfo.setShouldRedirect(false);
    }

    protected void handleRemoveQuery(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        String removeIdxStr = HostSearchesHandleAction.assertGetParam(request, "editIndex");
        int removeIndex = Integer.parseInt(removeIdxStr);
        hsb.removeQuery(removeIndex);
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage(this.getDetailsPage(request));
        servletInfo.setShouldRedirect(false);
    }

    protected void handleChangeQuery(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage(this.getDetailsPage(request));
        servletInfo.setShouldRedirect(false);
    }

    protected void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        String id = HostSearchesHandleAction.assertGetParam(request, "id");
        String isNew = HostSearchesHandleAction.assertGetParam(request, "isNew");
        if (isNew.equals("false")) {
            hsb.loadHostSearch(id);
        }
        this.readFromRequest(request, hsb);
        hsb.refreshCurrentHostNames();
        try {
            hsb.persist();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            hsb.setMode("edit");
            servletInfo.setDestPage(this.getDetailsPage(request));
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hsb.setMode("edit");
            servletInfo.setDestPage(this.getDetailsPage(request));
            servletInfo.setShouldRedirect(false);
            return;
        }
        servletInfo.setDestPage("/HostSearches");
        servletInfo.setShouldRedirect(true);
    }

    protected void handleSaveConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        hsb.setHostSearch(null);
        hsb.refreshCurrentHostNames();
        try {
            hsb.persist();
        }
        catch (PersistenceManagerException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(e.getMessage());
            hsb.setMode("saveas");
            servletInfo.setDestPage(this.getConfirmPage(request));
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException e) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE_MAJOR);
            servletInfo.getErrors().addMinorError(this.ACExToString(e));
            hsb.setMode("saveas");
            servletInfo.setDestPage(this.getConfirmPage(request));
            servletInfo.setShouldRedirect(false);
            return;
        }
        String paramIsPopup = request.getParameter("isPopup");
        if (paramIsPopup != null) {
            servletInfo.setDestPage("/hosts/hostSearchPopup.jsp");
            servletInfo.setShouldRedirect(false);
        } else {
            servletInfo.setDestPage("/HostSearches");
            servletInfo.setShouldRedirect(true);
        }
    }

    protected void handleNotConfirmed(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        hsb.refreshCurrentHostNames();
        servletInfo.setDestPage(this.getDetailsPage(request));
        servletInfo.setShouldRedirect(false);
    }

    protected void handleSaveAs(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        HostSearchesBean hsb = (HostSearchesBean)servletInfo.getBean();
        hsb.loadAllAttributes();
        this.readFromRequest(request, hsb);
        hsb.refreshCurrentHostNames();
        hsb.setMode("saveas");
        servletInfo.setDestPage(this.getConfirmPage(request));
        servletInfo.setShouldRedirect(false);
    }

    private void readFromRequest(HttpServletRequest request, HostSearchesBean hsb) throws RaplixException {
        hsb.setID(HostSearchesHandleAction.assertGetParam(request, "id"));
        hsb.setName(HostSearchesHandleAction.assertGetParam(request, "name"));
        hsb.setDescription(HostSearchesHandleAction.assertGetParam(request, "description"));
        hsb.setPluginID(request.getParameter("pluginID"));
        hsb.setPluginName(request.getParameter("pluginName"));
        hsb.setWriteOnPlugin(request.getParameter("writeOnPlugin") != null);
        hsb.setHasWriteOnHostSearches(request.getParameter("hasWriteOnHostSearches") != null);
        hsb.setUpdateCount(Integer.parseInt(HostSearchesHandleAction.assertGetParam(request, "updateCount")));
        hsb.setIsHidden(request.getParameter("isHidden") != null);
        hsb.setIsNew(HostSearchesHandleAction.assertGetParam(request, "isNew").equals("true"));
        hsb.setContainsMasterServer(request.getParameter("containsMasterServer") != null);
        hsb.setContainsLocalDistributor(request.getParameter("containsLocalDistributor") != null);
        hsb.setContainsRemoteAgent(request.getParameter("containsRemoteAgent") != null);
        hsb.setIsPhysical(request.getParameter("isPhysical") != null);
        hsb.setIsVirtual(request.getParameter("isVirtual") != null);
        hsb.setNewAttribute(request.getParameter("newAttribute"));
        hsb.setNewComparison(request.getParameter("newComparison"));
        hsb.setNewValue(request.getParameter("newValue"));
        hsb.clearCurrent();
        int i = 0;
        while (true) {
            String currAttr;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Trying to persist current query#" + i, this);
            }
            if ((currAttr = request.getParameter("currentAttributes" + i)) == null) break;
            String currComparison = HostSearchesHandleAction.assertGetParam(request, "currentComparisons" + i);
            String currVal = HostSearchesHandleAction.assertGetParam(request, "currentValues" + i);
            hsb.addCurrentAttribute(currAttr);
            hsb.addCurrentComparison(currComparison);
            hsb.addCurrentValue(currVal);
            ++i;
        }
        this.readQueryArgsFromRequest(request, hsb);
    }

    private void readQueryArgsFromRequest(HttpServletRequest request, HostSearchesBean hsb) throws RaplixException {
        String paramLimitHostSetID;
        String paramLimitPlanName;
        String paramLimitIsSubplan;
        String paramWhich;
        hsb.setIsPopup(request.getParameter("isPopup"));
        String paramSingle = request.getParameter("isSingle");
        if (paramSingle != null) {
            hsb.setIsSingle(paramSingle);
        }
        if ((paramWhich = request.getParameter("which")) != null) {
            hsb.setWhich(paramWhich);
        }
        if ((paramLimitIsSubplan = request.getParameter("limitIsSubplan")) != null) {
            hsb.setLimitIsSubplan(paramLimitIsSubplan.equals("true"));
        }
        if ((paramLimitPlanName = request.getParameter("limitPlanName")) != null) {
            hsb.setLimitPlanName(paramLimitPlanName);
        }
        if ((paramLimitHostSetID = request.getParameter("limitHostSetID")) != null) {
            hsb.setLimitHostSetID(paramLimitHostSetID);
        }
    }

    private String getDetailsPage(HttpServletRequest request) {
        String paramIsPopup = request.getParameter("isPopup");
        if (paramIsPopup != null) {
            return "/hosts/hostSearchPopup.jsp";
        }
        return "/hosts/hostSearchDetails.jsp";
    }

    private String getConfirmPage(HttpServletRequest request) {
        String paramIsPopup = request.getParameter("isPopup");
        if (paramIsPopup != null) {
            return "/hosts/hostSearchPopupConfirm.jsp";
        }
        return "/hosts/hostSearchConfirm.jsp";
    }
}

