/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class HostSearchesDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;

    public HostSearchesDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
    }

    public int getDeleteConfirmColspan() {
        return 2;
    }

    public String getDeleteContext() {
        return "hostSearchesDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        HostSearchID hostSearchID = (HostSearchID)candidate.getParent().getObjectID();
        return hostSearchID.getByIDQuery().selectSummaryView();
    }

    public void preRender() throws RaplixException {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String editURI = UriUtil.hostSearchEditURI(this.mObjectID.toString());
        String toolTip = "Show host search details";
        String nameLink = Util.standardLink(editURI, toolTip, this.mName, "name=\"nameLink-" + this.mObjectID + "\"");
        String descLink = Util.standardLink(editURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

