/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppTypeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AttributeCriteriaList;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ComparisonType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearch;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostTypeQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsBean;
import com.raplix.util.logger.Logger;
import com.raplix.util.regex.GlobPattern;
import java.util.Vector;

public class HostSearchesBean
extends ServletBean {
    public static final String COMPARISON_EQUALS = "Equals";
    public static final String COMPARISON_CONTAINS = "Contains";
    private static final int numRoxhostAttributes = 8;
    private HostSearch mHostSearch = null;
    private String[] mPossibleAttributes = new String[0];
    private final String[] mRoxhostAttributeVariables = new String[8];
    private String mDefaultAttributeName = "";
    private Vector mCurrentAttributes = new Vector();
    private Vector mCurrentComparisons = new Vector();
    private Vector mCurrentComparisonVals = new Vector();
    private Vector mCurrentValues = new Vector();
    private String mNewAttribute = "";
    private String mNewComparison = "Equals";
    private String mNewValue = "";
    private String[] mCurrentHostNames = new String[0];
    private int mRemoteAgentCount = 0;
    private int mLocalDistributorCount = 0;
    private int mPhysicalCount = 0;
    private int mVirtualCount = 0;
    private String mMode = "";
    private boolean mIsHidden = false;
    private boolean mIsNew = false;
    private boolean mContainsMasterServer = false;
    private boolean mContainsLocalDistributor = false;
    private boolean mContainsRemoteAgent = false;
    private boolean mIsPhysical = true;
    private boolean mIsVirtual = true;
    private String mIsPopup = null;
    private String mWhich = "";
    private String mIsSingle = "false";
    private String mName = "";
    private String mDescription = "";
    private String mPluginName = null;
    private String mPluginID = null;
    private boolean mWriteOnPlugin = true;
    private boolean mHasWriteOnHostSearches = true;
    private int mUpdateCount = 0;
    private boolean mLimitIsSubplan = false;
    private String mLimitPlanName = "";
    private String mLimitHostSetID = "";
    private String mLimitHostSetName = "";

    public HostSearch getHostSearch() {
        return this.mHostSearch;
    }

    public String[] getNothing() {
        return new String[0];
    }

    public String[] getPossibleAttributes() {
        return this.mPossibleAttributes;
    }

    public String[] getRoxhostAttributeVariables() {
        return this.mRoxhostAttributeVariables;
    }

    public String[] getCurrentAttributes() {
        return this.mCurrentAttributes.toArray(new String[0]);
    }

    public String[] getCurrentComparisons() {
        return this.mCurrentComparisons.toArray(new String[0]);
    }

    public String[] getCurrentValues() {
        return this.mCurrentValues.toArray(new String[0]);
    }

    public String getNewAttribute() {
        return this.mNewAttribute;
    }

    public String getNewComparison() {
        return this.mNewComparison;
    }

    public String getNewValue() {
        return this.mNewValue;
    }

    public String[] getCurrentHostNames() {
        return this.mCurrentHostNames;
    }

    public int getRemoteAgentCount() {
        return this.mRemoteAgentCount;
    }

    public int getLocalDistributorCount() {
        return this.mLocalDistributorCount;
    }

    public int getPhysicalCount() {
        return this.mPhysicalCount;
    }

    public int getVirtualCount() {
        return this.mVirtualCount;
    }

    public boolean getContainsMasterServer() {
        return this.mContainsMasterServer;
    }

    public boolean getContainsLocalDistributor() {
        return this.mContainsLocalDistributor;
    }

    public boolean getContainsRemoteAgent() {
        return this.mContainsRemoteAgent;
    }

    public boolean getIsPhysical() {
        return this.mIsPhysical;
    }

    public boolean getIsVirtual() {
        return this.mIsVirtual;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public boolean getHasWriteOnHostSearches() {
        return this.mHasWriteOnHostSearches;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsHidden() {
        return this.mIsHidden;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public String getIsPopup() {
        return this.mIsPopup;
    }

    public String getIsSingle() {
        return this.mIsSingle;
    }

    public String getWhich() {
        return this.mWhich;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public boolean getLimitIsSubplan() {
        return this.mLimitIsSubplan;
    }

    public String getLimitPlanName() {
        return this.mLimitPlanName;
    }

    public String getLimitHostSetID() {
        return this.mLimitHostSetID;
    }

    public String getLimitHostSetName() {
        return this.mLimitHostSetName;
    }

    public String[] getCurrentAttributeLabels() {
        String[] attrNames = this.mCurrentAttributes.toArray(new String[0]);
        return attrNames;
    }

    public void setHostSearch(HostSearch inHostSearch) {
        this.mHostSearch = inHostSearch;
    }

    public void setContainsMasterServer(boolean inContainsMasterServer) {
        this.mContainsMasterServer = inContainsMasterServer;
    }

    public void setContainsLocalDistributor(boolean inContainsLocalDistributor) {
        this.mContainsLocalDistributor = inContainsLocalDistributor;
    }

    public void setContainsRemoteAgent(boolean inContainsRemoteAgent) {
        this.mContainsRemoteAgent = inContainsRemoteAgent;
    }

    public void setIsPhysical(boolean in) {
        this.mIsPhysical = in;
    }

    public void setIsVirtual(boolean in) {
        this.mIsVirtual = in;
    }

    public void setMode(String inMode) {
        this.mMode = inMode;
    }

    public void setName(String inName) {
        this.mName = inName;
    }

    public void setDescription(String inDescription) {
        this.mDescription = inDescription;
    }

    public void setPluginID(String id) {
        this.mPluginID = id;
    }

    public void setPluginName(String name) {
        this.mPluginName = name;
    }

    public void setWriteOnPlugin(boolean write) {
        this.mWriteOnPlugin = write;
    }

    public void setHasWriteOnHostSearches(boolean write) {
        this.mHasWriteOnHostSearches = write;
    }

    public void setNewAttribute(String inNewAttribute) {
        this.mNewAttribute = inNewAttribute;
    }

    public void setNewComparison(String inNewComparison) {
        this.mNewComparison = inNewComparison;
    }

    public void setNewValue(String inNewValue) {
        this.mNewValue = inNewValue;
    }

    public void setID(String id) {
        this.mObjectID = new HostSearchID(id);
    }

    public void setIsHidden(boolean inIsHidden) {
        this.mIsHidden = inIsHidden;
    }

    public void setIsNew(boolean inIsNew) {
        this.mIsNew = inIsNew;
    }

    public void setIsPopup(String inIsPopup) {
        this.mIsPopup = inIsPopup;
    }

    public void setIsSingle(String inIsSingle) {
        this.mIsSingle = inIsSingle;
    }

    public void setWhich(String inWhich) {
        this.mWhich = inWhich;
    }

    public void setUpdateCount(int inUpdateCount) {
        this.mUpdateCount = inUpdateCount;
    }

    public void setLimitIsSubplan(boolean in) {
        this.mLimitIsSubplan = in;
    }

    public void setLimitPlanName(String in) {
        this.mLimitPlanName = in;
    }

    public void setLimitHostSetID(String in) throws RaplixException {
        this.mLimitHostSetID = in;
        try {
            this.mLimitHostSetName = HostSetsBean.getSummaryHostSetByID(in).getName();
        }
        catch (RaplixException raplixException) {
            // empty catch block
        }
    }

    public void loadAllAttributes() throws RaplixException {
        this.initializeAttributeConstants();
        MultiHostTypeQuery mhtq = MultiHostTypeQuery.all();
        this.mPossibleAttributes = mhtq.selectVarNames();
    }

    public void clearCurrent() {
        this.mCurrentAttributes.clear();
        this.mCurrentComparisons.clear();
        this.mCurrentComparisonVals.clear();
        this.mCurrentValues.clear();
    }

    public void addCurrentAttribute(String inAttribute) {
        this.mCurrentAttributes.add(inAttribute);
    }

    public void addCurrentComparison(String inComp) {
        this.mCurrentComparisons.add(inComp);
        if (inComp.equals(COMPARISON_EQUALS)) {
            this.mCurrentComparisonVals.add(ComparisonType.EQUALS);
        } else {
            this.mCurrentComparisonVals.add(ComparisonType.CONTAINS);
        }
    }

    public void addCurrentComparison(ComparisonType inComp) {
        this.mCurrentComparisonVals.add(inComp);
        if (inComp == ComparisonType.EQUALS) {
            this.mCurrentComparisons.add(COMPARISON_EQUALS);
        } else {
            this.mCurrentComparisons.add(COMPARISON_CONTAINS);
        }
    }

    public void addCurrentValue(String inVal) {
        this.mCurrentValues.add(inVal);
    }

    public void refreshCurrentHostNames() throws RaplixException {
        HostSearchCriteria hsc = this.generateCriteria();
        MultiHostQuery mhq = hsc.getAllHostsQuery();
        if (this.mIsPopup != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("mIsPopup is set to " + this.mIsPopup + ", enabling visibility filter", this);
            }
            mhq.setVisibilityFilter(Visibility.VISIBLE);
        }
        if (this.mLimitHostSetID != null && this.mLimitHostSetID.length() > 0) {
            mhq.setHostSetFilter(new HostSetID(this.mLimitHostSetID));
        }
        Host[] hosts = mhq.select();
        this.mRemoteAgentCount = 0;
        this.mLocalDistributorCount = 0;
        this.mVirtualCount = 0;
        this.mPhysicalCount = 0;
        Vector<String> hostNames = new Vector<String>();
        for (int i = 0; i < hosts.length; ++i) {
            Host host = hosts[i];
            hostNames.add(host.getName());
            if (host.getAppRA() != null) {
                ++this.mRemoteAgentCount;
            }
            if (host.getAppLD() != null) {
                ++this.mLocalDistributorCount;
            }
            if (hosts[i].isVirtual()) {
                ++this.mVirtualCount;
                continue;
            }
            ++this.mPhysicalCount;
        }
        this.mCurrentHostNames = hostNames.toArray(new String[0]);
    }

    public void loadHostSearch(String inSearchID) throws RaplixException {
        this.mObjectID = new HostSearchID(inSearchID);
        this.mHostSearch = ((HostSearchID)this.mObjectID).getByIDQuery().select();
        this.mName = this.mHostSearch.getName();
        this.mDescription = this.mHostSearch.getDescription();
        PluginID pluginID = this.mHostSearch.getPluginID();
        if (pluginID != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.loadPermissionLookaheads();
        this.mIsHidden = this.mHostSearch.getVisibility().equals(Visibility.HIDDEN);
        this.mUpdateCount = this.mHostSearch.getUpdateCount();
        HostSearchCriteria hsc = this.mHostSearch.getCriteria();
        AttributeCriteriaList atl = hsc.getAttributeCriteriaList();
        this.clearCurrent();
        for (int i = 0; i < atl.size(); ++i) {
            AttributeCriteria ac = atl.getCriteria(i);
            this.addCurrentAttribute(ac.getAttributeName());
            this.addCurrentComparison(ac.getComparisonType());
            this.addCurrentValue(ac.getValuePattern().toString());
        }
        AppTypeCriteria atc = hsc.getAppTypeCriteria();
        this.mContainsMasterServer = atc.getIncludeMS();
        this.mContainsLocalDistributor = atc.getIncludeLD();
        this.mContainsRemoteAgent = atc.getIncludeRA();
        PhysicalCriteria pc = hsc.getPhysicalCriteria();
        this.mIsPhysical = pc.getIncludePhysical();
        this.mIsVirtual = pc.getIncludeVirtual();
    }

    public boolean addNewQuery() {
        GlobPattern globPattern = GlobPattern.create(this.mNewValue);
        if (globPattern == null) {
            return false;
        }
        this.addCurrentAttribute(this.mNewAttribute);
        this.addCurrentComparison(this.mNewComparison);
        this.addCurrentValue(this.mNewValue);
        this.mNewAttribute = this.mDefaultAttributeName;
        this.mNewComparison = COMPARISON_EQUALS;
        this.mNewValue = "";
        return true;
    }

    public void removeQuery(int index) {
        this.mCurrentAttributes.remove(index);
        this.mCurrentComparisons.remove(index);
        this.mCurrentComparisonVals.remove(index);
        this.mCurrentValues.remove(index);
    }

    public void persist() throws RaplixException {
        if (this.mHostSearch == null) {
            this.mHostSearch = new HostSearch();
        }
        this.mHostSearch.setSimpleName(this.mName);
        this.mHostSearch.setDescription(this.mDescription);
        this.mHostSearch.setVisibility(this.mIsHidden ? Visibility.HIDDEN : Visibility.VISIBLE);
        this.mHostSearch.setUpdateCount(this.mUpdateCount);
        this.mHostSearch.setCriteria(this.generateCriteria());
        this.mHostSearch.save();
    }

    public void createHostSearch(String name, String desc) throws RaplixException {
        this.mName = name;
        this.mDescription = desc;
        this.mContainsMasterServer = false;
        this.mContainsLocalDistributor = false;
        this.mContainsRemoteAgent = false;
        this.mIsPhysical = true;
        this.mIsVirtual = true;
    }

    private void initializeAttributeConstants() {
        this.mRoxhostAttributeVariables[0] = "sys.hostName";
        this.mRoxhostAttributeVariables[1] = "sys.description";
        this.mRoxhostAttributeVariables[2] = "sys.hostType";
        this.mRoxhostAttributeVariables[3] = "sys.ipAddress";
        this.mRoxhostAttributeVariables[4] = "sys.parent";
        this.mRoxhostAttributeVariables[5] = "sys.OS";
        this.mRoxhostAttributeVariables[6] = "sys.OSVersion";
        this.mRoxhostAttributeVariables[7] = "sys.OSArch";
        this.mNewAttribute = this.mDefaultAttributeName = this.mRoxhostAttributeVariables[0];
    }

    private HostSearchCriteria generateCriteria() throws RaplixException {
        HostSearchCriteria hsc = new HostSearchCriteria();
        AttributeCriteriaList acl = new AttributeCriteriaList();
        for (int i = 0; i < this.mCurrentComparisonVals.size(); ++i) {
            String name = (String)this.mCurrentAttributes.elementAt(i);
            ComparisonType comparisonType = (ComparisonType)this.mCurrentComparisonVals.elementAt(i);
            GlobPattern globPattern = GlobPattern.create((String)this.mCurrentValues.elementAt(i));
            if (globPattern == null) continue;
            acl.add(AttributeCriteria.create(name, comparisonType, globPattern));
        }
        hsc.setAttributeCriteriaList(acl);
        AppTypeCriteria atc = new AppTypeCriteria();
        atc.setIncludeMS(this.mContainsMasterServer);
        atc.setIncludeLD(this.mContainsLocalDistributor);
        atc.setIncludeRA(this.mContainsRemoteAgent);
        atc.setIncludeNone(false);
        hsc.setAppTypeCriteria(atc);
        PhysicalCriteria pc = new PhysicalCriteria();
        pc.setIncludePhysical(this.mIsPhysical);
        pc.setIncludeVirtual(this.mIsVirtual);
        hsc.setPhysicalCriteria(pc);
        return hsc;
    }

    void loadPermissionLookaheads() {
        if (this.mHostSearch != null) {
            this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(this.mHostSearch);
        }
        this.mHasWriteOnHostSearches = PermissionChecker.hasWriteOnHostSearches();
    }
}

