/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.ui.web.data.TaskStatusInfo;

public class HostHistoryBean {
    private String[] mActionTypes = new String[0];
    private String[] mPlanNames = new String[0];
    private String[] mPlanVersions = new String[0];
    private String[] mUserNames = new String[0];
    private String[] mCompleteds = new String[0];
    private String[] mStatuses = new String[0];
    private String[] mTaskIDs = new String[0];
    private boolean[] mIsRunning = new boolean[0];
    private NotificationRPCInterface mNotMgr = null;

    public HostHistoryBean(NotificationRPCInterface notMgr) {
        this.mNotMgr = notMgr;
    }

    public String[] getActionTypes() {
        return this.mActionTypes;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getPlanVersions() {
        return this.mPlanVersions;
    }

    public String[] getUserNames() {
        return this.mUserNames;
    }

    public String[] getCompleteds() {
        return this.mCompleteds;
    }

    public String[] getStatuses() {
        return this.mStatuses;
    }

    public String[] getTaskIDs() {
        return this.mTaskIDs;
    }

    public boolean[] getIsRunning() {
        return this.mIsRunning;
    }

    public boolean[] getNeedsAttentions() {
        return this.mIsRunning;
    }

    public void loadHostHistory(String hostID) throws RPCException, NotificationManagerException {
        com.raplix.rolloutexpress.event.query.bean.HostHistoryBean[] hostTasks = this.mNotMgr.queryHostHistory(new HostID(hostID)).toArray(new com.raplix.rolloutexpress.event.query.bean.HostHistoryBean[0]);
        int len = hostTasks.length;
        this.mActionTypes = new String[len];
        this.mPlanNames = new String[len];
        this.mPlanVersions = new String[len];
        this.mUserNames = new String[len];
        this.mCompleteds = new String[len];
        this.mStatuses = new String[len];
        this.mTaskIDs = new String[len];
        this.mIsRunning = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.mActionTypes[i] = hostTasks[i].getIsPreflight() ? "preflight" : "plan";
            this.mPlanNames[i] = hostTasks[i].getExecutionPlan().getFullName();
            this.mPlanVersions[i] = hostTasks[i].getExecutionPlan().getVersionNumber().getAsString();
            this.mUserNames[i] = hostTasks[i].getUsername();
            this.mTaskIDs[i] = hostTasks[i].getTaskID().toString();
            TaskStatusInfo tsi = new TaskStatusInfo(hostTasks[i]);
            this.mCompleteds[i] = tsi.getCompletionString();
            this.mStatuses[i] = tsi.getShortStatus();
            this.mIsRunning[i] = tsi.isRunning();
        }
    }
}

