/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostsListBean;

public class HostDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 6;
    private String mAppInstances = "";
    private String mTypeNameOfHost = "";
    private String mHostOSName = "";
    private String mHostOSVersion = "";

    public HostDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
        Host host = (Host)this.getObject(candidate);
        this.mAppInstances = HostsListBean.createAppInstanceString(host);
        this.mTypeNameOfHost = host.getHostType().getName();
        MachineInfo mi = host.getMachineInfo();
        this.mHostOSName = mi == null ? "" : mi.getOSName();
        this.mHostOSVersion = mi == null ? "" : mi.getOSVersion();
        this.preRender();
    }

    public int getDeleteConfirmColspan() {
        return 6;
    }

    public String getDeleteContext() {
        return "hostDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        HostID hostID = (HostID)candidate.getParent().getObjectID();
        return hostID.getByIDQuery().select();
    }

    public void preRender() {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.hostDetailsURI(this.mObjectID.toString());
        String toolTip = "Show host details";
        String nameLink = Util.standardLink(viewURI, toolTip, this.mName, "name=\"nameLink-" + this.mObjectID + "\"");
        String appsLink = Util.standardLink(viewURI, toolTip, this.mAppInstances);
        String typeLink = Util.standardLink(viewURI, toolTip, this.mTypeNameOfHost);
        String osLink = Util.standardLink(viewURI, toolTip, this.mHostOSName);
        String verLink = Util.standardLink(viewURI, toolTip, this.mHostOSVersion);
        String descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(appsLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(typeLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(osLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(verLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

