/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.hosts;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.event.NotificationRPCInterface;
import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentOrder;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.rolloutexpress.ui.web.hosts.HostsBean;

public class HostComponentsBean
extends ServletListBean {
    private String mName = "";
    private String mDescription = "";
    private String mHostID = "";
    private String[] mChildrenNames = new String[0];
    private String[] mChildrenIDs = new String[0];
    private String mParentName = "";
    private String mParentID = "";
    private String mTypeName = "";
    private String mHostPhysicality = "physical";
    private String[] mComponentNames = new String[0];
    private String[] mComponentTypes = new String[0];
    private String[] mComponentVersions = new String[0];
    private String[] mInstallPaths = new String[0];
    private String[] mVariableSettingsNames = new String[0];
    private String[] mVariableSettingsIDs = new String[0];
    private String[] mPlanNames = new String[0];
    private String[] mPlanVersions = new String[0];
    private String[] mUserNames = new String[0];
    private String[] mInstallDates = new String[0];
    private String[] mTaskIDs = new String[0];
    private String[] mComponentIDs = new String[0];
    private String[] mInstalledComponentIDs = new String[0];
    private String[] mPlanIDs = new String[0];
    private boolean[] mIsSentinelTaskIDs = new boolean[0];
    private boolean[] mIsSentinelUserIDs = new boolean[0];
    private NotificationRPCInterface mNotMgr = null;

    public HostComponentsBean(NotificationRPCInterface notMgr) {
        this.mNotMgr = notMgr;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getTypeName() {
        return this.mTypeName;
    }

    public String getHostPhysicality() {
        return this.mHostPhysicality;
    }

    public String getID() {
        return this.mHostID;
    }

    public String[] getChildrenNames() {
        return this.mChildrenNames;
    }

    public String[] getChildrenIDs() {
        return this.mChildrenIDs;
    }

    public String getParentName() {
        return this.mParentName;
    }

    public String getParentID() {
        return this.mParentID;
    }

    public String[] getComponentNames() {
        return this.mComponentNames;
    }

    public String[] getComponentTypes() {
        return this.mComponentTypes;
    }

    public String[] getComponentVersions() {
        return this.mComponentVersions;
    }

    public String[] getInstallPaths() {
        return this.mInstallPaths;
    }

    public String[] getVariableSettingsNames() {
        return this.mVariableSettingsNames;
    }

    public String[] getVariableSettingsIDs() {
        return this.mVariableSettingsIDs;
    }

    public String[] getPlanNames() {
        return this.mPlanNames;
    }

    public String[] getPlanVersions() {
        return this.mPlanVersions;
    }

    public String[] getUserNames() {
        return this.mUserNames;
    }

    public String[] getInstallDates() {
        return this.mInstallDates;
    }

    public String[] getTaskIDs() {
        return this.mTaskIDs;
    }

    public String[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String[] getInstalledComponentIDs() {
        return this.mInstalledComponentIDs;
    }

    public String[] getPlanIDs() {
        return this.mPlanIDs;
    }

    public boolean[] getIsSentinelTaskIDs() {
        return this.mIsSentinelTaskIDs;
    }

    public boolean[] getIsSentinelUserIDs() {
        return this.mIsSentinelUserIDs;
    }

    public void setHostID(String in) {
        this.mHostID = in;
    }

    public void loadHostInfo() throws RaplixException {
        SummaryHost host = HostsBean.getSummaryHostByID(this.mHostID);
        this.mName = host.getName();
        this.mDescription = host.getDescription();
        this.mTypeName = host.getHostTypeID().getByIDQuery().selectSummaryView().getName();
        String string = this.mHostPhysicality = host.isVirtual() ? "virtual" : "physical";
        if (host.getParentHostID() != null) {
            this.mParentID = host.getParentHostID().toString();
            this.mParentName = host.getParentHostID().getByIDQuery().selectSummaryView().getName();
        } else {
            this.mParentID = "";
            this.mParentName = "";
        }
        SummaryHost[] children = host.getID().getVirtualChildHostsQuery().selectSummaryView();
        this.mChildrenNames = new String[children.length];
        this.mChildrenIDs = new String[children.length];
        for (int i = 0; i < children.length; ++i) {
            this.mChildrenNames[i] = children[i].getName();
            this.mChildrenIDs[i] = children[i].getID().toString();
        }
    }

    public void generateList() throws RaplixException {
        MultiInstalledComponentQuery query = MultiInstalledComponentQuery.byHost(new HostID(this.mHostID), TargetType.CURRENT);
        query.setCategoryFilter(this.getCategoryFilter());
        this.prepQuery(query, InstalledComponentOrder.BY_DATE_DESC);
        this.generateOutputArrays(query.select());
    }

    private void generateOutputArrays(InstalledComponentBean[] components) throws RaplixException {
        int len = components.length;
        this.mComponentNames = new String[len];
        this.mComponentTypes = new String[len];
        this.mComponentVersions = new String[len];
        this.mInstallPaths = new String[len];
        this.mVariableSettingsNames = new String[len];
        this.mVariableSettingsIDs = new String[len];
        this.mPlanNames = new String[len];
        this.mPlanVersions = new String[len];
        this.mUserNames = new String[len];
        this.mInstallDates = new String[len];
        this.mTaskIDs = new String[len];
        this.mComponentIDs = new String[len];
        this.mInstalledComponentIDs = new String[len];
        this.mPlanIDs = new String[len];
        this.mIsSentinelTaskIDs = new boolean[len];
        this.mIsSentinelUserIDs = new boolean[len];
        for (int i = 0; i < len; ++i) {
            this.mComponentNames[i] = components[i].getComponent().getFullName();
            this.mComponentTypes[i] = ComponentTypesListBean.normalizeName(components[i].getComponent().getExtendsTypeName());
            this.mComponentVersions[i] = components[i].getComponent().getVersionNumber().getAsString();
            this.mInstallPaths[i] = components[i].getComponentRAInstallPath();
            this.mVariableSettingsNames[i] = components[i].getGeneratedVariableSettings().getName();
            this.mVariableSettingsIDs[i] = components[i].getGeneratedVariableSettingsID().toString();
            this.mPlanNames[i] = components[i].getExecutionPlan().getFullName();
            this.mPlanVersions[i] = components[i].getExecutionPlan().getVersionNumber().getAsString();
            this.mUserNames[i] = components[i].getUsername();
            this.mInstallDates[i] = Util.formatDate(components[i].getDate());
            this.mTaskIDs[i] = components[i].getTaskID().toString();
            this.mComponentIDs[i] = components[i].getComponentID().toString();
            this.mInstalledComponentIDs[i] = components[i].getInstalledComponentID().toString();
            this.mPlanIDs[i] = components[i].getExecutionPlanID().toString();
            this.mIsSentinelTaskIDs[i] = TaskID.TASK_SENTINEL_ID.equals(components[i].getTaskID());
            this.mIsSentinelUserIDs[i] = UserID.USER_SENTINEL_ID.equals(components[i].getUserID());
        }
    }
}

