/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.folders;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderIDSet;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderOrder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.MultiFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.folders.FoldersBean;
import com.raplix.util.regex.GlobPattern;
import java.util.Arrays;

public class FoldersListBean
extends ServletListBean {
    private static final String MSG_LABEL_UNIVERSALSET = "label.universalhostset";
    private static final FolderOrder DEFAULT_SORT_ORDER = FolderOrder.BY_NAME_ASC;
    private String[] mFolderIDs = new String[0];
    private String[] mParentFolderNames = new String[0];
    private String[] mFolderNames = new String[0];
    private String[] mFolderDescriptions = new String[0];
    private String[] mOwnerUserGroups = new String[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String[] mGroupIDs = new String[0];
    private String[] mGroupNames = new String[0];
    private boolean mWriteOnFolderDisplay = false;
    private boolean mAutoRunOnFolderDisplay = false;
    private boolean mCheckInCurrentOnFolderDisplay = false;
    private String mExecuteHostSetsOnFolder = "";
    private String mDeleteHistoryHostSetsOnFolder = "";
    private boolean mWriteOnFolder = false;
    private String mFindParentName = "";
    private String mFindOwnerUserGroup = "";
    private String mMode = "";
    private String[] mPathFolderNames = new String[0];
    private String[] mPathFolderIDs = new String[0];
    private boolean mWriteOnPlugin = true;

    public String[] getFolderIDs() {
        return this.mFolderIDs;
    }

    public String[] getParentFolderNames() {
        return this.mParentFolderNames;
    }

    public String[] getFolderNames() {
        return this.mFolderNames;
    }

    public String[] getFolderDescriptions() {
        return this.mFolderDescriptions;
    }

    public String[] getOwnerUserGroups() {
        return this.mOwnerUserGroups;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String[] getGroupIDs() {
        return this.mGroupIDs;
    }

    public String[] getGroupNames() {
        return this.mGroupNames;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public boolean getWriteOnFolderDisplay() {
        return this.mWriteOnFolderDisplay;
    }

    public boolean getAutoRunOnFolderDisplay() {
        return this.mAutoRunOnFolderDisplay;
    }

    public boolean getCheckInCurrentOnFolderDisplay() {
        return this.mCheckInCurrentOnFolderDisplay;
    }

    public String getExecuteHostSetsOnFolder() {
        return this.mExecuteHostSetsOnFolder;
    }

    public String getDeleteHistoryHostSetsOnFolder() {
        return this.mDeleteHistoryHostSetsOnFolder;
    }

    public String getFindParentName() {
        return this.mFindParentName;
    }

    public String getFindOwnerUserGroup() {
        return this.mFindOwnerUserGroup;
    }

    public void setFindParentName(String name) {
        this.mFindParentName = name;
    }

    public void setFindOwnerUserGroup(String group) {
        this.mFindOwnerUserGroup = group;
    }

    public String getMode() {
        return this.mMode;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public String[] getPathFolderNames() {
        return this.mPathFolderNames;
    }

    public String[] getPathFolderIDs() {
        return this.mPathFolderIDs;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public void generateList() throws RaplixException {
        MultiFolderQuery query = MultiFolderQuery.all();
        this.prepQuery(query, this.getSortOrderByName(this.getSortName()));
        this.generatePermissions();
        this.generateOutputArrays(query.selectSummaryView());
        this.loadBreadCrumbArrays();
    }

    private void generateOutputArrays(SummaryFolder[] folders) throws RaplixException {
        int numFolders = folders.length;
        this.mFolderIDs = new String[numFolders];
        this.mParentFolderNames = new String[numFolders];
        this.mFolderNames = new String[numFolders];
        this.mFolderDescriptions = new String[numFolders];
        this.mOwnerUserGroups = new String[numFolders];
        for (int i = 0; i < numFolders; ++i) {
            SummaryFolder folder = folders[i];
            SummaryFolder parent = folder.getParentFolderID().getByIDQuery().selectSummaryView();
            this.mFolderIDs[i] = folder.getID().toString();
            this.mParentFolderNames[i] = FoldersListBean.generateFlatViewPath(parent.getFullPathString(), this.getFilePathFilter());
            this.mFolderNames[i] = folder.getName();
            this.mFolderDescriptions[i] = folder.getDescription();
            this.mOwnerUserGroups[i] = UserGroupsBean.getGroupName(folder.getGroupID());
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mFolderIDs);
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(new FolderID(this.getFilePathFilter()).getByIDQuery().selectSummaryView());
    }

    public static String generateFlatViewPath(String parentPath, String currentPathID) throws RaplixException {
        String currentFolderPath = FoldersBean.resolveIDToPath(currentPathID);
        if (parentPath.indexOf(currentFolderPath) == 0) {
            return parentPath.substring(currentFolderPath.length());
        }
        return parentPath;
    }

    private void generatePermissions() throws RaplixException {
        HostSetIDSet hostsetIDs;
        FolderID id = new FolderID(this.getFilePathFilter());
        UserFolderPermissions ufp = id.getUserPermissions();
        this.mWriteOnFolderDisplay = ufp.isWrite();
        this.mAutoRunOnFolderDisplay = ufp.isAutorun();
        this.mCheckInCurrentOnFolderDisplay = ufp.isCheckin();
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(id);
        if (ufp.isExecuteAllHosts()) {
            this.mExecuteHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getExecuteHostSets();
            this.mExecuteHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
        if (ufp.isDeleteHistoryAllHosts()) {
            this.mDeleteHistoryHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getDeleteHistoryHostSets();
            this.mDeleteHistoryHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
    }

    public void loadUserGroupArrays() throws RaplixException {
        this.mGroupIDs = UserGroupsBean.getUserGroupIDs();
        this.mGroupNames = UserGroupsBean.getUserGroupNames();
    }

    private void loadBreadCrumbArrays() throws RaplixException {
        FolderID folderID = new FolderID(this.getFilePathFilter());
        this.mPathFolderNames = ChangePathBean.getFolderPathNames(folderID);
        this.mPathFolderIDs = ChangePathBean.getFolderPathIDs(folderID);
    }

    public void move(String[] ids, String newParentID) throws RaplixException {
        FolderID[] folderIDs = new FolderID[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            folderIDs[i] = new FolderID(ids[i]);
        }
        FolderIDSet idSet = new FolderIDSet(Arrays.asList(folderIDs));
        idSet.getByIDsQuery().move(new FolderID(newParentID), null);
    }

    protected void loadAdditionalFindFilters(MultiObjectQuery query) throws RaplixException {
        MultiFolderQuery mfq = (MultiFolderQuery)query;
        if (!this.mFindParentName.equals("")) {
            FullPathFilter pathFilter = mfq.getPathFilter();
            if (pathFilter == null) {
                pathFilter = new FullPathFilter();
            }
            pathFilter.setPathFilter(GlobPattern.create("*" + this.mFindParentName + "*"));
            mfq.setPathFilter(pathFilter);
        }
        if (!this.mFindOwnerUserGroup.equals("---")) {
            mfq.setGroupIDFilter(new GroupID(this.mFindOwnerUserGroup));
        }
    }

    protected void loadAdditionalFilters(MultiObjectQuery query) throws RaplixException {
        MultiFolderQuery mfq = (MultiFolderQuery)query;
        FolderID folderID = new FolderID(this.getFilePathFilter());
        boolean isRecursive = this.getFlatView();
        FullPathFilter pathFilter = mfq.getPathFilter();
        if (pathFilter == null) {
            pathFilter = new FullPathFilter();
        }
        pathFilter.setSearchRoot(folderID);
        pathFilter.setRecursiveMode(isRecursive);
        mfq.setPathFilter(pathFilter);
    }

    protected ObjectOrder getSortOrderByName(String sortName) {
        return this.getSortOrderByName(FolderOrder.FACTORY, sortName);
    }

    public ObjectOrder getDefaultSortOrder() {
        return DEFAULT_SORT_ORDER;
    }

    public boolean getCanBeHidden() {
        return false;
    }
}

