/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.folders;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.UIActionServlet;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.rolloutexpress.ui.web.folders.FoldersBean;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class FoldersHandleAction
extends UIActionServlet
implements ActionModeConstants {
    private static final String ROOT_FOLDER_ID = FolderID.ROOT_FOLDER_ID.toString();
    public static final String MSG_ERROR_DETAILS = "error.folders.details";
    public static final String MSG_ERROR_CREATE = "error.folders.create";
    public static final String MSG_ERROR_EDIT = "error.folders.edit";
    public static final String MSG_ERROR_SAVE = "error.folders.save.major";
    public static final String MSG_ERROR_CANCEL = "error.folders.cancel";
    public static final String MSG_ERROR_MOVE = "error.folders.move.major";
    public static final String MSG_ERROR_RENAME = "error.folders.rename.major";
    public static final String MSG_ERROR_PARENTFOLER_NONEXIST = "error.folders.parentfoldernotexist";
    public static final String MSG_ERROR_ADD_GROUP = "error.folders.addGroup.major";
    public static final String MSG_ERROR_REMOVE_GROUP = "error.folders.removeGroup.major";
    public static final String MSG_ERROR_BULK_REMOVE = "error.folders.bulkRemove";
    public static final String MSG_ERROR_NO_SELECTION = "error.folders.nogroupselection";
    public static final String MSG_ERROR_EMPTY_SELECTION = "error.folders.emptygroupselection";
    public static final String MSG_ERROR_GROUP_DUPLICATE = "error.folders.groupduplicated";
    public static final String MSG_ERROR_DELETE_MAJOR = "error.folders.deletegroup.major";
    final String YES_CONST = "yes";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = FoldersHandleAction.assertGetParam(request, "mode");
        servletInfo.setSaveInSession(false);
        if (mode.equals("create")) {
            this.handleCreate(request, servletInfo);
        } else if (mode.equals("details")) {
            this.handleDetails(request, servletInfo);
        } else if (mode.equals("edit")) {
            this.handleEdit(request, servletInfo);
        } else if (mode.equals("save")) {
            this.handleSave(request, servletInfo);
        } else if (mode.equals("cancel")) {
            this.handleCancel(request, servletInfo);
        } else if (mode.equals("rename")) {
            this.handleRename(request, servletInfo);
        } else if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else if (mode.equals("addgrouppermission")) {
            this.handleAddGroupPermisssion(request, servletInfo);
        } else if (mode.equals("deletegrouppermissions")) {
            this.handleDeleteGroupPermissions(request, servletInfo);
        } else {
            throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to FoldersHandleAction.");
        }
    }

    private void handleCreate(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentID = request.getParameter("filePath");
        String ownerGroupID = request.getParameter("ownerGroupID");
        bean.setMode("create");
        bean.createFolder(name, description, parentID, ownerGroupID);
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        servletInfo.setDestPage("/folders/folderEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleDetails(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        String id = FoldersHandleAction.assertGetParam(request, "id");
        bean.setMode("details");
        bean.loadFolder(id);
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/folders/folderDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleEdit(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        String id = FoldersHandleAction.assertGetParam(request, "id");
        bean.setMode("edit");
        bean.loadFolder(id);
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        servletInfo.setDestPage("/folders/folderEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleSave(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        this.readNewPermFromRequest(request, bean);
        this.readFromRequest(request, bean, "save");
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        if (!ROOT_FOLDER_ID.equals(bean.getID())) {
            try {
                bean.setFolderPath(bean.getParentFolderID());
            }
            catch (RaplixException re) {
                servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE);
                servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_PARENTFOLER_NONEXIST);
                bean.setMode("edit");
                bean.setEditDisable(true);
                servletInfo.setDestPage("/folders/folderEdit.jsp");
                servletInfo.setShouldRedirect(false);
                return;
            }
        }
        try {
            bean.saveFolder();
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE);
            if (re.nestedException() != null && re.nestedException() instanceof AccessControlException) {
                servletInfo.getErrors().addMinorError(this.ACExToString((AccessControlException)re.nestedException()));
                bean.setEditDisable(true);
            } else {
                servletInfo.getErrors().addMinorError(re.getMessage());
            }
            bean.setMode("edit");
            servletInfo.setDestPage("/folders/folderEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        catch (AccessControlException ace) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_SAVE);
            servletInfo.getErrors().addMinorError(this.ACExToString(ace));
            bean.setMode("edit");
            bean.setEditDisable(true);
            servletInfo.setDestPage("/folders/folderEdit.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        String detailPageUrl = UriUtil.folderDetailsURI(bean.getID());
        servletInfo.setDestPage(detailPageUrl);
        servletInfo.setShouldRedirect(true);
    }

    private void handleRename(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        String id = FoldersHandleAction.assertGetParam(request, "id");
        String newName = FoldersHandleAction.assertGetParam(request, "newName");
        bean.loadFolder(id);
        try {
            bean.renameFolder(newName);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_RENAME);
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/folders/folderDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadFolder(id);
        servletInfo.setDestPage("/folders/folderDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        String id = FoldersHandleAction.assertGetParam(request, "id");
        String newParentID = FoldersHandleAction.assertGetParam(request, "movePath");
        bean.loadFolder(id);
        try {
            bean.moveFolder(newParentID);
        }
        catch (RaplixException re) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE);
            servletInfo.getErrors().addMinorError(re.getMessage());
            servletInfo.setDestPage("/folders/folderDetails.jsp");
            servletInfo.setShouldRedirect(false);
            return;
        }
        bean.loadFolder(id);
        this.updateFilePath(request, servletInfo);
        servletInfo.setDestPage("/folders/folderDetails.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void handleCancel(HttpServletRequest request, ServletInfo servletInfo) {
        servletInfo.setDestPage("/Folders");
        servletInfo.setShouldRedirect(true);
    }

    private void handleAddGroupPermisssion(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        this.readNewPermFromRequest(request, bean);
        int gSize = 0;
        String listSize = request.getParameter("bulk_size");
        if (listSize != null) {
            gSize = Integer.parseInt(listSize);
        }
        String[] groupIDs = FoldersHandleAction.readParams(request, "groupID", gSize);
        if (!(bean.getNewWritePerm() || bean.getNewAutoRunPerm() || bean.getNewCheckInCurrentPerm() || bean.getNewHostSetID() != null || bean.getNewDeleteHistoryHostSetID() != null)) {
            bean.setMode("edit");
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ADD_GROUP);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_EMPTY_SELECTION);
            this.readFromRequest(request, bean, "save");
        } else if (this.groupExists(bean.getNewGroupID(), groupIDs)) {
            bean.setMode("edit");
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_ADD_GROUP);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_GROUP_DUPLICATE);
            this.readFromRequest(request, bean, "save");
        } else {
            this.readFromRequest(request, bean, "addgrouppermission");
            bean.clearNewPermission();
        }
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        servletInfo.setDestPage("/folders/folderEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private boolean groupExists(String newGroup, String[] groups) {
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].equals(newGroup)) continue;
            return true;
        }
        return false;
    }

    private void handleDeleteGroupPermissions(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersBean bean = (FoldersBean)servletInfo.getBean();
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            bean.setMode("edit");
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_REMOVE_GROUP);
            servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        }
        this.readFromRequest(request, bean, "deletegrouppermissions");
        bean.loadUserGroups(FoldersHandleAction.getApplication().getUserGroupManager());
        bean.loadHostSets();
        servletInfo.setDestPage("/folders/folderEdit.jsp");
        servletInfo.setShouldRedirect(false);
    }

    private void readNewPermFromRequest(HttpServletRequest request, FoldersBean bean) throws RaplixException {
        bean.setNewGroupID(request.getParameter("newGroupID"));
        bean.setNewWritePerm(request.getParameter("newWrite") != null);
        bean.setNewAutoRunPerm(request.getParameter("newAutoRun") != null);
        bean.setNewCheckInCurrentPerm(request.getParameter("newCheckInCurrent") != null);
        String newPermHostSetRun = request.getParameter("newExecute");
        String newPermHostSetID = request.getParameter("newHostSetID");
        bean.setNewHostSetID(newPermHostSetRun != null ? newPermHostSetID : null);
        String newDeleteHistory = request.getParameter("newDeleteHistoryHostSet");
        String newDeleteHistoryHostSetID = request.getParameter("newDeleteHistoryHostSetID");
        bean.setNewDeleteHistoryHostSetID(newDeleteHistory != null ? newDeleteHistoryHostSetID : null);
    }

    private void readFromRequest(HttpServletRequest request, FoldersBean bean, String mode) throws RaplixException {
        bean.setID(FoldersHandleAction.assertGetParam(request, "id"));
        bean.setName(FoldersHandleAction.assertGetParam(request, "name"));
        bean.setOwnerGroupID(FoldersHandleAction.assertGetParam(request, "ownerGroupID"));
        String folderDescription = request.getParameter("description");
        if (folderDescription != null) {
            bean.setDescription(folderDescription);
        }
        bean.setParentFolderID(FoldersHandleAction.assertGetParam(request, "parentFolderID"));
        bean.setIsNew("true".equals(FoldersHandleAction.assertGetParam(request, "isNew")));
        bean.updateOwnerGroupInfo();
        bean.setOwnerPermission("yes".equals(request.getParameter("userOwn")));
        bean.setWriteOnFolderDisplay("yes".equals(request.getParameter("userWrite")));
        bean.setAutoRunOnFolderDisplay("yes".equals(request.getParameter("userAutoRun")));
        bean.setCheckInCurrentOnFolderDisplay("yes".equals(request.getParameter("userCheckIn")));
        bean.setExecuteHostSetsOnFolder(request.getParameter("userHostSet"));
        bean.setDeleteHistoryHostSetsOnFolder(request.getParameter("deleteHistoryHostSet"));
        bean.setWriteOnFolder("yes".equals(request.getParameter("writeOnFolder")));
        bean.setWriteOnPlugin("yes".equals(request.getParameter("writeOnPlugin")));
        if (bean.getOwnerPermission()) {
            int vSize;
            Vector<String> groupIDVector = new Vector<String>();
            Vector<String> groupNameVector = new Vector<String>();
            Vector<String> groupPermWriteVector = new Vector<String>();
            Vector<String> groupPermAutoRunVector = new Vector<String>();
            Vector<String> groupPermCheckInVector = new Vector<String>();
            Vector<String> groupPermHostSetIDVector = new Vector<String>();
            Vector<String> deleteHistoryHostSetIDVector = new Vector<String>();
            String listSize = request.getParameter("bulk_size");
            if (listSize != null) {
                int gSize = Integer.parseInt(listSize);
                MultiCheckbox checkboxes = new MultiCheckbox("bulk", request);
                bean.setMultiCheckbox(checkboxes);
                for (int i = 0; i < gSize; ++i) {
                    String id = request.getParameter("groupID" + i);
                    String name = request.getParameter("groupName" + i);
                    String writeP = request.getParameter("groupWrite" + i);
                    String autoRunP = request.getParameter("groupAutoRun" + i);
                    String checkInP = request.getParameter("groupCheckIn" + i);
                    String hostRun = request.getParameter("groupHostSetRun" + i);
                    String hostSetID = request.getParameter("groupHostSetID" + i);
                    String checkVal = request.getParameter("bulk" + i);
                    if (hostRun == null) {
                        hostSetID = null;
                    }
                    String deleteHistory = request.getParameter("deleteHistoryHostSet" + i);
                    String deleteHistoryHostSetID = request.getParameter("deleteHistoryHostSetID" + i);
                    if (deleteHistory == null) {
                        deleteHistoryHostSetID = null;
                    }
                    if (mode.equals("deletegrouppermissions") && checkVal != null) continue;
                    groupIDVector.add(id);
                    groupNameVector.add(name);
                    groupPermWriteVector.add(writeP);
                    groupPermAutoRunVector.add(autoRunP);
                    groupPermCheckInVector.add(checkInP);
                    groupPermHostSetIDVector.add(hostSetID);
                    deleteHistoryHostSetIDVector.add(deleteHistoryHostSetID);
                }
            }
            if (mode.equals("addgrouppermission")) {
                String newGroupID = bean.getNewGroupID();
                String newGroupName = UserGroupsBean.getGroupName(new GroupID(newGroupID));
                String newPermWrite = bean.getNewWritePerm() ? "on" : null;
                String newPermAutoRun = bean.getNewAutoRunPerm() ? "on" : null;
                String newPermCheckIn = bean.getNewCheckInCurrentPerm() ? "on" : null;
                groupIDVector.add(newGroupID);
                groupNameVector.add(newGroupName);
                groupPermWriteVector.add(newPermWrite);
                groupPermAutoRunVector.add(newPermAutoRun);
                groupPermCheckInVector.add(newPermCheckIn);
                groupPermHostSetIDVector.add(bean.getNewHostSetID());
                deleteHistoryHostSetIDVector.add(bean.getNewDeleteHistoryHostSetID());
            }
            if ((vSize = groupIDVector.size()) > 0) {
                Object[] groupID = new String[vSize];
                Object[] groupName = new String[vSize];
                boolean[] writePermissions = new boolean[vSize];
                boolean[] autoRunPermissions = new boolean[vSize];
                boolean[] checkInPermissions = new boolean[vSize];
                Object[] groupPermHostSetID = new String[vSize];
                Object[] deleteHistoryPermHostSetID = new String[vSize];
                groupNameVector.copyInto(groupName);
                groupIDVector.copyInto(groupID);
                groupPermHostSetIDVector.copyInto(groupPermHostSetID);
                deleteHistoryHostSetIDVector.copyInto(deleteHistoryPermHostSetID);
                for (int i = 0; i < vSize; ++i) {
                    writePermissions[i] = groupPermWriteVector.elementAt(i) != null;
                    autoRunPermissions[i] = groupPermAutoRunVector.elementAt(i) != null;
                    checkInPermissions[i] = groupPermCheckInVector.elementAt(i) != null;
                }
                bean.setGroupNames((String[])groupName);
                bean.setGroupIDs((String[])groupID);
                bean.setWritePermissions(writePermissions);
                bean.setAutoRunPermissions(autoRunPermissions);
                bean.setCheckInCurrentPermissions(checkInPermissions);
                bean.setHostSetIDs((String[])groupPermHostSetID);
                bean.setDeleteHistoryHostSetIDs((String[])deleteHistoryPermHostSetID);
                bean.setMultiCheckbox(new MultiCheckbox("bulk", (String[])groupID));
            }
        }
        bean.setUpdateCount(Integer.parseInt(FoldersHandleAction.assertGetParam(request, "updateCount")));
    }

    private static String[] readParams(HttpServletRequest request, String paramName, int numFields) {
        Vector<String> paramValues = new Vector<String>();
        for (int i = 0; i < numFields; ++i) {
            String tmp = request.getParameter(paramName + i);
            paramValues.add(tmp);
        }
        Object[] params = new String[paramValues.size()];
        paramValues.copyInto(params);
        return params;
    }

    public String getDefaultPage() {
        return "/folders/folderDetails.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = FoldersHandleAction.assertGetParam(request, "mode");
        if (mode.equals("create")) {
            return MSG_ERROR_CREATE;
        }
        if (mode.equals("details")) {
            return MSG_ERROR_DETAILS;
        }
        if (mode.equals("edit")) {
            return MSG_ERROR_EDIT;
        }
        if (mode.equals("save")) {
            return MSG_ERROR_SAVE;
        }
        if (mode.equals("cancel")) {
            return MSG_ERROR_CANCEL;
        }
        if (mode.equals("rename")) {
            return MSG_ERROR_RENAME;
        }
        if (mode.equals("move")) {
            return MSG_ERROR_MOVE;
        }
        if (mode.equals("addgrouppermission")) {
            return MSG_ERROR_ADD_GROUP;
        }
        if (mode.equals("deletegrouppermissions")) {
            return MSG_ERROR_REMOVE_GROUP;
        }
        throw new IllegalArgumentException("Unknown mode (" + mode + ") passed to FoldersHandleAction.");
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new FoldersBean();
    }

    private void updateFilePath(HttpServletRequest request, ServletInfo servletInfo) {
        FoldersBean fb = (FoldersBean)servletInfo.getBean();
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        String filePath = ChangePathBean.verifyFolderID(fb.getParentFolderID());
        spb.setString(Preference.FILE_PATH, filePath);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("updateFilePath: path is now " + filePath, this);
        }
    }
}

