/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.folders;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.folderdb.Folder;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderDBException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSet;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderAccessData;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermissionItem;
import com.raplix.rolloutexpress.systemmodel.userdb.Group;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupID;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupManager;
import com.raplix.rolloutexpress.systemmodel.userdb.GroupOrder;
import com.raplix.rolloutexpress.systemmodel.userdb.MultiGroupQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserFolderPermissions;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.PermissionChecker;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.UserGroupsBean;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.hosts.HostSetsListBean;

public class FoldersBean
extends ServletBean {
    private static final String MSG_LABEL_UNIVERSALSET = "label.universalhostset";
    private static final String UNIVERSAL_SET_ID = "universal_set_id";
    public static final String ROOT_FOLDER_ID = FolderID.ROOT_FOLDER_ID.toString();
    private String mID = "";
    private String mName = "";
    private String mDescription = "";
    private String mOwnerUserGroup = "";
    private String mOwnerGroupID = "";
    private String mParentFolderID = "";
    private String mFolderPath = "";
    private boolean mWriteOnFolderDisplay = false;
    private boolean mAutoRunOnFolderDisplay = false;
    private boolean mCheckInCurrentOnFolderDisplay = false;
    private String mExecuteHostSetsOnFolder = "";
    private String mDeleteHistoryHostSetsOnFolder = "";
    private boolean mOwnerPermission = false;
    private boolean mWriteOnFolder = false;
    private boolean mWriteOnParentFolder = false;
    private boolean mWriteOnPlugin = false;
    private String mPluginName = null;
    private String mPluginID = null;
    private String[] mAllOwnerGroupNames = new String[0];
    private String[] mAllOwnerGroupIDs = new String[0];
    private String[] mAllPermissionGroupNames = new String[0];
    private String[] mAllPermissionGroupIDs = new String[0];
    private String[] mAllHostSetIDs = new String[0];
    private String[] mAllHostSetNames = new String[0];
    private String mNewGroupID = null;
    private boolean mNewWritePerm = false;
    private boolean mNewAutoRunPerm = false;
    private boolean mNewCheckInCurrentPerm = false;
    private String mNewHostSetID = null;
    private String mNewDeleteHistoryHostSetID = null;
    private String[] mGroupNames = new String[0];
    private String[] mGroupIDs = new String[0];
    private boolean[] mWritePermissions = new boolean[0];
    private boolean[] mAutoRunPermissions = new boolean[0];
    private boolean[] mCheckInCurrentPermissions = new boolean[0];
    private String[] mHostSetIDs = new String[0];
    private String[] mHostSetNames = new String[0];
    private String[] mDeleteHistoryHostSetIDs = new String[0];
    private String[] mDeleteHistoryHostSetNames = new String[0];
    private MultiCheckbox mMultiCheckbox = new MultiCheckbox("bulk", new String[0]);
    private String mMode = "";
    private boolean mIsNew = false;
    private int mUpdateCount = 0;
    private boolean mEditDisable = false;

    public String getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getOwnerUserGroup() {
        return this.mOwnerUserGroup;
    }

    public String getOwnerGroupID() {
        return this.mOwnerGroupID;
    }

    public String getParentFolderID() {
        return this.mParentFolderID;
    }

    public String getFolderPath() {
        return this.mFolderPath;
    }

    public boolean getWriteOnFolderDisplay() {
        return this.mWriteOnFolderDisplay;
    }

    public boolean getAutoRunOnFolderDisplay() {
        return this.mAutoRunOnFolderDisplay;
    }

    public boolean getCheckInCurrentOnFolderDisplay() {
        return this.mCheckInCurrentOnFolderDisplay;
    }

    public String getExecuteHostSetsOnFolder() {
        return this.mExecuteHostSetsOnFolder;
    }

    public String getDeleteHistoryHostSetsOnFolder() {
        return this.mDeleteHistoryHostSetsOnFolder;
    }

    public boolean getWriteOnFolder() {
        return this.mWriteOnFolder;
    }

    public boolean getOwnerPermission() {
        return this.mOwnerPermission;
    }

    public boolean getWriteOnParentFolder() {
        return this.mWriteOnParentFolder;
    }

    public boolean getWriteOnPlugin() {
        return this.mWriteOnPlugin;
    }

    public String getPluginName() {
        return this.mPluginName;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public String[] getAllOwnerGroupNames() {
        return this.mAllOwnerGroupNames;
    }

    public String[] getAllOwnerGroupIDs() {
        return this.mAllOwnerGroupIDs;
    }

    public String[] getAllPermissionGroupNames() {
        return this.mAllPermissionGroupNames;
    }

    public String[] getAllPermissionGroupIDs() {
        return this.mAllPermissionGroupIDs;
    }

    public String[] getAllHostSetNames() {
        return this.mAllHostSetNames;
    }

    public String[] getAllHostSetIDs() {
        return this.mAllHostSetIDs;
    }

    public String getNewGroupID() {
        return this.mNewGroupID;
    }

    public boolean getNewWritePerm() {
        return this.mNewWritePerm;
    }

    public boolean getNewAutoRunPerm() {
        return this.mNewAutoRunPerm;
    }

    public boolean getNewCheckInCurrentPerm() {
        return this.mNewCheckInCurrentPerm;
    }

    public String getNewHostSetID() {
        return this.mNewHostSetID;
    }

    public String getNewDeleteHistoryHostSetID() {
        return this.mNewDeleteHistoryHostSetID;
    }

    public String[] getGroupNames() {
        return this.mGroupNames;
    }

    public String[] getGroupIDs() {
        return this.mGroupIDs;
    }

    public boolean[] getWritePermissions() {
        return this.mWritePermissions;
    }

    public boolean[] getAutoRunPermissions() {
        return this.mAutoRunPermissions;
    }

    public boolean[] getCheckInCurrentPermissions() {
        return this.mCheckInCurrentPermissions;
    }

    public String[] getHostSetIDs() {
        return this.mHostSetIDs;
    }

    public String[] getHostSetNames() {
        return this.mHostSetNames;
    }

    public String[] getDeleteHistoryHostSetIDs() {
        return this.mDeleteHistoryHostSetIDs;
    }

    public String[] getDeleteHistoryHostSetNames() {
        return this.mDeleteHistoryHostSetNames;
    }

    public MultiCheckbox getMultiCheckbox() {
        return this.mMultiCheckbox;
    }

    public String getMode() {
        return this.mMode;
    }

    public boolean getIsNew() {
        return this.mIsNew;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public boolean getEditDisable() {
        return this.mEditDisable;
    }

    public void setID(String in) {
        this.mID = in;
    }

    public void setName(String in) {
        this.mName = in;
    }

    public void setDescription(String in) {
        this.mDescription = in;
    }

    public void setOwnerGroupID(String in) {
        this.mOwnerGroupID = in;
    }

    public void setNewGroupID(String in) {
        this.mNewGroupID = in;
    }

    public void setNewWritePerm(boolean in) {
        this.mNewWritePerm = in;
    }

    public void setNewAutoRunPerm(boolean in) {
        this.mNewAutoRunPerm = in;
    }

    public void setNewCheckInCurrentPerm(boolean in) {
        this.mNewCheckInCurrentPerm = in;
    }

    public void setNewHostSetID(String in) {
        this.mNewHostSetID = in;
    }

    public void setNewDeleteHistoryHostSetID(String in) {
        this.mNewDeleteHistoryHostSetID = in;
    }

    public void setGroupNames(String[] in) {
        this.mGroupNames = in;
    }

    public void setGroupIDs(String[] in) {
        this.mGroupIDs = in;
    }

    public void setWritePermissions(boolean[] in) {
        this.mWritePermissions = in;
    }

    public void setAutoRunPermissions(boolean[] in) {
        this.mAutoRunPermissions = in;
    }

    public void setCheckInCurrentPermissions(boolean[] in) {
        this.mCheckInCurrentPermissions = in;
    }

    public void setHostSetIDs(String[] in) {
        this.mHostSetIDs = in;
    }

    public void setDeleteHistoryHostSetIDs(String[] in) {
        this.mDeleteHistoryHostSetIDs = in;
    }

    public void setMultiCheckbox(MultiCheckbox in) {
        this.mMultiCheckbox = in;
    }

    public void setEditDisable(boolean in) {
        this.mEditDisable = in;
    }

    public void setParentFolderID(String folderID) {
        this.mParentFolderID = folderID;
    }

    public void setFolderPath(String folderID) throws RaplixException {
        this.mFolderPath = ChangePathBean.folderIDtoFilePath(folderID);
    }

    public void setWriteOnFolderDisplay(boolean in) {
        this.mWriteOnFolderDisplay = in;
    }

    public void setAutoRunOnFolderDisplay(boolean in) {
        this.mAutoRunOnFolderDisplay = in;
    }

    public void setCheckInCurrentOnFolderDisplay(boolean in) {
        this.mCheckInCurrentOnFolderDisplay = in;
    }

    public void setExecuteHostSetsOnFolder(String in) {
        this.mExecuteHostSetsOnFolder = in;
    }

    public void setDeleteHistoryHostSetsOnFolder(String in) {
        this.mDeleteHistoryHostSetsOnFolder = in;
    }

    public void setOwnerPermission(boolean in) {
        this.mOwnerPermission = in;
    }

    public void setWriteOnFolder(boolean in) {
        this.mWriteOnFolder = in;
    }

    public void setWriteOnParentFolder(boolean in) {
        this.mWriteOnParentFolder = in;
    }

    public void setWriteOnPlugin(boolean in) {
        this.mWriteOnPlugin = in;
    }

    public void setPluginName(String in) {
        this.mPluginName = in;
    }

    public void setPluginID(String in) {
        this.mPluginID = in;
    }

    public void setMode(String mode) {
        this.mMode = mode;
    }

    public void setIsNew(boolean isNew) {
        this.mIsNew = isNew;
    }

    public void setUpdateCount(int count) {
        this.mUpdateCount = count;
    }

    public void createFolder(String name, String description, String parentID, String groupID) throws RaplixException {
        this.setID("");
        this.setName(name);
        this.setParentFolderID(parentID);
        this.setFolderPath(parentID);
        this.setIsNew(true);
        this.setUpdateCount(0);
        this.loadUserFolderPermissions(parentID);
        Folder folder = new FolderID(parentID).getByIDQuery().select();
        this.loadGroupFolderPermissions(folder);
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(new FolderID(parentID));
        this.mWriteOnPlugin = true;
        if (!this.getWriteOnFolder()) {
            this.setDescription("");
        } else {
            this.setDescription(description);
        }
        if (!this.getOwnerPermission() || "---".equals(groupID)) {
            this.setOwnerGroupID(folder.getGroupID().toString());
        } else {
            this.setOwnerGroupID(groupID);
        }
        this.updateOwnerGroupInfo();
    }

    public void loadFolder(String id) throws RaplixException {
        Folder folder = new FolderID(id).getByIDQuery().select();
        this.generateFolderDetails(folder);
        this.loadUserFolderPermissions(this.mID);
        this.loadGroupFolderPermissions(folder);
    }

    private void generateFolderDetails(Folder folder) throws RaplixException {
        PluginID pluginID;
        this.mID = folder.getID().toString();
        this.mName = folder.getFullPathString();
        this.mDescription = folder.getDescription();
        FolderID parentID = folder.getParentFolderID();
        if (parentID != null) {
            this.setParentFolderID(parentID.toString());
            this.setFolderPath(parentID.toString());
        }
        if ((pluginID = folder.getPluginID()) != null) {
            this.mPluginID = pluginID.toString();
            this.mPluginName = pluginID.getByIDQuery().selectSummaryView().getName();
        }
        this.mWriteOnFolder = PermissionChecker.hasWriteOnFolder(new FolderID(this.mID));
        if (parentID != null) {
            this.mWriteOnParentFolder = PermissionChecker.hasWriteOnFolder(parentID);
        }
        this.mWriteOnPlugin = PermissionChecker.hasWriteOnPlugin(folder);
        this.mOwnerGroupID = folder.getGroupID().toString();
        this.mUpdateCount = folder.getUpdateCount();
        this.updateOwnerGroupInfo();
    }

    public void loadUserGroups(GroupManager groupManager) throws RaplixException {
        this.mAllOwnerGroupNames = UserGroupsBean.getUserGroupNames();
        this.mAllOwnerGroupIDs = UserGroupsBean.getUserGroupIDs();
        int arrLen = this.mAllOwnerGroupNames.length;
        String adminGroupID = groupManager.getAdminGroupID().toString();
        this.mAllPermissionGroupNames = new String[arrLen - 1];
        this.mAllPermissionGroupIDs = new String[arrLen - 1];
        int index = 0;
        for (int i = 0; i < arrLen; ++i) {
            if (adminGroupID.equals(this.mAllOwnerGroupIDs[i])) continue;
            this.mAllPermissionGroupNames[index] = this.mAllOwnerGroupNames[i];
            this.mAllPermissionGroupIDs[index] = this.mAllOwnerGroupIDs[i];
            ++index;
        }
    }

    public void loadHostSets() throws RaplixException {
        HostSetsListBean hslb = new HostSetsListBean();
        hslb.loadAllHostSets();
        int arrayLen = hslb.getNames().length;
        this.mAllHostSetNames = new String[arrayLen + 1];
        this.mAllHostSetIDs = new String[arrayLen + 1];
        this.mAllHostSetNames[0] = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        this.mAllHostSetIDs[0] = UNIVERSAL_SET_ID;
        for (int i = 0; i < arrayLen; ++i) {
            this.mAllHostSetNames[i + 1] = hslb.getNames()[i];
            this.mAllHostSetIDs[i + 1] = hslb.getIDs()[i];
        }
    }

    public void updateOwnerGroupInfo() throws RaplixException {
        String groupName;
        this.mOwnerUserGroup = groupName = UserGroupsBean.getGroupName(new GroupID(this.mOwnerGroupID));
    }

    public void clearNewPermission() {
        this.mNewGroupID = null;
        this.mNewWritePerm = false;
        this.mNewAutoRunPerm = false;
        this.mNewCheckInCurrentPerm = false;
        this.mNewHostSetID = null;
        this.mNewDeleteHistoryHostSetID = null;
    }

    public void loadUserFolderPermissions(String folderID) throws RaplixException {
        HostSetIDSet hostsetIDs;
        FolderID id = new FolderID(folderID);
        UserFolderPermissions ufp = id.getUserPermissions();
        this.mOwnerPermission = ufp.isOwner();
        this.mWriteOnFolderDisplay = ufp.isWrite();
        this.mAutoRunOnFolderDisplay = ufp.isAutorun();
        this.mCheckInCurrentOnFolderDisplay = ufp.isCheckin();
        if (ufp.isExecuteAllHosts()) {
            this.mExecuteHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getExecuteHostSets();
            this.mExecuteHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
        if (ufp.isDeleteHistoryAllHosts()) {
            this.mDeleteHistoryHostSetsOnFolder = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
        } else {
            hostsetIDs = ufp.getDeleteHistoryHostSets();
            this.mDeleteHistoryHostSetsOnFolder = Util.hostSets2String(hostsetIDs);
        }
    }

    public void loadGroupFolderPermissions(Folder folder) throws RaplixException {
        FolderAccessData fad = folder.getFolderAccessData();
        MultiGroupQuery query = fad.getACLGroups().getByIDsQuery();
        query.setObjectOrder(GroupOrder.BY_NAME_ASC);
        Group[] groups = query.select();
        int len = groups.length;
        this.mGroupNames = new String[len];
        this.mGroupIDs = new String[len];
        this.mWritePermissions = new boolean[len];
        this.mAutoRunPermissions = new boolean[len];
        this.mCheckInCurrentPermissions = new boolean[len];
        this.mHostSetIDs = new String[len];
        this.mHostSetNames = new String[len];
        this.mDeleteHistoryHostSetIDs = new String[len];
        this.mDeleteHistoryHostSetNames = new String[len];
        for (int i = 0; i < len; ++i) {
            SummaryHostSet hostSet;
            this.mGroupIDs[i] = groups[i].getGroupID().toString();
            this.mGroupNames[i] = groups[i].getName();
            FolderPermissionItem fpi = fad.getACL(groups[i].getGroupID());
            this.mWritePermissions[i] = fpi.isWrite();
            this.mAutoRunPermissions[i] = fpi.isAutoRun();
            this.mCheckInCurrentPermissions[i] = fpi.isCheckin();
            if (fpi.isExecuteAllHosts()) {
                this.mHostSetIDs[i] = UNIVERSAL_SET_ID;
                this.mHostSetNames[i] = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
            } else if (fpi.getExecute() == null) {
                this.mHostSetIDs[i] = null;
                this.mHostSetNames[i] = null;
            } else {
                this.mHostSetIDs[i] = fpi.getExecute().toString();
                hostSet = fpi.getExecute().getByIDQuery().selectSummaryView();
                this.mHostSetNames[i] = hostSet.getName();
            }
            if (fpi.isDeleteHistoryAllHosts()) {
                this.mDeleteHistoryHostSetIDs[i] = UNIVERSAL_SET_ID;
                this.mDeleteHistoryHostSetNames[i] = ApplicationResources.getMessage(MSG_LABEL_UNIVERSALSET);
                continue;
            }
            if (fpi.getDeleteHistory() == null) {
                this.mDeleteHistoryHostSetIDs[i] = null;
                this.mDeleteHistoryHostSetNames[i] = null;
                continue;
            }
            this.mDeleteHistoryHostSetIDs[i] = fpi.getDeleteHistory().toString();
            hostSet = fpi.getDeleteHistory().getByIDQuery().selectSummaryView();
            this.mDeleteHistoryHostSetNames[i] = hostSet.getName();
        }
        this.mMultiCheckbox = new MultiCheckbox("bulk", this.mGroupIDs);
    }

    public void saveFolder() throws RaplixException {
        Folder folder = this.mIsNew ? new Folder(this.mName, new FolderID(this.mParentFolderID), null) : new FolderID(this.mID).getByIDQuery().select();
        this.copyFolderSettings(folder);
        try {
            folder.save();
        }
        catch (FolderDBException fdbe) {
            if (!this.mIsNew) {
                this.syncUpdateCount(folder);
            }
            throw fdbe;
        }
        this.mID = folder.getID().toString();
        this.mName = folder.getFullPathString();
    }

    public void renameFolder(String newName) throws RaplixException {
        FolderID folderID = new FolderID(this.mID);
        folderID.move(null, newName);
    }

    public void moveFolder(String newParentID) throws RaplixException {
        FolderID folderID = new FolderID(this.mID);
        folderID.move(new FolderID(newParentID), null);
    }

    private void copyFolderSettings(Folder folder) throws RaplixException {
        folder.setDescription(this.mDescription);
        FolderAccessData fad = folder.getFolderAccessData();
        fad.setOwnerID(new GroupID(this.mOwnerGroupID));
        if (this.getOwnerPermission()) {
            fad.clearACLs();
            for (int i = 0; i < this.mGroupIDs.length; ++i) {
                FolderPermissionItem fpi = new FolderPermissionItem(new GroupID(this.mGroupIDs[i]));
                fpi.setWrite(this.mWritePermissions[i]);
                fpi.setCheckin(this.mCheckInCurrentPermissions[i]);
                fpi.setAutoRun(this.mAutoRunPermissions[i]);
                if (this.mHostSetIDs[i] != null) {
                    if (UNIVERSAL_SET_ID.equals(this.mHostSetIDs[i])) {
                        fpi.setExecuteAllHosts(true);
                    } else {
                        fpi.setExecute(new HostSetID(this.mHostSetIDs[i]));
                    }
                }
                if (this.mDeleteHistoryHostSetIDs[i] != null) {
                    if (UNIVERSAL_SET_ID.equals(this.mDeleteHistoryHostSetIDs[i])) {
                        fpi.setDeleteHistoryAllHosts(true);
                    } else {
                        fpi.setDeleteHistory(new HostSetID(this.mDeleteHistoryHostSetIDs[i]));
                    }
                }
                fad.addACL(fpi);
            }
        }
        folder.setFolderAccessData(fad);
        folder.setUpdateCount(this.mUpdateCount);
    }

    private void syncUpdateCount(Folder folder) {
        this.mID = folder.getID().toString();
        this.mUpdateCount = folder.getUpdateCount();
    }

    public static String resolveIDToPath(String folderID) throws RaplixException {
        return new FolderID(folderID).getByIDQuery().selectSummaryView().getFullPathString();
    }
}

