/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.folders;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.ui.web.ActionModeConstants;
import com.raplix.rolloutexpress.ui.web.ChangePathBean;
import com.raplix.rolloutexpress.ui.web.MultiCheckbox;
import com.raplix.rolloutexpress.ui.web.Preference;
import com.raplix.rolloutexpress.ui.web.ServletBean;
import com.raplix.rolloutexpress.ui.web.ServletInfo;
import com.raplix.rolloutexpress.ui.web.ServletListBean;
import com.raplix.rolloutexpress.ui.web.ServletPreferenceBroker;
import com.raplix.rolloutexpress.ui.web.ServletSessionBroker;
import com.raplix.rolloutexpress.ui.web.UIActionListServlet;
import com.raplix.rolloutexpress.ui.web.folders.FoldersListBean;
import java.security.AccessControlException;
import javax.servlet.http.HttpServletRequest;

public class FoldersAction
extends UIActionListServlet
implements ActionModeConstants {
    public static final String MSG_ERROR = "error.folders.list";
    public static final String MSG_ERROR_NO_SELECTION = "error.folders.noselection";
    public static final String MSG_ERROR_MOVE_MAJOR = "error.folders.move.major";

    public void doUIAction(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "";
        }
        if (mode.equals("move")) {
            this.handleMove(request, servletInfo);
        } else if (mode.equals("moveNoSelection")) {
            this.handleMoveNoSelection(request, servletInfo);
        } else {
            this.handleList(request, servletInfo);
        }
    }

    private void handleList(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        String minorErrorKey;
        FoldersListBean bean = (FoldersListBean)servletInfo.getBean();
        String majorErrorKey = request.getParameter("majorErrorKey");
        if (majorErrorKey != null) {
            servletInfo.getErrors().setMajorErrorKey(majorErrorKey);
        }
        if ((minorErrorKey = request.getParameter("minorErrorKey")) != null) {
            servletInfo.getErrors().addMinorErrorKey(minorErrorKey);
        }
        bean.loadCategoryFilters();
        this.loadListParameters(request, bean);
        bean.generateList();
        bean.loadUserGroupArrays();
        MultiCheckbox mc = bean.getMultiCheckbox();
        if (mc != null) {
            ServletSessionBroker ssb = ServletSessionBroker.getBroker(request.getSession());
            ssb.put(mc.getID(), mc);
        }
        servletInfo.setDestPage("/folders/folders.jsp");
        servletInfo.setSaveInSession(false);
    }

    private void handleMove(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        FoldersListBean bean = (FoldersListBean)servletInfo.getBean();
        String movePath = FoldersAction.assertGetParam(request, "movePath");
        MultiCheckbox in = new MultiCheckbox("bulk", request);
        String[] ids = in.getSelected();
        if (ids.length == 0) {
            this.handleMoveNoSelection(request, servletInfo);
            return;
        }
        try {
            bean.move(ids, movePath);
        }
        catch (PersistenceManagerException pme) {
            servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE_MAJOR);
            if (pme.nestedException() != null && pme.nestedException() instanceof AccessControlException) {
                servletInfo.getErrors().addMinorError(this.ACExToString((AccessControlException)pme.nestedException()));
            }
            servletInfo.getErrors().addMinorError(pme.getMessage());
        }
        this.handleList(request, servletInfo);
    }

    private void handleMoveNoSelection(HttpServletRequest request, ServletInfo servletInfo) throws RaplixException {
        servletInfo.getErrors().setMajorErrorKey(MSG_ERROR_MOVE_MAJOR);
        servletInfo.getErrors().addMinorErrorKey(MSG_ERROR_NO_SELECTION);
        this.handleList(request, servletInfo);
    }

    protected void setAdditionalFindFilters(HttpServletRequest request, ServletListBean bean) {
        String findParentName = request.getParameter("parentName");
        String findOwnerUserGroup = request.getParameter("ownerGroupID");
        FoldersListBean flb = (FoldersListBean)bean;
        if (findParentName != null) {
            flb.setFindParentName(findParentName);
        }
        if (findOwnerUserGroup != null) {
            flb.setFindOwnerUserGroup(request.getParameter("ownerGroupID"));
        }
    }

    protected void setAdditionalFilters(HttpServletRequest request, ServletListBean bean) {
        ServletPreferenceBroker spb = ServletPreferenceBroker.getBroker(request.getSession());
        boolean flatView = spb.trackBoolean(Preference.FLAT_VIEW, request);
        String filePathFilter = spb.trackString(Preference.FILE_PATH, request);
        filePathFilter = ChangePathBean.verifyFolderID(filePathFilter);
        spb.setString(Preference.FILE_PATH, filePathFilter);
        bean.setFilePathFilter(filePathFilter);
        bean.setFlatView(flatView);
    }

    public ServletBean createBean(HttpServletRequest request) {
        return new FoldersListBean();
    }

    public String getDefaultPage() {
        return "/folders/folders.jsp";
    }

    public String getMajorError(HttpServletRequest request) {
        String mode = request.getParameter("mode");
        if (mode == null) {
            mode = "list";
        }
        if (mode.equals("moveNoSelection")) {
            return MSG_ERROR_MOVE_MAJOR;
        }
        if (mode.equals("move")) {
            return MSG_ERROR_MOVE_MAJOR;
        }
        return MSG_ERROR;
    }
}

