/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.folders;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.ui.web.StandardObjectDeleteNode;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;

public class FolderDeleteNode
extends StandardObjectDeleteNode {
    private static final int DELETE_CONFIRM_COLSPAN = 2;

    public FolderDeleteNode(DeleteSessionCandidate candidate) throws RaplixException {
        super(candidate);
    }

    public int getDeleteConfirmColspan() {
        return 2;
    }

    public String getDeleteContext() {
        return "folderDelete";
    }

    public StandardObject getObject(DeleteSessionCandidate candidate) throws RaplixException {
        FolderID folderID = (FolderID)candidate.getParent().getObjectID();
        return folderID.getByIDQuery().selectSummaryView();
    }

    public void preRender() throws RaplixException {
        this.mRowLevel = this.mIsUndeletable ? 2 : 0;
        String viewURI = UriUtil.folderDetailsURI(this.mObjectID.toString());
        String toolTip = "Show folder details";
        String nameLink = Util.standardLink(viewURI, toolTip, Util.preserveSpace(this.mName), "name=\"nameLink-" + this.mObjectID + "\"");
        String descLink = Util.standardLink(viewURI, toolTip, this.mDescription);
        String cellStart = Util.standardCellStart(0, "nowrap", this.mRowLevel);
        StringBuffer buf = new StringBuffer();
        buf.append(nameLink);
        buf.append(Util.standardCellEnd());
        buf.append(cellStart);
        buf.append(descLink);
        buf.append(Util.standardCellEnd());
        buf.append("</tr>");
        this.mContents = buf.toString();
    }
}

