/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.data;

import com.raplix.rolloutexpress.event.query.bean.HostHistoryBean;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class TaskStatusInfo {
    public static final int TASKSTATUS_NOTSTARTED = -1;
    public static final int TASKSTATUS_RUNNING = 0;
    public static final int TASKSTATUS_COMPLETE = 10;
    public static final int TASKSTATUS_FAIL = 20;
    public static final int TASKSTATUS_ABORT = 30;
    public static final int TASKSTATUS_TIMEOUT = 40;
    protected static final String MSG_COMPLETION_STATUS_NOTRUNNING = "planRunHistory.taskCompletion.completed";
    protected static final String MSG_COMPLETION_STATUS_RUNNING = "planRunHistory.taskCompletion.running";
    private static final String MSG_STATUS_NORMAL = "planRunHistory.taskStatus.normal";
    private static final String MSG_STATUS_NORMAL_WARNINGS = "planRunHistory.taskStatus.normalwarn";
    private static final String MSG_STATUS_ABORT = "planRunHistory.taskStatus.abort";
    private static final String MSG_STATUS_FAILED = "planRunHistory.taskStatus.failed";
    private static final String MSG_STATUS_TIMEOUT = "planRunHistory.taskStatus.timeout";
    private static final String MSG_DETAILSTATUS_STARTED = "planRunHistory.detailedStatus.started";
    private static final String MSG_DETAILSTATUS_COMPLETED = "planRunHistory.detailedStatus.completed";
    private static final String MSG_DETAILSTATUS_NORMAL = "planRunHistory.detailedStatus.normal";
    private static final String MSG_DETAILSTATUS_NORMAL_WARNINGS = "planRunHistory.detailedStatus.normalwarn";
    private static final String MSG_DETAILSTATUS_FAILED = "planRunHistory.detailedStatus.failed";
    private static final String MSG_DETAILSTATUS_FAILED_WARNINGS = "planRunHistory.detailedStatus.failedwarn";
    private static final String MSG_DETAILSTATUS_FAILED_STOPPED = "planRunHistory.detailedStatus.abort";
    private static final String MSG_DETAILSTATUS_RUNNING = "planRunHistory.detailedStatus.running";
    protected static final String MSG_TASK_CANCELLED = "error.plans.aborted";
    protected static final String MSG_TASK_CANCEL_PENDING = "error.plans.abortpending";
    protected static final String MSG_TASK_CANCEL_IGNORED = "error.plans.abortignored";
    private Date mCompletionDate = new Date();
    private Date mStartDate = new Date();
    private int mStatus = -1;
    private int mNumErrors = 0;
    private int mNumWarnings = 0;
    private boolean mIsPreflightOnly = false;
    private String mRunningUser = "";
    private String mRunType = "";
    private boolean mPreflightComplete = false;
    private boolean mDeploymentEnabled = false;
    private boolean mAbortRequested = false;
    private boolean mCancelling = false;

    public TaskStatusInfo(HostHistoryBean hhb) {
        this.mIsPreflightOnly = hhb.getIsPreflight();
        this.mCompletionDate = hhb.getCompleteDate();
        this.mStartDate = hhb.getStartDate();
        this.setStatusForTaskStatus(hhb.getStatus());
        this.mNumErrors = hhb.getErrors().size();
        this.mNumWarnings = hhb.getWarnings().size();
    }

    public TaskStatusInfo(TaskStatusBean tsb) {
        this.mIsPreflightOnly = tsb.getPreflightOnly();
        this.mCompletionDate = tsb.getCompleteDate();
        this.mStartDate = tsb.getStartDate();
        this.setStatusForTaskStatus(tsb.getTaskStatus());
        this.mNumWarnings = tsb.getWarningCount();
        this.mNumErrors = tsb.getErrorCount();
        this.mAbortRequested = tsb.getTaskAbortRequested();
        if (!tsb.getTaskStatus().equals(TaskStatus.NOT_STARTED) && !tsb.getTaskStatus().equals(TaskStatus.PREFLIGHT_RUNNING)) {
            this.mPreflightComplete = true;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Preflight complete:  task status is " + tsb.getTaskStatus().toString(), this);
            }
        }
        if (!tsb.getPreflightOnly() && !tsb.getPreflightFailed() && this.mPreflightComplete) {
            this.mDeploymentEnabled = true;
        }
    }

    public TaskStatusInfo() {
    }

    public Date getCompletionDate() {
        return this.mCompletionDate;
    }

    public Date getStartDate() {
        return this.mStartDate;
    }

    public int getNumWarnings() {
        return this.mNumWarnings;
    }

    public int getNumErrors() {
        return this.mNumErrors;
    }

    public boolean isStarted() {
        return this.mStatus != -1;
    }

    public boolean isCompletedOK() {
        return this.mStatus == 10;
    }

    public boolean isFailed() {
        return this.mStatus == 20 || this.mStatus == 30;
    }

    public boolean isRunning() {
        return this.mStatus == 0;
    }

    public boolean isAborted() {
        return this.mStatus == 30;
    }

    public void setRunningUser(String user) {
        this.mRunningUser = user;
    }

    public void setRunType(String runType) {
        this.mRunType = runType;
    }

    public void setCancelling(boolean cancelling) {
        this.mCancelling = cancelling;
    }

    private void setStatusForTaskStatus(TaskStatus status) {
        if (status.equals(TaskStatus.NOT_STARTED)) {
            this.mStatus = -1;
        } else if (status.equals(TaskStatus.PREFLIGHT_RUNNING)) {
            this.mStatus = 0;
        } else if (status.equals(TaskStatus.DEPLOYMENT_RUNNING)) {
            this.mStatus = 0;
        } else if (status.equals(TaskStatus.COMPLETE)) {
            this.mStatus = 10;
        } else if (status.equals(TaskStatus.COMPLETE_WARNINGS)) {
            this.mStatus = 10;
        } else if (status.equals(TaskStatus.INCOMPLETE_ABORT)) {
            this.mStatus = 30;
        } else if (status.equals(TaskStatus.INCOMPLETE_TIMEOUT)) {
            this.mStatus = 20;
        } else if (status.equals(TaskStatus.INCOMPLETE_ERROR)) {
            this.mStatus = 20;
        }
    }

    private void setStatusForTaskStatus(int status) {
        if (status == 0) {
            this.mStatus = 0;
        } else if (status == 1) {
            this.mStatus = 10;
        } else if (status == 2) {
            this.mStatus = 10;
        } else if (status == 3) {
            this.mStatus = 30;
        } else if (status == 4) {
            this.mStatus = 20;
        } else if (status == 5) {
            this.mStatus = 20;
        }
    }

    public boolean getIsPreflightComplete() {
        return this.mPreflightComplete;
    }

    public boolean getIsDeploymentEnabled() {
        return this.mDeploymentEnabled;
    }

    public boolean getAbortRequested() {
        return this.mAbortRequested;
    }

    public String getShortStatus() {
        switch (this.mStatus) {
            case -1: {
                return "";
            }
            case 0: {
                return "";
            }
            case 10: {
                if (this.mNumWarnings > 0) {
                    return ApplicationResources.getMessage(MSG_STATUS_NORMAL_WARNINGS, Util.pluringular("" + this.mNumWarnings, "warning", "warnings"));
                }
                return ApplicationResources.getMessage(MSG_STATUS_NORMAL);
            }
            case 30: {
                return ApplicationResources.getMessage(MSG_STATUS_ABORT);
            }
            case 40: {
                return ApplicationResources.getMessage(MSG_STATUS_TIMEOUT);
            }
            case 20: {
                return ApplicationResources.getMessage(MSG_STATUS_FAILED, Util.pluringular("" + this.mNumErrors, "error", "errors"));
            }
        }
        throw new IllegalArgumentException("Unknown status " + this.mStatus);
    }

    public String getCompletionString() {
        if (this.isRunning()) {
            return ApplicationResources.getMessage(MSG_COMPLETION_STATUS_RUNNING, this.mStartDate);
        }
        return ApplicationResources.getMessage(MSG_COMPLETION_STATUS_NOTRUNNING, this.mCompletionDate);
    }

    public String getDetailedStatus(TaskInfo taskInfo) {
        boolean done = !this.isRunning();
        StringBuffer sb = new StringBuffer();
        sb.append(this.detailedStartString(taskInfo));
        sb.append("<br>");
        if (done) {
            sb.append(this.detailedCompletedString(taskInfo));
            sb.append("<br>");
        }
        sb.append(this.detailedErrorString());
        return sb.toString();
    }

    private String detailedStartString(TaskInfo taskInfo) {
        String numStartedHosts;
        block2: {
            numStartedHosts = "0 hosts";
            try {
                numStartedHosts = Util.pluringular("" + taskInfo.getAllTargetsStatus().length, "host", "hosts");
            }
            catch (PlanExecutionException pee) {
                if (!Logger.isDebugEnabled(this)) break block2;
                Logger.debug("Unable to retrieve target statuses", pee, this);
            }
        }
        String startDate = Util.formatDate(this.mStartDate);
        return ApplicationResources.getMessage(MSG_DETAILSTATUS_STARTED, numStartedHosts, this.mRunningUser, startDate);
    }

    private String detailedCompletedString(TaskInfo taskInfo) {
        String time;
        String numCompletedHosts;
        block4: {
            numCompletedHosts = "0 hosts";
            try {
                numCompletedHosts = Util.pluringular("" + taskInfo.getAllSuccessfulHosts().size(), "host", "hosts");
            }
            catch (PlanExecutionException pee) {
                if (!Logger.isDebugEnabled(this)) break block4;
                Logger.debug("Unable to retrieve target statuses", pee, this);
            }
        }
        if (this.mCompletionDate == null || this.mStartDate == null) {
            time = "(unknown)";
        } else {
            long timeDiff = this.mCompletionDate.getTime() - this.mStartDate.getTime();
            long hoursDiff = (timeDiff /= 1000L) / 3600L;
            long minutesDiff = timeDiff % 3600L / 60L;
            time = timeDiff == 0L || timeDiff >= 60L ? Util.pluringular("" + hoursDiff, "hour", "hours") + " " + Util.pluringular("" + minutesDiff, "minute", "minutes") : "< 1 minute";
        }
        String completedDate = Util.formatDate(this.mCompletionDate);
        return ApplicationResources.getMessage(MSG_DETAILSTATUS_COMPLETED, numCompletedHosts, time, completedDate);
    }

    private String detailedErrorString() {
        String status = "";
        if (this.isRunning()) {
            status = ApplicationResources.getMessage(MSG_DETAILSTATUS_RUNNING, this.mRunType);
        } else if (this.isCompletedOK()) {
            String warnings = Util.pluringular("" + this.mNumWarnings, "warning", "warnings");
            status = this.mNumWarnings > 0 ? ApplicationResources.getMessage(MSG_DETAILSTATUS_NORMAL_WARNINGS, this.mRunType, warnings) : ApplicationResources.getMessage(MSG_DETAILSTATUS_NORMAL, this.mRunType);
        } else if (this.isAborted()) {
            status = ApplicationResources.getMessage(MSG_DETAILSTATUS_FAILED_STOPPED, this.mRunType);
        } else {
            String errors = Util.pluringular("" + this.mNumErrors, "error", "errors");
            String warnings = Util.pluringular("" + this.mNumWarnings, "warning", "warnings");
            status = this.mNumWarnings > 0 ? ApplicationResources.getMessage(MSG_DETAILSTATUS_FAILED_WARNINGS, this.mRunType, warnings, errors) : ApplicationResources.getMessage(MSG_DETAILSTATUS_FAILED, this.mRunType, errors);
        }
        return status;
    }

    public String getCancelMessage() {
        String cancelStatus = null;
        if (this.isAborted()) {
            cancelStatus = ApplicationResources.getMessage(MSG_TASK_CANCELLED);
        } else if (this.mAbortRequested || this.mCancelling) {
            cancelStatus = this.isCompletedOK() || this.isFailed() ? ApplicationResources.getMessage(MSG_TASK_CANCEL_IGNORED) : ApplicationResources.getMessage(MSG_TASK_CANCEL_PENDING);
        }
        return cancelStatus;
    }
}

