/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.data;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.difference.Difference;
import com.raplix.rolloutexpress.difference.DifferenceID;
import com.raplix.rolloutexpress.difference.IIDifferencePath;
import com.raplix.rolloutexpress.difference.MIDifferencePath;
import com.raplix.rolloutexpress.difference.differencedb.DifferenceDBInterface;
import com.raplix.rolloutexpress.event.ROXDifferenceFoundEvent;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBManager;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.ui.web.ApplicationResources;
import com.raplix.rolloutexpress.ui.web.ParameterConstants;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.Replace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class DiffResultsObject
implements ParameterConstants {
    public static final String ROOT_NODE = "Root Node";
    private static final String TREE_SEPARATOR = "*";
    private static final String FILE_SEPARATOR = "/";
    private static final String COMMA_SEPARATOR = ",";
    private static final String HOST_SUFFIX = ":";
    private static final String COMPONENT_PREFIX = "[";
    private static final String COMPONENT_SUFFIX = "]";
    private static final String FC_FIVE_STAR = "*****";
    private static final String FC_COLON = ":";
    private static final String DIFF_A = "a";
    private static final String DIFF_C = "c";
    private static final String DIFF_D = "d";
    private static final String DIFF_COMMA = ",";
    private static final char DIFF_LEFT = '<';
    private static final char DIFF_RIGHT = '>';
    private static final String LABEL_REFERENCE_LINE = ApplicationResources.getMessage("label.diff.results.referenceline");
    private static final String LABEL_COMPARISON_LINE = ApplicationResources.getMessage("label.diff.results.comparisonline");
    private static final String LABEL_ADDED_AT = ApplicationResources.getMessage("label.diff.results.addedat");
    private static final String LABEL_CHANGED_TO = ApplicationResources.getMessage("label.diff.results.changedto");
    private static final String LABEL_DELETED = ApplicationResources.getMessage("label.diff.results.deleted");
    private static final String LABEL_FILE_CONTENTS = ApplicationResources.getMessage("label.diff.results.filecontents");
    private static final String LABEL_LINES_CHANGED = ApplicationResources.getMessage("label.diff.results.lineschanged");
    private static final String LABEL_TAB = ApplicationResources.getMessage("label.diff.results.tab");
    private static final String LABEL_NEWLINE = ApplicationResources.getMessage("label.diff.results.newline");
    private static final String LABEL_CARRIAGE_RETURN = ApplicationResources.getMessage("label.diff.results.carriagereturn");
    private static final String LABEL_LINEFEED = ApplicationResources.getMessage("label.diff.results.linefeed");
    protected Hashtable hostRoots = null;
    protected Hashtable hostIDNameMap = null;
    protected ResultsTreeNode mCurrentDir = null;
    protected Vector mPath = null;
    protected Vector mPathTypes = null;
    protected boolean mHasHosts = false;
    protected String mCurrentHost = "Root Node";
    protected int mCurrentDifferenceIndex = -1;
    protected Vector mHostList = null;
    protected int mHostIndex = 0;
    protected String mCurrentDifferenceStr = null;
    protected String[] mAllDifferencePaths = new String[0];
    protected String[] mAllCurrentDifferences = new String[0];
    protected int[] mAllDifferenceSizes = new int[0];
    protected int mTotalDifferences = 0;
    private String mDiffStyle = "";
    protected InstallDBManager mInstallDB = null;
    public static final String HEADER_START = "</td><td class=\"tblRowCompDif\" valign=\"top\" colspan=\"2\">";
    public static final String DETAIL_ROW_START = "<tr><td class=\"tblCompItemDif\" valign=\"top\" align=\"right\">";
    public static final String DETAIL_ROW_SEP_LEFT = "</td><td class=\"tblRowComp\" valign=\"top\">";
    public static final String DETAIL_ROW_SEP_RIGHT = "</td><td class=\"tblRowCompDif\" valign=\"top\">";
    public static final String DETAIL_ROW_END = "</td></tr>";
    public static final String LINE_BREAK = "<br>";

    public String[] getPath() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Path array printout: " + this.mPath, this);
        }
        return this.mPath.toArray(new String[0]);
    }

    public String[] getPathTypes() {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Path array printout: " + this.mPathTypes, this);
        }
        return this.mPathTypes.toArray(new String[0]);
    }

    public String[] getSubDirectories() {
        if (this.mCurrentDir != null) {
            return this.mCurrentDir.getSubDirNames();
        }
        return new String[0];
    }

    public String[] getSubDirectoryTypes() {
        if (this.mCurrentDir != null) {
            return this.mCurrentDir.getSubDirTypes();
        }
        return new String[0];
    }

    public String getDifferenceCount() {
        if (this.mCurrentDir != null) {
            return "" + this.mCurrentDir.getDifferencesCount();
        }
        return "";
    }

    public String[] getSubdirectoryCounts() {
        if (this.mCurrentDir != null) {
            return this.mCurrentDir.getSubDirectoryDifferenceCounts();
        }
        return new String[0];
    }

    public String[] getDifferenceFilenames() {
        if (this.mCurrentDir != null) {
            return this.mCurrentDir.getMemberFileNames();
        }
        return new String[0];
    }

    public String[] getFileCounts() {
        if (this.mCurrentDir != null) {
            return this.mCurrentDir.getFilenamesDifferenceCounts();
        }
        return new String[0];
    }

    public int getCurrentDifferenceIndex() {
        return this.mCurrentDifferenceIndex;
    }

    public String getCurrentDifference() {
        return this.mCurrentDifferenceStr;
    }

    public String[] getAllCurrentDifferences() {
        return this.mAllCurrentDifferences;
    }

    public boolean hasHosts() {
        return this.mHasHosts;
    }

    public String getHostIndex() {
        return "" + this.mHostIndex;
    }

    public DiffResultsObject(InstallDBManager installDB) {
        this.hostRoots = new Hashtable();
        this.hostIDNameMap = new Hashtable();
        this.mHostList = new Vector();
        this.mPath = new Vector();
        this.mPathTypes = new Vector();
        this.mInstallDB = installDB;
    }

    public void loadFlatResults(ROXDifferenceFoundEvent[] inDifferences, DifferenceDBInterface inDiffDB) {
        this.mAllDifferencePaths = new String[inDifferences.length];
        this.mAllCurrentDifferences = new String[inDifferences.length];
        this.mAllDifferenceSizes = new int[inDifferences.length];
        this.mTotalDifferences = 0;
        for (int i = 0; i < inDifferences.length; ++i) {
            this.mAllDifferenceSizes[i] = DiffResultsObject.getDiffSize(inDifferences[i]);
            this.mTotalDifferences += this.mAllDifferenceSizes[i];
            this.mAllCurrentDifferences[i] = this.differenceToString(inDifferences[i].getDifference());
            if (this.mDiffStyle.equals("repo2repo")) {
                this.mAllDifferencePaths[i] = inDifferences[i].getDifferencePath();
                continue;
            }
            if (this.mDiffStyle.equals("repo2inst")) {
                MIDifferencePath midp = new MIDifferencePath();
                midp.inflate(inDifferences[i].getDifferencePath());
                this.mAllDifferencePaths[i] = midp.getFilePath();
                if (midp.getDisplayName() == null) continue;
                this.mAllDifferencePaths[i] = midp.getDisplayName();
                continue;
            }
            if (!this.mDiffStyle.equals("inst2inst")) continue;
            IIDifferencePath iidp = new IIDifferencePath();
            iidp.inflate(inDifferences[i].getDifferencePath());
            this.mAllDifferencePaths[i] = iidp.getFilePath();
        }
    }

    public void loadInstall2InstallResults(ROXDifferenceFoundEvent[] inDifferences, DifferenceDBInterface inDiffDB) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Creating the HostNode for the hostRoots hash", this);
        }
        ResultsTreeRoot hostNode = new ResultsTreeRoot(ROOT_NODE);
        this.hostRoots.put(ROOT_NODE, hostNode);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to add the inst2inst difference events.  Total events: " + inDifferences.length, this);
        }
        for (int i = 0; i < inDifferences.length; ++i) {
            this.addInst2InstDifferenceEvent(inDifferences[i]);
        }
        this.mCurrentDir = hostNode.getRoot();
        String[] names = this.mCurrentDir.getSubDirNames();
        if (names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                this.combineNodes(this.mCurrentDir, this.mCurrentDir.getSubDir(names[i], false));
            }
        }
        this.setPathOnLoad(hostNode);
        this.setCurrentDifferenceStr(inDiffDB);
    }

    public void loadModel2ModelResults(ROXDifferenceFoundEvent[] inDifferences, DifferenceDBInterface inDiffDB) {
        ResultsTreeRoot hostNode = new ResultsTreeRoot(ROOT_NODE);
        this.hostRoots.put(ROOT_NODE, hostNode);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to add the model2model difference events.  Total events: " + inDifferences.length, this);
        }
        for (int i = 0; i < inDifferences.length; ++i) {
            this.addModel2ModelDifferenceEvent(inDifferences[i]);
        }
        this.mCurrentDir = hostNode.getRoot();
        this.setPath(TREE_SEPARATOR);
        this.setAllCurrentDifferences(inDiffDB);
    }

    public void loadModel2InstallResults(ROXDifferenceFoundEvent[] inDifferences, DifferenceDBInterface inDiffDB) {
        ResultsTreeRoot hostNode = new ResultsTreeRoot(ROOT_NODE);
        this.hostRoots.put(ROOT_NODE, hostNode);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to add the model2install difference events.  Total events: " + inDifferences.length, this);
        }
        for (int i = 0; i < inDifferences.length; ++i) {
            this.addModel2InstDifferenceEvent(inDifferences[i]);
        }
        this.mCurrentDir = hostNode.getRoot();
        String[] names = this.mCurrentDir.getSubDirNames();
        if (names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                this.combineNodes(this.mCurrentDir, this.mCurrentDir.getSubDir(names[i], false));
            }
        }
        this.setPathOnLoad(hostNode);
        this.setCurrentDifferenceStr(inDiffDB);
    }

    public void addInst2InstDifferenceEvent(ROXDifferenceFoundEvent in) {
        Difference difference = in.getDifference();
        DifferenceID diffID = in.getDifferenceID();
        int diffSize = DiffResultsObject.getDiffSize(in);
        ResultsTreeRoot hostNode = (ResultsTreeRoot)this.hostRoots.get(ROOT_NODE);
        ResultsTreeNode currDir = hostNode.getRoot();
        currDir.addDifferenceCount(diffSize);
        IIDifferencePath iidp = new IIDifferencePath();
        iidp.inflate(in.getDifferencePath());
        String filePath = com.raplix.util.Util.convertToNetworkFileSeparators(iidp.getFilePath());
        this.addDifferenceToTree(filePath, difference, diffID, currDir, diffSize);
    }

    public void addModel2ModelDifferenceEvent(ROXDifferenceFoundEvent in) {
        DifferenceID diffID = in.getDifferenceID();
        String label = this.differenceToPath(in.getDifference());
        this.addNewModel2ModelDifference(label, diffID);
    }

    public void addModel2InstDifferenceEvent(ROXDifferenceFoundEvent in) {
        Difference difference = in.getDifference();
        DifferenceID diffID = in.getDifferenceID();
        int diffSize = DiffResultsObject.getDiffSize(in);
        ResultsTreeRoot hostNode = (ResultsTreeRoot)this.hostRoots.get(ROOT_NODE);
        ResultsTreeNode currDir = hostNode.getRoot();
        currDir.addDifferenceCount(diffSize);
        MIDifferencePath midp = new MIDifferencePath();
        midp.inflate(in.getDifferencePath());
        currDir = currDir.getSubDir(midp.getHostName() + ":" + " ", true);
        currDir.addDifferenceCount(diffSize);
        currDir.setType("host");
        currDir = currDir.getSubDir(COMPONENT_PREFIX + midp.getComponentName() + COMPONENT_SUFFIX + " ", true);
        currDir.addDifferenceCount(diffSize);
        currDir.setType("component");
        String path = midp.getFilePath();
        if (midp.getDisplayName() != null) {
            path = midp.getDisplayName();
        }
        String filePath = com.raplix.util.Util.convertToNetworkFileSeparators(path);
        this.addDifferenceToTree(filePath, difference, diffID, currDir, diffSize);
    }

    protected void addNewModel2ModelDifference(String label, DifferenceID diffID) {
        String hostName = ROOT_NODE;
        ResultsTreeRoot hostNode = (ResultsTreeRoot)this.hostRoots.get(hostName);
        ResultsTreeNode currDir = hostNode.getRoot();
        currDir.addDifferenceCount(1);
        ResultsTreeLeaf file = currDir.getMemberFile(label, true);
        file.addDifference(diffID);
        file.addDifferenceCount(1);
    }

    protected void addDifferenceToTree(String filePath, Difference difference, DifferenceID diffID, ResultsTreeNode currDir, int diffSize) {
        int diffType = difference.getType();
        String dstVal = difference.getDestVal();
        String srcVal = difference.getSourceVal();
        if (diffType == 0 || diffType == 1 || diffType == 9) {
            String diffName = srcVal;
            if (diffName == null) {
                diffName = dstVal;
            }
            filePath = filePath + FILE_SEPARATOR + diffName;
        }
        StringTokenizer st = new StringTokenizer(filePath, FILE_SEPARATOR);
        while (st.hasMoreTokens()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("The current directory is: " + currDir.getName(), this);
            }
            String nextName = st.nextToken();
            if (st.hasMoreTokens()) {
                ResultsTreeNode subDir;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Adding a subdirectory for : " + nextName, this);
                }
                currDir = subDir = currDir.getSubDir(nextName + FILE_SEPARATOR, true);
                currDir.addDifferenceCount(diffSize);
                continue;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Adding a file for : " + nextName, this);
            }
            if (diffType == 1 && !nextName.endsWith(FILE_SEPARATOR)) {
                nextName = nextName + FILE_SEPARATOR;
            }
            ResultsTreeLeaf file = currDir.getMemberFile(nextName, true);
            file.addDifference(diffID);
            file.addDifferenceCount(diffSize);
        }
    }

    public static final int getDiffSize(ROXDifferenceFoundEvent in) {
        int i;
        String[] diffLines;
        String diffString;
        int numDiffs = 1;
        if (in.getDifference().getType() != 6 && in.getDifference().getType() != 8) {
            return numDiffs;
        }
        if (in.getDifference().getType() == 6) {
            diffString = in.getDifference().getSourceVal();
            diffLines = Util.arrayifyByNewline(diffString);
            numDiffs = 0;
            for (i = 0; i < diffLines.length; ++i) {
                if (!Character.isDigit(diffLines[i].charAt(0))) continue;
                ++numDiffs;
            }
        }
        if (in.getDifference().getType() == 8) {
            diffString = in.getDifference().getSourceVal();
            diffLines = Util.arrayifyByNewline(diffString);
            numDiffs = 0;
            for (i = 0; i < diffLines.length; ++i) {
                if (!diffLines[i].startsWith(FC_FIVE_STAR)) continue;
                ++numDiffs;
            }
            numDiffs /= 3;
        }
        return numDiffs;
    }

    public void setPath(String inPath) {
        if (!inPath.endsWith(TREE_SEPARATOR) && !inPath.equals("")) {
            this.setFile(inPath);
            return;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to set path to " + inPath, this);
        }
        StringTokenizer st = new StringTokenizer(inPath, TREE_SEPARATOR);
        ResultsTreeRoot host = (ResultsTreeRoot)this.hostRoots.get(this.mCurrentHost);
        ResultsTreeNode currDir = host.getRoot();
        this.mPath.clear();
        this.mPathTypes.clear();
        while (st.hasMoreTokens()) {
            ResultsTreeNode subDir;
            String nextName = st.nextToken();
            currDir = subDir = currDir.getSubDir(nextName, false);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Adding directory '" + currDir.getName() + "' to the path array", this);
            }
            this.mPath.add(currDir.getName());
            this.mPathTypes.add(currDir.getType());
        }
        this.mCurrentDir = currDir;
        this.setCurrentDifferenceIndex(-1);
    }

    public void setFile(String inPath) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("About to set file to " + inPath, this);
        }
        StringTokenizer st = new StringTokenizer(inPath, TREE_SEPARATOR);
        ResultsTreeRoot host = (ResultsTreeRoot)this.hostRoots.get(this.mCurrentHost);
        ResultsTreeNode currDir = host.getRoot();
        this.mPath.clear();
        this.mPathTypes.clear();
        while (st.hasMoreTokens()) {
            String nextName = st.nextToken();
            if (st.hasMoreTokens()) {
                ResultsTreeNode subDir;
                currDir = subDir = currDir.getSubDir(nextName, false);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Adding directory '" + currDir.getName() + "' to the path array", this);
                }
                this.mPath.add(currDir.getName());
                this.mPathTypes.add(currDir.getType());
                this.setCurrentDifferenceIndex(-1);
                continue;
            }
            this.setCurrentDifferenceIndex(currDir.getMemberFileIndex(nextName));
        }
        this.mCurrentDir = currDir;
    }

    private void combineNodes(ResultsTreeNode parent, ResultsTreeNode current) {
        String[] subDirs = current.getSubDirNames();
        String[] subFiles = current.getMemberFileNames();
        if (subDirs.length == 1 && subFiles.length == 0) {
            int i;
            ResultsTreeNode child = current.getSubDir(subDirs[0], false);
            String childName = child.getName();
            String[] childSubDirs = child.getSubDirNames();
            String[] childSubFiles = child.getMemberFileNames();
            parent.removeSubDirectory(current.getName());
            String newCurrentName = current.getName() + childName;
            current.setName(newCurrentName);
            parent.addSubDirectory(current);
            current.setType(child.getType());
            current.removeSubDirectory(childName);
            for (i = 0; i < childSubDirs.length; ++i) {
                current.addSubDirectory(child.getSubDir(childSubDirs[i], false));
            }
            for (i = 0; i < childSubFiles.length; ++i) {
                current.addMemberFile(child.getMemberFile(childSubFiles[i], false));
            }
            current.setDifferenceCount(child.getDifferencesCount());
            this.combineNodes(parent, current);
        } else if (subDirs.length > 0) {
            for (int i = 0; i < subDirs.length; ++i) {
                this.combineNodes(current, current.getSubDir(subDirs[i], false));
            }
        }
    }

    public void treeWriter(String outputPrefix, ResultsTreeNode current) {
        if (Logger.isDebugEnabled(this)) {
            int i;
            String[] subDirs = current.getSubDirNames();
            String[] files = current.getMemberFileNames();
            String location = outputPrefix + "+" + current.getName();
            Logger.debug(location + COMPONENT_PREFIX + current.getDifferencesCount() + COMPONENT_SUFFIX, this);
            for (i = 0; i < files.length; ++i) {
                Logger.debug(location + " (" + current.getMemberFile(files[i], false).getName() + ")", this);
            }
            for (i = 0; i < subDirs.length; ++i) {
                this.treeWriter(location, current.getSubDir(subDirs[i], false));
            }
        }
    }

    public void setPathOnLoad(ResultsTreeRoot inRootHostNode) {
        ResultsTreeNode currentNode = inRootHostNode.getRoot();
        String[] subDirNames = currentNode.getSubDirNames();
        String[] fileNames = currentNode.getMemberFileNames();
        int currentNodeChildrenCount = subDirNames.length;
        int currentNodeFileNamesCount = fileNames.length;
        int combineCount = currentNodeChildrenCount + currentNodeFileNamesCount;
        this.mPath.clear();
        this.mPathTypes.clear();
        while (combineCount == 1) {
            if (currentNodeFileNamesCount > 0) {
                this.setCurrentDifferenceIndex(currentNode.getMemberFileIndex(fileNames[0]));
                combineCount = -1;
                continue;
            }
            currentNode = currentNode.getSubDir(subDirNames[0], false);
            subDirNames = currentNode.getSubDirNames();
            fileNames = currentNode.getMemberFileNames();
            currentNodeChildrenCount = subDirNames.length;
            currentNodeFileNamesCount = fileNames.length;
            combineCount = currentNodeChildrenCount + currentNodeFileNamesCount;
            this.mPath.add(currentNode.getName());
            this.mPathTypes.add(currentNode.getType());
            this.setCurrentDifferenceIndex(-1);
        }
        this.mCurrentDir = currentNode;
    }

    public void setCurrentDifferenceIndex(int inIndex) {
        this.mCurrentDifferenceIndex = inIndex;
    }

    public void setCurrentDifferenceStr(DifferenceDBInterface diffDB) {
        if (this.getCurrentDifferenceIndex() == -1) {
            this.mCurrentDifferenceStr = null;
            return;
        }
        this.mCurrentDifferenceStr = this.getStringOfCurrentDifference(diffDB, this.getCurrentDifferenceIndex());
    }

    public void setAllCurrentDifferences(DifferenceDBInterface diffDB) {
        int numFiles = this.mCurrentDir.getMemberFileNames().length;
        this.mAllCurrentDifferences = new String[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            this.mAllCurrentDifferences[i] = this.getStringOfCurrentDifference(diffDB, i);
        }
    }

    private String getStringOfCurrentDifference(DifferenceDBInterface diffDB, int index) {
        Vector diffIDArr = this.mCurrentDir.getCurrentDifference(index);
        if (diffIDArr != null) {
            DifferenceID[] diffIDs = diffIDArr.toArray(new DifferenceID[0]);
            try {
                StringBuffer buffer = new StringBuffer();
                Difference[] diffArray = diffDB.getDifferences(diffIDs);
                for (int i = 0; i < diffArray.length; ++i) {
                    buffer.append(this.differenceToString(diffArray[i]));
                }
                return buffer.toString();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public String[] getAllDifferencePaths() {
        return this.mAllDifferencePaths;
    }

    public int[] getAllDifferenceSizes() {
        return this.mAllDifferenceSizes;
    }

    public int getTotalDifferences() {
        return this.mTotalDifferences;
    }

    public void setStyle(String inStyle) {
        this.mDiffStyle = inStyle;
    }

    private String differenceToString(Difference d) {
        int mType = d.getType();
        String mIdentifier = d.getIdentifier();
        String mSourceVal = d.getSourceVal();
        String mDestVal = d.getDestVal();
        int mSourceOrder = d.getSourceOrder();
        int mDestOrder = d.getDestOrder();
        switch (mType) {
            case 400: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("module not loaded", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("module not loaded", mDestVal, "");
            }
            case 401: {
                return DiffResultsObject.complexDuo("module locations differ", mSourceVal, mDestVal);
            }
            case 402: {
                if (mDestVal != null) {
                    return DiffResultsObject.complexDuo("directive missing", mDestVal, "");
                }
                return DiffResultsObject.complexDuo("directive missing", "", mSourceVal);
            }
            case 403: {
                return DiffResultsObject.complexDuo("directive mismatch", mSourceVal, mDestVal);
            }
            case 404: {
                if (mDestVal != null) {
                    return DiffResultsObject.complexDuo("configuration group missing", mDestVal, "");
                }
                return DiffResultsObject.complexDuo("configuration group missing", "", mSourceVal);
            }
            case 405: {
                if (mDestVal != null) {
                    return DiffResultsObject.complexDuo("group directive missing", mDestVal, "");
                }
                return DiffResultsObject.complexDuo("group directive missing", "", mSourceVal);
            }
            case 406: {
                return DiffResultsObject.complexDuo("group directive mismatch", mSourceVal, mDestVal);
            }
            case 300: {
                return DiffResultsObject.simpleMonad("files are different lengths");
            }
            case 301: {
                return DiffResultsObject.simpleMonad("file binaries are different. first changed byte: #" + mSourceOrder);
            }
            case 302: {
                return DiffResultsObject.simpleMonad("file lengths and binaries are different. first changed byte: #" + mSourceOrder);
            }
            case 500: {
                if (mSourceVal == null) {
                    return DiffResultsObject.complexDuo(mIdentifier + ": missing from source", mDestVal + " (#" + mDestOrder + ")", "");
                }
                if (mDestVal == null) {
                    return DiffResultsObject.complexDuo(mIdentifier + ": missing from destination", "", mSourceVal + " (#" + mSourceOrder + ")");
                }
                return DiffResultsObject.complexDuo(mIdentifier + " differs", mSourceVal + " (#" + mSourceOrder + ")", mDestVal + " (#" + mDestOrder + ")");
            }
            case 0: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("file missing", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("file missing", mDestVal, "");
            }
            case 9: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("symbolic link missing", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("symbolic link missing", mDestVal, "");
            }
            case 1: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("directory missing", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("directory missing", mDestVal, "");
            }
            case 2: {
                return DiffResultsObject.complexDuo("file sizes are different", Integer.toString(mSourceOrder), Integer.toString(mDestOrder));
            }
            case 10: {
                return DiffResultsObject.complexDuo("symbolic links point to different files or directories", mSourceVal, mDestVal);
            }
            case 3: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("component missing", "", this.installedComponentToString(mSourceVal));
                }
                return DiffResultsObject.complexDuo("component missing", this.installedComponentToString(mDestVal), "");
            }
            case 5: {
                return DiffResultsObject.complexDuo("component version mismatch", this.installedComponentToBuild(mSourceVal), this.installedComponentToBuild(mDestVal));
            }
            case 4: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("component missing at source path", "", this.installedComponentToString(mSourceVal));
                }
                return DiffResultsObject.complexDuo("component missing at destination path", this.installedComponentToString(mDestVal), "");
            }
            case 6: {
                return DiffResultsObject.unixDiffFormat(mSourceVal);
            }
            case 8: {
                return DiffResultsObject.winDiffFormat(mSourceVal);
            }
            case 7: {
                return DiffResultsObject.complexDuo("component ownership changed", this.installedComponentToString(mSourceVal), this.installedComponentsToString(mDestVal));
            }
            case 200: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("key missing", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("key missing", mDestVal, "");
            }
            case 201: {
                if (mSourceVal != null) {
                    return DiffResultsObject.complexDuo("missing values for key", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo("missing values for key", mDestVal, "");
            }
            case 202: {
                return DiffResultsObject.simpleMonad("value type mismatch (String vs. List) on key: " + mSourceVal);
            }
            case 203: {
                return DiffResultsObject.complexDuo("value mismatch", mSourceVal, mDestVal);
            }
            case 600: {
                if (mSourceVal == null) {
                    return DiffResultsObject.complexDuo(mIdentifier + ": missing from source", mDestVal, "");
                }
                if (mDestVal == null) {
                    return DiffResultsObject.complexDuo(mIdentifier + ": missing from destination", "", mSourceVal);
                }
                return DiffResultsObject.complexDuo(mIdentifier + " differs", mSourceVal, mDestVal);
            }
            case 100: {
                if (mDestVal != null) {
                    return DiffResultsObject.complexDuo("attribute missing", mDestVal, "");
                }
                return DiffResultsObject.complexDuo("attribute missing", "", mSourceVal);
            }
            case 101: {
                return DiffResultsObject.complexDuo("attribute mismatch", mSourceVal, mDestVal);
            }
            case 102: {
                if (mDestVal != null) {
                    return DiffResultsObject.complexDuo("node missing", mDestVal, "");
                }
                return DiffResultsObject.complexDuo("node missing", "", mSourceVal);
            }
            case 103: {
                return DiffResultsObject.complexDuo("different node names", mSourceVal, mDestVal);
            }
            case 104: {
                return DiffResultsObject.complexDuo("different node types", mSourceVal, mDestVal);
            }
            case 105: {
                return DiffResultsObject.complexDuo("different node values", mSourceVal, mDestVal);
            }
        }
        throw new IllegalArgumentException("Invalid type: " + mType);
    }

    protected static String simpleMonad(String header) {
        return "<tr><td class=\"tblCompItemDif\" valign=\"top\" align=\"right\">&nbsp;</td><td class=\"tblRowCompDif\" valign=\"top\" colspan=\"2\">" + header + DETAIL_ROW_END;
    }

    protected static String complexDuo(String name, String left, String right) {
        return DETAIL_ROW_START + name + DETAIL_ROW_SEP_LEFT + left + DETAIL_ROW_SEP_RIGHT + right + DETAIL_ROW_END;
    }

    protected static String unixDiffFormat(String diffString) {
        String[] diffLines = Util.arrayifyByNewline(diffString);
        StringBuffer output = new StringBuffer();
        String diffSummary = null;
        StringBuffer leftDiff = new StringBuffer();
        StringBuffer rightDiff = new StringBuffer();
        for (int i = 0; i < diffLines.length; ++i) {
            String tmp;
            if (Character.isDigit(diffLines[i].charAt(0))) {
                if (diffSummary != null) {
                    output.append(DiffResultsObject.complexDuo(diffSummary, leftDiff.toString(), rightDiff.toString()));
                }
                leftDiff = new StringBuffer();
                rightDiff = new StringBuffer();
                diffSummary = DiffResultsObject.unixEnglishSummary(diffLines[i]);
                continue;
            }
            if (diffLines[i].charAt(0) == '>') {
                tmp = diffLines[i].substring(2);
                if (DiffResultsObject.containsOnlyWhitespace(tmp)) {
                    tmp = DiffResultsObject.replaceWhitespace(tmp);
                }
                rightDiff.append(Util.escapeHTML(tmp));
                rightDiff.append(LINE_BREAK);
                continue;
            }
            if (diffLines[i].charAt(0) != '<') continue;
            tmp = diffLines[i].substring(2);
            if (DiffResultsObject.containsOnlyWhitespace(tmp)) {
                tmp = DiffResultsObject.replaceWhitespace(tmp);
            }
            leftDiff.append(Util.escapeHTML(tmp));
            leftDiff.append(LINE_BREAK);
        }
        if (diffSummary != null) {
            output.append(DiffResultsObject.complexDuo(diffSummary, leftDiff.toString(), rightDiff.toString()));
        }
        return output.toString();
    }

    private static String unixEnglishSummary(String summaryLine) {
        StringBuffer english = new StringBuffer();
        int typeOfDiff = -1;
        int commaPresent = -1;
        String firstPart = "";
        String secondPart = "";
        String firstNum = "";
        String secondNum = "";
        boolean plural = false;
        typeOfDiff = summaryLine.indexOf(DIFF_A);
        if (typeOfDiff != -1) {
            firstPart = summaryLine.substring(0, typeOfDiff);
            if ((commaPresent = (secondPart = summaryLine.substring(++typeOfDiff)).indexOf(",")) != -1) {
                firstNum = secondPart.substring(0, commaPresent);
                secondNum = secondPart.substring(++commaPresent);
                plural = true;
            } else {
                firstNum = secondPart;
                plural = false;
            }
            english.append(LABEL_COMPARISON_LINE);
            if (plural) {
                english.append("s");
            }
            english.append(" ");
            english.append(firstNum);
            if (plural) {
                english.append(" - ");
                english.append(secondNum);
            }
            english.append(LINE_BREAK);
            english.append(LABEL_ADDED_AT);
            english.append(LINE_BREAK);
            english.append(LABEL_REFERENCE_LINE);
            english.append(" ");
            english.append(firstPart);
        }
        if ((typeOfDiff = summaryLine.indexOf(DIFF_C)) != -1) {
            firstPart = summaryLine.substring(0, typeOfDiff);
            secondPart = summaryLine.substring(++typeOfDiff);
            commaPresent = firstPart.indexOf(",");
            if (commaPresent != -1) {
                firstNum = firstPart.substring(0, commaPresent);
                secondNum = firstPart.substring(++commaPresent);
                plural = true;
            } else {
                firstNum = firstPart;
                plural = false;
            }
            english.append(LABEL_REFERENCE_LINE);
            if (plural) {
                english.append("s");
            }
            english.append(" ");
            english.append(firstNum);
            if (plural) {
                english.append(" - ");
                english.append(secondNum);
            }
            english.append(LINE_BREAK);
            english.append(LABEL_CHANGED_TO);
            firstNum = "";
            secondNum = "";
            commaPresent = -1;
            plural = false;
            commaPresent = secondPart.indexOf(",");
            if (commaPresent != -1) {
                firstNum = secondPart.substring(0, commaPresent);
                secondNum = secondPart.substring(++commaPresent);
                plural = true;
            } else {
                firstNum = secondPart;
                plural = false;
            }
            english.append(LINE_BREAK);
            english.append(LABEL_COMPARISON_LINE);
            if (plural) {
                english.append("s");
            }
            english.append(" ");
            english.append(firstNum);
            if (plural) {
                english.append(" - ");
                english.append(secondNum);
            }
        }
        if ((typeOfDiff = summaryLine.indexOf(DIFF_D)) != -1) {
            firstPart = summaryLine.substring(0, typeOfDiff);
            commaPresent = firstPart.indexOf(",");
            if (commaPresent != -1) {
                firstNum = firstPart.substring(0, commaPresent);
                secondNum = firstPart.substring(++commaPresent);
                plural = true;
            } else {
                firstNum = firstPart;
                plural = false;
            }
            english.append(LABEL_REFERENCE_LINE);
            if (plural) {
                english.append("s");
            }
            english.append(" ");
            english.append(firstNum);
            if (plural) {
                english.append(" - ");
                english.append(secondNum);
            }
            english.append(LINE_BREAK);
            english.append(LABEL_DELETED);
        }
        return LABEL_FILE_CONTENTS + LINE_BREAK + english.toString();
    }

    protected static String winDiffFormat(String diffString) {
        String[] diffLines = Util.arrayifyByNewline(diffString);
        StringBuffer output = new StringBuffer();
        StringBuffer leftDiff = new StringBuffer();
        StringBuffer rightDiff = new StringBuffer();
        int lineCount = 0;
        boolean increment = false;
        for (int i = 0; i < diffLines.length; ++i) {
            int colonIndex;
            String prefix;
            String tmp;
            if (diffLines[i].startsWith(FC_FIVE_STAR)) {
                ++lineCount;
                increment = true;
            } else {
                increment = false;
            }
            if (lineCount == 1 && !increment) {
                tmp = diffLines[i];
                prefix = "";
                colonIndex = tmp.indexOf(":");
                if (colonIndex != -1) {
                    prefix = tmp.substring(0, ++colonIndex);
                    tmp = tmp.substring(++colonIndex);
                }
                tmp = DiffResultsObject.containsOnlyWhitespace(tmp) ? prefix + DiffResultsObject.replaceWhitespace(tmp) : diffLines[i];
                leftDiff.append(Util.escapeHTML(tmp));
                leftDiff.append(LINE_BREAK);
            }
            if (lineCount == 2 && !increment) {
                tmp = diffLines[i];
                prefix = "";
                colonIndex = tmp.indexOf(":");
                if (colonIndex != -1) {
                    prefix = tmp.substring(0, ++colonIndex);
                    tmp = tmp.substring(++colonIndex);
                } else {
                    tmp = diffLines[i];
                }
                if (DiffResultsObject.containsOnlyWhitespace(tmp)) {
                    tmp = prefix + DiffResultsObject.replaceWhitespace(tmp);
                }
                rightDiff.append(Util.escapeHTML(diffLines[i]));
                rightDiff.append(LINE_BREAK);
            }
            if (lineCount != 3 || increment) continue;
            output.append(DiffResultsObject.complexDuo(LABEL_FILE_CONTENTS + LINE_BREAK + LABEL_LINES_CHANGED, leftDiff.toString(), rightDiff.toString()));
            leftDiff = new StringBuffer();
            rightDiff = new StringBuffer();
            lineCount = 0;
        }
        return output.toString();
    }

    private static boolean containsOnlyWhitespace(String in) {
        String temp = in;
        return temp.trim().length() < 1;
    }

    private static String replaceWhitespace(String in) {
        in = Replace.replace(in, '\t', LABEL_TAB);
        in = Replace.replace(in, '\n', LABEL_NEWLINE);
        in = Replace.replace(in, '\r', LABEL_CARRIAGE_RETURN);
        in = Replace.replace(in, '\f', LABEL_LINEFEED);
        return in;
    }

    private String installedComponentToString(String icID) {
        Component c;
        InstalledComponent ic;
        try {
            ic = new InstalledComponentID(icID).getByIDQuery().select();
            c = ic.getComponentID().getByIDQuery().select();
        }
        catch (RaplixException e) {
            return "n/a";
        }
        return Util.standardLink("/ComponentDetails?mode=details&id=" + ic.getComponentID().toString(), "Show this component", c.getName() + " (" + ic.getInstallPath() + ")");
    }

    private String installedComponentsToString(String icIDs) {
        StringBuffer linkBuf = new StringBuffer("");
        StringTokenizer st = new StringTokenizer(icIDs, ",");
        while (st.hasMoreTokens()) {
            String icID = st.nextToken();
            linkBuf.append(this.installedComponentToString(icID));
            if (!st.hasMoreTokens()) continue;
            linkBuf.append(" ");
        }
        return linkBuf.toString();
    }

    private String installedComponentToBuild(String icID) {
        Component c;
        try {
            InstalledComponent ic = new InstalledComponentID(icID).getByIDQuery().select();
            c = ic.getComponentID().getByIDQuery().select();
        }
        catch (RaplixException e) {
            return "n/a";
        }
        return "" + c.getVersionNumber().getAsString();
    }

    public String differenceToPath(Difference d) {
        int mType = d.getType();
        String mSourceVal = d.getSourceVal();
        String mDestVal = d.getDestVal();
        switch (mType) {
            case 3: 
            case 4: 
            case 5: {
                if (mSourceVal != null) {
                    return this.installedComponentToString(mSourceVal);
                }
                return this.installedComponentToString(mDestVal);
            }
        }
        return "host";
    }

    class ResultsTreeLeaf {
        private String mName;
        private Vector mDifferences;
        private int mDifferencesCount;

        public ResultsTreeLeaf(String name) {
            this.mName = name;
            this.mDifferences = new Vector();
        }

        public Vector getDifferencesVector() {
            return this.mDifferences;
        }

        public void addDifference(Object in) {
            this.mDifferences.add(in);
        }

        public int getDifferencesCount() {
            return this.mDifferencesCount;
        }

        public void addDifferenceCount() {
            ++this.mDifferencesCount;
        }

        public void addDifferenceCount(int size) {
            this.mDifferencesCount += size;
        }

        public String getName() {
            return this.mName;
        }
    }

    class ResultsTreeNode {
        private String mName;
        private String mType = "filesystem";
        private Hashtable mSubDirectories;
        private Hashtable mMemberFiles;
        private int mDifferencesCount;

        public boolean equals(Object in) {
            return in instanceof ResultsTreeNode && ((ResultsTreeNode)in).mName.equals(this.mName);
        }

        public ResultsTreeNode(String name) {
            this(name, "filesystem");
        }

        public ResultsTreeNode(String name, String type) {
            this.mName = name;
            this.mType = type;
            this.mSubDirectories = new Hashtable();
            this.mMemberFiles = new Hashtable();
        }

        public String getType() {
            return this.mType;
        }

        public void setType(String inType) {
            this.mType = inType;
        }

        public String getName() {
            return this.mName;
        }

        public boolean addSubDirectory(String name) {
            ResultsTreeNode node = new ResultsTreeNode(name);
            if (this.mSubDirectories.containsKey(name)) {
                return false;
            }
            this.mSubDirectories.put(name, node);
            return true;
        }

        public void addSubDirectory(ResultsTreeNode node) {
            this.mSubDirectories.put(node.getName(), node);
        }

        public void removeSubDirectory(String inName) {
            this.mSubDirectories.remove(inName);
        }

        public boolean addMemberFile(String name) {
            ResultsTreeLeaf file = new ResultsTreeLeaf(name);
            if (this.mMemberFiles.containsKey(name)) {
                return false;
            }
            this.mMemberFiles.put(name, file);
            return true;
        }

        public void addMemberFile(ResultsTreeLeaf leaf) {
            this.mMemberFiles.put(leaf.getName(), leaf);
        }

        public ResultsTreeLeaf getMemberFile(String name) {
            return this.getMemberFile(name, true);
        }

        public int getMemberFileIndex(String name) {
            Enumeration names = this.mMemberFiles.keys();
            Vector temp = new Vector();
            int counter = 0;
            while (names.hasMoreElements()) {
                if (((String)names.nextElement()).equals(name)) {
                    return counter;
                }
                ++counter;
            }
            return -1;
        }

        public ResultsTreeLeaf getMemberFile(String name, boolean create) {
            if (this.mMemberFiles.containsKey(name)) {
                return (ResultsTreeLeaf)this.mMemberFiles.get(name);
            }
            if (create && this.addMemberFile(name)) {
                return this.getMemberFile(name, false);
            }
            return null;
        }

        public ResultsTreeNode getSubDir(String name) {
            return this.getSubDir(name, true);
        }

        public ResultsTreeNode getSubDir(String name, boolean create) {
            if (this.mSubDirectories.containsKey(name)) {
                return (ResultsTreeNode)this.mSubDirectories.get(name);
            }
            if (create && this.addSubDirectory(name)) {
                return this.getSubDir(name, false);
            }
            return null;
        }

        public String[] getSubDirNames() {
            Enumeration names = this.mSubDirectories.keys();
            Vector<String> temp = new Vector<String>();
            while (names.hasMoreElements()) {
                temp.add((String)names.nextElement());
            }
            return temp.toArray(new String[0]);
        }

        public String[] getSubDirTypes() {
            Enumeration names = this.mSubDirectories.keys();
            Vector<String> temp = new Vector<String>();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                ResultsTreeNode node = (ResultsTreeNode)this.mSubDirectories.get(key);
                temp.add(node.getType());
            }
            return temp.toArray(new String[0]);
        }

        public String[] getMemberFileNames() {
            Enumeration names = this.mMemberFiles.keys();
            Vector<String> temp = new Vector<String>();
            while (names.hasMoreElements()) {
                temp.add((String)names.nextElement());
            }
            return temp.toArray(new String[0]);
        }

        public Vector getCurrentDifference(int index) {
            String[] fileNames = this.getMemberFileNames();
            String correctFileName = fileNames[index];
            ResultsTreeLeaf leaf = (ResultsTreeLeaf)this.mMemberFiles.get(correctFileName);
            if (leaf != null) {
                return leaf.getDifferencesVector();
            }
            return null;
        }

        public int getDifferencesCount() {
            return this.mDifferencesCount;
        }

        public void setDifferenceCount(int inCount) {
            this.mDifferencesCount = inCount;
        }

        public void addDifferenceCount() {
            ++this.mDifferencesCount;
        }

        public void addDifferenceCount(int size) {
            this.mDifferencesCount += size;
        }

        public String[] getSubDirectoryDifferenceCounts() {
            Enumeration names = this.mSubDirectories.keys();
            Vector<String> temp = new Vector<String>();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                ResultsTreeNode node = (ResultsTreeNode)this.mSubDirectories.get(key);
                temp.add("" + node.getDifferencesCount());
            }
            return temp.toArray(new String[0]);
        }

        public String[] getFilenamesDifferenceCounts() {
            Enumeration names = this.mMemberFiles.keys();
            Vector<String> temp = new Vector<String>();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                ResultsTreeLeaf leaf = (ResultsTreeLeaf)this.mMemberFiles.get(key);
                temp.add("" + leaf.getDifferencesCount());
            }
            return temp.toArray(new String[0]);
        }

        public void setName(String name) {
            this.mName = name;
        }
    }

    class ResultsTreeRoot {
        private String mName;
        private ResultsTreeNode mRoot;

        public ResultsTreeRoot(String name) {
            this.mName = name;
            this.mRoot = new ResultsTreeNode("ROOT");
        }

        public ResultsTreeNode getRoot() {
            return this.mRoot;
        }
    }
}

