/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.custom;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ControlBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.componentdb.UninstallBlock;
import com.raplix.rolloutexpress.systemmodel.folderdb.CachedFolderTreeNode;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SingleFolderQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSearchQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostSearch;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginNotificationException;
import com.raplix.rolloutexpress.ui.web.UriUtil;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.compx.types.ComponentTypesListBean;
import com.raplix.util.logger.Logger;
import java.net.MalformedURLException;
import java.net.URL;

public class PluginUITransformUtil {
    private static final String MSG_PLUGIN_LOOKUP_HOST_SEARCH_ERROR = "gui.plugin.lookup.host.search.error";
    private static final String MSG_PLUGIN_LOOKUP_HOST_SEARCH_NOT_FROM_PLUGIN_ERROR = "gui.plugin.lookup.host.search.not.from.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_HOST_SEARCH_NOT_FROM_THIS_PLUGIN_ERROR = "gui.plugin.lookup.host.search.not.from.this.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_PLAN_PATH_ERROR = "gui.plugin.lookup.plan.path.error";
    private static final String MSG_PLUGIN_LOOKUP_PLAN_ERROR = "gui.plugin.lookup.plan.error";
    private static final String MSG_PLUGIN_LOOKUP_PLAN_NOT_FROM_PLUGIN_ERROR = "gui.plugin.lookup.plan.not.from.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_PLAN_NOT_FROM_THIS_PLUGIN_ERROR = "gui.plugin.lookup.plan.not.from.this.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_PATH_ERROR = "gui.plugin.lookup.comp.path.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_ERROR = "gui.plugin.lookup.comp.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_NOT_FROM_PLUGIN_ERROR = "gui.plugin.lookup.comp.not.from.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_NOT_FROM_THIS_PLUGIN_ERROR = "gui.plugin.lookup.comp.not.from.this.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_TYPE_ERROR = "gui.plugin.lookup.comp.type.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_TYPE_NOT_FROM_PLUGIN_ERROR = "gui.plugin.lookup.comp.type.not.from.plugin.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_TYPE_HIDDEN_ERROR = "gui.plugin.lookup.comp.type.hidden.error";
    private static final String MSG_PLUGIN_LOOKUP_COMP_TYPE_NOT_FROM_THIS_PLUGIN_ERROR = "gui.plugin.lookup.comp.type.not.from.this.plugin.error";
    private static final String MSG_PLUGIN_URL_MALFORMED_ERROR = "gui.plugin.url.malformed.error";
    private static final String MSG_PLUGIN_LOOKUP_FOLD_PATH_ERROR = "gui.plugin.lookup.fold.path.error";
    private static final String MSG_PLUGIN_LOOKUP_FOLD_NOT_FROM_THIS_PLUGIN_ERROR = "gui.plugin.lookup.fold.not.from.this.plugin.error";
    private static final String MSG_PLUGIN_COMP_PROCEDURE_TYPE_UNKNOWN = "gui.plugin.comp.procedure.type.unknown";
    private static final String MSG_PLUGIN_COMP_PROCEDURE_NOT_IN_COMP = "gui.plugin.comp.procedure.not.in.component";
    private static ThreadLocal myThreadLocal = new ThreadLocal();

    static ThreadLocal getThreadLocal() {
        return myThreadLocal;
    }

    private static PluginID getPluginID() {
        return (PluginID)myThreadLocal.get();
    }

    public static String getHostSearchID(String searchName) throws Exception {
        PluginID pid;
        SummaryHostSearch shs;
        try {
            SingleHostSearchQuery shsq = SingleHostSearchQuery.byName(searchName);
            shs = shsq.selectSummaryView();
            pid = shs.getPluginID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the host search", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_HOST_SEARCH_ERROR, searchName));
        }
        if (pid == null) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified host search is not from a plugin.", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_HOST_SEARCH_NOT_FROM_PLUGIN_ERROR, searchName));
        }
        Plugin p = PluginUITransformUtil.getPluginID().getByIDQuery().select();
        if (!pid.equals(PluginUITransformUtil.getPluginID()) && !p.getDependencies().contains(pid)) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified host search does not meet the pluginUI specification", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_HOST_SEARCH_NOT_FROM_THIS_PLUGIN_ERROR, searchName));
        }
        return shs.getID().toString();
    }

    public static String validateURL(String url) throws Exception {
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown validating URL", mue, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_URL_MALFORMED_ERROR, url));
        }
        return url;
    }

    public static String getLatestPlanID(String planPath, String planName) throws Exception {
        PluginID pid;
        SummaryExecutionPlan sp;
        FolderID folderID;
        try {
            SingleFolderQuery sfq = SingleFolderQuery.byPath(planPath);
            SummaryFolder sf = sfq.selectSummaryView();
            folderID = sf.getID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the Plan path", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_PLAN_PATH_ERROR, planPath));
        }
        try {
            SingleExecutionPlanQuery spq = SingleExecutionPlanQuery.byName(folderID, planName, null);
            sp = spq.selectSummaryView();
            pid = sp.getPluginID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the Plan", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_PLAN_ERROR, planPath + planName));
        }
        if (pid == null) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified plan is not from a plugin.", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_PLAN_NOT_FROM_PLUGIN_ERROR, planPath + planName));
        }
        Plugin p = PluginUITransformUtil.getPluginID().getByIDQuery().select();
        if (!pid.equals(PluginUITransformUtil.getPluginID()) && !p.getDependencies().contains(pid)) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified plan does not meet the pluginUI specification", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_PLAN_NOT_FROM_THIS_PLUGIN_ERROR, planPath + planName));
        }
        return sp.getID().toString();
    }

    public static String getLatestCompID(String compPath, String compName) throws Exception {
        PluginID pid;
        SummaryComponent sc;
        FolderID folderID;
        try {
            SingleFolderQuery sfq = SingleFolderQuery.byPath(compPath);
            SummaryFolder sf = sfq.selectSummaryView();
            folderID = sf.getID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the Component path", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_PATH_ERROR, compPath));
        }
        try {
            SingleComponentQuery scq = SingleComponentQuery.byName(folderID, compName, null);
            sc = scq.selectSummaryView();
            pid = sc.getPluginID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the Component", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_ERROR, compPath + compName));
        }
        if (pid == null) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component is not from a plugin.", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_NOT_FROM_PLUGIN_ERROR, compPath + compName));
        }
        Plugin p = PluginUITransformUtil.getPluginID().getByIDQuery().select();
        if (!pid.equals(PluginUITransformUtil.getPluginID()) && !p.getDependencies().contains(pid)) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component does not meet the pluginUI specification", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_NOT_FROM_THIS_PLUGIN_ERROR, compPath + compName));
        }
        return sc.getID().toString();
    }

    public static String getCompTypeName(String compTypeName) throws Exception {
        ComponentTypeRef ctr;
        try {
            SingleComponentTypeRefQuery sctrq = SingleComponentTypeRefQuery.byName(compTypeName);
            ctr = sctrq.selectReadOnlyView();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the Component Type", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_TYPE_ERROR, compTypeName));
        }
        PluginID pid = ctr.getPluginID();
        if (pid == null) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component type is not from a plugin.", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_TYPE_NOT_FROM_PLUGIN_ERROR, compTypeName));
        }
        for (int i = 0; i < ComponentTypesListBean.HIDDEN_GROUPS.length; ++i) {
            if (!ctr.getGroup().equals(ComponentTypesListBean.HIDDEN_GROUPS[i])) continue;
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The component type's group is hidden.", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_TYPE_HIDDEN_ERROR, compTypeName));
        }
        Plugin p = PluginUITransformUtil.getPluginID().getByIDQuery().select();
        if (!pid.equals(PluginUITransformUtil.getPluginID()) && !p.getDependencies().contains(pid)) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component type does not meet the pluginUI specification", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_COMP_TYPE_NOT_FROM_THIS_PLUGIN_ERROR, compTypeName));
        }
        return Util.encodeURL(ctr.getName());
    }

    public static String getLatestFolderID(String path) throws Exception {
        PluginID foldersPluginID;
        FolderID folderID;
        SummaryFolder sf = null;
        try {
            SingleFolderQuery sfq = SingleFolderQuery.byPath(path);
            sf = sfq.selectSummaryView();
            folderID = sf.getID();
            foldersPluginID = sf.getPluginID();
        }
        catch (Exception e) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("Exception thrown looking up the folder path", e, PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_FOLD_PATH_ERROR, path));
        }
        boolean acceptableFolder = false;
        if (foldersPluginID != null) {
            Plugin importingPlugin = PluginUITransformUtil.getPluginID().getByIDQuery().select();
            if (foldersPluginID.equals(PluginUITransformUtil.getPluginID()) || importingPlugin.getDependencies().contains(foldersPluginID)) {
                acceptableFolder = true;
            }
        }
        if (!acceptableFolder) {
            CachedFolderTreeNode cftree = new CachedFolderTreeNode(sf);
            cftree.retrieveChildren();
            acceptableFolder = PluginUITransformUtil.recursiveFolderCheck(cftree);
        }
        if (!acceptableFolder) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified folder does not meet the pluginUI specification", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_LOOKUP_FOLD_NOT_FROM_THIS_PLUGIN_ERROR, path));
        }
        return folderID.toString();
    }

    private static boolean recursiveFolderCheck(CachedFolderTreeNode parent) throws Exception {
        FolderID folderID = parent.getFolder().getID();
        PluginID foldersPluginID = parent.getFolder().getPluginID();
        if (foldersPluginID != null) {
            Plugin importingPlugin = PluginUITransformUtil.getPluginID().getByIDQuery().select();
            if (foldersPluginID.equals(PluginUITransformUtil.getPluginID()) || importingPlugin.getDependencies().contains(foldersPluginID)) {
                return true;
            }
        }
        CachedFolderTreeNode[] children = parent.getChildren();
        for (int ndx = 0; ndx < children.length; ++ndx) {
            if (!PluginUITransformUtil.recursiveFolderCheck(children[ndx])) continue;
            return true;
        }
        return false;
    }

    public static String getCompProcedureRunURL(String compPath, String compName, String procedureName, String procedureType) throws Exception {
        String componentID = PluginUITransformUtil.getLatestCompID(compPath, compName);
        ComponentID cid = new ComponentID(componentID);
        Component comp = cid.getByIDQuery().select();
        String URI2 = null;
        if (procedureType.equals("INSTALL")) {
            InstallBlock block = comp.resolveInstallBlock(procedureName, CallSpec.PUBLIC);
            if (block != null) {
                URI2 = UriUtil.runInstallURI(componentID, block.getName(), "install");
            }
        } else if (procedureType.equals("CONTROL")) {
            ControlBlock block = comp.resolveControlBlock(procedureName, CallSpec.PUBLIC);
            if (block != null) {
                URI2 = UriUtil.runUninstallOrCallURI(componentID, block.getName(), "call");
            }
        } else if (procedureType.equals("UNINSTALL")) {
            UninstallBlock block = comp.resolveUninstallBlock(procedureName, CallSpec.PUBLIC);
            if (block != null) {
                URI2 = UriUtil.runUninstallOrCallURI(componentID, block.getName(), "uninstall");
            }
        } else {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component procedure type is unknown", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_COMP_PROCEDURE_TYPE_UNKNOWN, procedureType));
        }
        if (URI2 == null) {
            if (Logger.isDebugEnabled(PluginUITransformUtil.class)) {
                Logger.debug("The specified component procedure was not found in the specifiec component", PluginUITransformUtil.class);
            }
            throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_COMP_PROCEDURE_NOT_IN_COMP, procedureType, procedureName, comp.getFullName()));
        }
        return URI2;
    }
}

