/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.custom;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.resource.util.ResourceStringUtils;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginEventListener;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginNotificationException;
import com.raplix.rolloutexpress.systemmodel.plugindb.SinglePluginQuery;
import com.raplix.rolloutexpress.ui.web.WebServerSubsystem;
import com.raplix.rolloutexpress.ui.web.custom.PluginUITransformUtil;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.file.FileUtil;
import com.raplix.util.file.TransformFactory;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PluginEventsHandler
implements PluginEventListener {
    private static final String MSG_PLUGIN_ERROR = "gui.plugin.transform.error";
    private Application mApp;
    private WebServerSubsystem mWebServerSubsystem;

    public PluginEventsHandler(WebServerSubsystem wss) {
        this(wss.getApplication(), wss);
    }

    public PluginEventsHandler(Application app) {
        this(app, null);
    }

    private PluginEventsHandler(Application app, WebServerSubsystem wss) {
        this.mApp = app;
        this.mWebServerSubsystem = wss;
    }

    private Plugin lookupPlugin(PluginID inPluginID) throws PluginNotificationException {
        Plugin p;
        try {
            SinglePluginQuery spq = inPluginID.getByIDQuery();
            p = spq.select();
        }
        catch (RaplixException re) {
            throw new PluginNotificationException(re);
        }
        return p;
    }

    public void pluginAdded(PluginID inPluginID) throws PluginNotificationException {
        Plugin p = this.lookupPlugin(inPluginID);
        if (p.getMenuItem() != null) {
            String copyPageFrom = ResourceStringUtils.toNativePath(this.mApp.getDataDirAbsPath() + File.separator + p.getCustomPagePath());
            String copyIconFrom = ResourceStringUtils.toNativePath(this.mApp.getDataDirAbsPath() + File.separator + p.getIconPath());
            String tasksSubDir = this.getTasksDir() + File.separator + p.getID().toString();
            String imagesSubDir = this.getTasksDir() + File.separator + "images" + File.separator + p.getID().toString();
            String copyPageToDir = tasksSubDir + File.separator + p.getVersionNumber().getAsString();
            String copyIconToDir = imagesSubDir + File.separator + p.getVersionNumber().getAsString();
            try {
                File pageFile = new File(copyPageFrom);
                File iconFile = new File(copyIconFrom);
                String copyPageTo = copyPageToDir + File.separator + pageFile.getName();
                String copyIconTo = copyIconToDir + File.separator + iconFile.getName();
                FileUtil.ensureDirPresent(tasksSubDir);
                FileUtil.ensureDirPresent(copyPageToDir);
                CopyUtil.copyBinary(copyPageFrom, copyPageTo);
                FileUtil.ensureDirPresent(imagesSubDir);
                FileUtil.ensureDirPresent(copyIconToDir);
                CopyUtil.copyBinary(copyIconFrom, copyIconTo);
            }
            catch (IOException ioe) {
                block9: {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error copying UI files during plug-in add event.", this);
                    }
                    try {
                        FileUtil.ensureDeleted(copyPageToDir);
                        FileUtil.ensureDeleted(copyIconToDir);
                        if (p.getUpdateCount() == 1) {
                            FileUtil.ensureDeleted(tasksSubDir);
                            FileUtil.ensureDeleted(imagesSubDir);
                        }
                    }
                    catch (IOException innerIOE) {
                        if (!Logger.isErrorEnabled(this)) break block9;
                        Logger.error("Error cleaning up copied files.", this);
                    }
                }
                throw new PluginNotificationException(ioe);
            }
            try {
                TransactionManager tm = PersistenceManager.getInstance().getTransactionManager();
                tm.registerTopLevelTransactionListener(new PluginAddedTransactionListener(copyIconToDir, copyPageToDir, p.getUpdateCount(), imagesSubDir, tasksSubDir));
            }
            catch (PersistenceManagerException pme) {
                throw new PluginNotificationException(pme);
            }
        }
    }

    public void pluginDeleted(PluginID inPluginID) throws PluginNotificationException {
        try {
            TransactionManager tm = PersistenceManager.getInstance().getTransactionManager();
            tm.registerTopLevelTransactionListener(new PluginDeletedTransactionListener(inPluginID));
        }
        catch (PersistenceManagerException pme) {
            throw new PluginNotificationException(pme);
        }
    }

    public void pluginEdited(PluginID inPluginID) throws PluginNotificationException {
        this.refreshNavbar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(PluginID inPluginID, InputStream pluginuiIS, OutputStream customPageOS) throws PluginNotificationException {
        if (pluginuiIS != null) {
            ThreadLocal myThreadLocal = PluginUITransformUtil.getThreadLocal();
            try {
                myThreadLocal.set(inPluginID);
                String customPageXSLTPath = this.getTasksDir() + File.separator + "customPage.xsl";
                File customPageXSLTFile = new File(customPageXSLTPath);
                InputStreamReader pluginUI = new InputStreamReader(pluginuiIS);
                try {
                    OutputStreamWriter customPage = new OutputStreamWriter(customPageOS);
                    FileReader customPageXSLTReader = new FileReader(customPageXSLTFile);
                    try {
                        TransformFactory.getTransform("XSLT", customPageXSLTReader).apply(pluginUI, customPage);
                    }
                    finally {
                        customPageXSLTReader.close();
                    }
                }
                catch (IOException ioe) {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("Error transforming pluginUI: ", ioe, this);
                    }
                    throw new PluginNotificationException(new ROXMessage(MSG_PLUGIN_ERROR));
                }
            }
            finally {
                myThreadLocal.set(null);
            }
        }
    }

    private String getTasksDir() {
        return this.mApp.getHomeDirAbsPath() + File.separator + "custom" + File.separator + "tasks";
    }

    private void refreshNavbar() {
        if (this.mWebServerSubsystem != null) {
            this.mWebServerSubsystem.refreshNavbar();
        }
    }

    class PluginDeletedTransactionListener
    implements TopLevelTransactionListener {
        private PluginID mPluginID;

        PluginDeletedTransactionListener(PluginID inPluginID) {
            this.mPluginID = inPluginID;
        }

        public void transactionComplete(boolean isCommitted) throws PostTransactionException {
            if (isCommitted) {
                PluginEventsHandler.this.refreshNavbar();
                String deletePageFrom = PluginEventsHandler.this.getTasksDir() + File.separator + this.mPluginID.toString();
                String deleteIconFrom = PluginEventsHandler.this.getTasksDir() + File.separator + "images" + File.separator + this.mPluginID.toString();
                try {
                    FileUtil.ensureDeleted(deletePageFrom);
                    FileUtil.ensureDeleted(deleteIconFrom);
                }
                catch (Throwable t) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Plugin icon could not be deleted.", this);
                    }
                    throw new PostTransactionException(t);
                }
            }
        }

        public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        }
    }

    class PluginAddedTransactionListener
    implements TopLevelTransactionListener {
        private String mPageDeleteDir;
        private String mIconDeleteDir;
        private int mPluginUpdateCount;
        private String mTaskSubDir;
        private String mImageSubDir;

        PluginAddedTransactionListener(String inIconDeleteDir, String inPageDeleteDir, int pluginUpdateCount, String imageSubDir, String taskSubDir) {
            this.mPageDeleteDir = inPageDeleteDir;
            this.mIconDeleteDir = inIconDeleteDir;
            this.mPluginUpdateCount = pluginUpdateCount;
            this.mTaskSubDir = taskSubDir;
            this.mImageSubDir = imageSubDir;
        }

        public void transactionComplete(boolean isCommitted) throws PostTransactionException {
            if (isCommitted) {
                PluginEventsHandler.this.refreshNavbar();
            } else {
                try {
                    FileUtil.ensureDeleted(this.mPageDeleteDir);
                    FileUtil.ensureDeleted(this.mIconDeleteDir);
                    if (this.mPluginUpdateCount == 1) {
                        FileUtil.ensureDeleted(this.mTaskSubDir);
                        FileUtil.ensureDeleted(this.mImageSubDir);
                    }
                }
                catch (Throwable t) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error occurred cleaning up copied files when transaction not committed.", this);
                    }
                    throw new PostTransactionException(t);
                }
            }
        }

        public void aboutToComplete(boolean isCommitable) throws PreCommitException {
        }
    }
}

