/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.custom;

import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.Util;
import com.raplix.rolloutexpress.ui.web.custom.CustomLink;
import com.raplix.util.string.StringUtil;

public class NavbarNode
extends UITreeNode {
    private static String TRUE = "true";
    private String mPrefix = "";
    private String mSuffix = "";
    private static String sRowSeparator = "<tr>" + StringUtil.LINE_SEPARATOR + "<td class=\"menu\" colspan=\"3\"><img src=\"raplixPouch/spacer.gif\" width=\"30\" height=\"4\"></td>" + StringUtil.LINE_SEPARATOR + "</tr>" + StringUtil.LINE_SEPARATOR;
    CustomLink mCustomLink = null;

    protected String getBranchClosedIcon() {
        return "<img src=\"raplixPouch/expand.gif\" border=\"0\">";
    }

    protected String getBranchOpenIcon() {
        return "<img src=\"raplixPouch/collapse.gif\" border=\"0\">";
    }

    protected String getBranchEmptyIcon() {
        return "<img src=\"raplixPouch/collapse.gif\" border=\"0\">";
    }

    public NavbarNode(UITreeNodeType type) {
        super(type);
    }

    public NavbarNode() {
        this.mType = UITreeNodeType.LEAF;
    }

    void setCustomLink(CustomLink cl) {
        this.mCustomLink = cl;
        StringBuffer sb = new StringBuffer();
        StringBuffer prefix = new StringBuffer();
        if (cl.getDepthAsInt() == 0) {
            this.mType = UITreeNodeType.BRANCH_EMPTY;
            prefix.append("<tr>");
            prefix.append(StringUtil.LINE_SEPARATOR);
            prefix.append("<td class=\"menuHead\">");
            String id = this.uri2id(this.mCustomLink.getUri());
            sb.append("</td>");
            sb.append("<td id=\"");
            sb.append(id);
            sb.append("\" class=\"menuHead\" colspan=\"2\" nowrap title=\"");
            sb.append(Util.escapeJavascript(cl.getRollover()));
            sb.append("\" onMouseOver=\"setStatus('");
            sb.append(Util.escapeJavascript(cl.getRollover()));
            sb.append("'); return setClass(this, menuHighlightHover('");
            sb.append(Util.escapeJavascript(this.mCustomLink.getUri()));
            sb.append("'))\" onMouseOut=\"setStatus(''); return restoreClass(this)\" onClick=\"doClick(this.firstChild); return false;\"><a href=\"");
            sb.append(cl.getUri());
            sb.append("\" target=\"_top\">");
            sb.append(cl.getTitle());
            sb.append("</a></td>");
            sb.append(StringUtil.LINE_SEPARATOR);
            sb.append("</tr>");
            sb.append(StringUtil.LINE_SEPARATOR);
            sb.append("<SCRIPT>menuHighlight('");
            sb.append(id);
            sb.append("', '");
            sb.append(Util.escapeJavascript(this.mCustomLink.getUri()));
            sb.append("')</SCRIPT>");
            sb.append(StringUtil.LINE_SEPARATOR);
        } else {
            prefix.append("<tr>");
            prefix.append(StringUtil.LINE_SEPARATOR);
            prefix.append("<td class=\"menu\">&nbsp;</td>");
            prefix.append("<td class=\"menuSubIcon\">");
            prefix.append("<a href=\"");
            prefix.append(cl.getUri());
            prefix.append("\" target=\"_top\">");
            prefix.append("<img border=\"0\" src=\"");
            prefix.append(cl.getIcon());
            prefix.append("\" title=\"");
            prefix.append(cl.getRollover());
            prefix.append("\" onMouseOver=\"setStatus('");
            prefix.append(cl.getRollover());
            prefix.append("'); return true;\" onMouseOut=\"setStatus(''); return true;\">");
            prefix.append("</a></td>");
            prefix.append(StringUtil.LINE_SEPARATOR);
            sb.append("<SCRIPT>menuLink('");
            sb.append(this.mCustomLink.getUri());
            sb.append("', ");
            StringBuffer restOfTag = new StringBuffer();
            restOfTag.append("nowrap title=\"");
            restOfTag.append(Util.escapeJavascript(cl.getRollover()));
            restOfTag.append("\" onMouseOver=\"setStatus('");
            restOfTag.append(cl.getRollover());
            restOfTag.append("'); return setClass(this, '");
            StringBuffer restOfTag2 = new StringBuffer();
            restOfTag2.append("')\" onMouseOut=\"setStatus(''); return restoreClass(this)\" onClick=\"doClick(this.firstChild); return false\">");
            restOfTag2.append("<a href=\"");
            restOfTag2.append(cl.getUri());
            restOfTag2.append("\" target=\"_top\">");
            restOfTag2.append(cl.getTitle());
            restOfTag2.append("</a></td>");
            sb.append("'");
            sb.append(Util.escapeJavascript(restOfTag.toString()));
            sb.append("', '");
            sb.append(Util.escapeJavascript(restOfTag2.toString()));
            sb.append("')</SCRIPT>");
            sb.append(StringUtil.LINE_SEPARATOR);
            sb.append("</tr>");
            sb.append(StringUtil.LINE_SEPARATOR);
        }
        this.mPrefix = prefix.toString();
        this.mSuffix = sb.toString();
    }

    public String finishRender(StringBuffer sb, String path) {
        if (this.mCustomLink.getDepthAsInt() == 0) {
            sb.insert(0, this.mPrefix);
            if (!path.startsWith(UITree.PATH_ROOT_STRING + UITree.PATH_SEPARATOR_STRING + UITree.PATH_ROOT_STRING)) {
                sb.insert(0, sRowSeparator);
            }
        } else {
            sb = new StringBuffer(this.mPrefix);
        }
        sb.append(this.mSuffix);
        return sb.toString();
    }

    public void finishOpen() {
    }

    public void finishClose() {
    }

    protected String getJavascriptFunction() {
        return "sendNavbarTree";
    }

    public void addChild(UITreeNode node) {
        super.addChild(node);
        if (this.mCustomLink != null) {
            this.mType = this.mCustomLink.getExpanded().toLowerCase().equals(TRUE) ? UITreeNodeType.BRANCH_OPEN : UITreeNodeType.BRANCH_CLOSED;
        }
    }

    private String uri2id(String inSrc) {
        if (inSrc == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer(inSrc.length());
        ret.append("id_");
        for (int i = 0; i < inSrc.length(); ++i) {
            char ch = inSrc.charAt(i);
            if (!(ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '-' || ch == '_' || ch == ':') && ch != '.') continue;
            ret.append(ch);
        }
        return ret.toString();
    }
}

