/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.ui.web.custom;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.systemmodel.plugindb.MultiPluginQuery;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginOrder;
import com.raplix.rolloutexpress.ui.web.UITree;
import com.raplix.rolloutexpress.ui.web.UITreeNode;
import com.raplix.rolloutexpress.ui.web.UITreeNodeType;
import com.raplix.rolloutexpress.ui.web.custom.CustomLink;
import com.raplix.rolloutexpress.ui.web.custom.NavbarNode;
import com.raplix.util.DOMElementEnumeration;
import com.raplix.util.logger.Logger;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomNavbar {
    private Vector mEntries = new Vector();
    private static final String PLUGINS_ELEMENT = "pluginHolder";

    public CustomNavbar(Node node) {
        DOMElementEnumeration e = new DOMElementEnumeration(node);
        while (e.hasMoreElements()) {
            Element currentNode = e.nextElement();
            if (currentNode.getNodeName().equals(PLUGINS_ELEMENT)) {
                this.loadPlugins();
                continue;
            }
            CustomLink cl = new CustomLink(currentNode);
            this.mEntries.add(cl);
        }
    }

    private void loadPlugins() {
        block3: {
            try {
                MultiPluginQuery mpq = MultiPluginQuery.all();
                mpq.setObjectOrder(PluginOrder.BY_MENU_ORDER_ASC);
                Plugin[] pa = mpq.select();
                for (int i = 0; i < pa.length; ++i) {
                    if (pa[i].getMenuItem() == null) continue;
                    CustomLink cl = new CustomLink(pa[i]);
                    this.mEntries.add(cl);
                }
            }
            catch (RaplixException re) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error("There was a problem retrieving the list of plugins", re, this);
            }
        }
    }

    public CustomNavbar() {
    }

    public UITree makeTree() {
        UITree tree = new UITree();
        NavbarNode root = new NavbarNode(UITreeNodeType.BRANCH_OPEN);
        root.setVisible(false);
        tree.setRoot(root);
        NavbarNode lastSection = root;
        for (int i = 0; i < this.mEntries.size(); ++i) {
            CustomLink cl = (CustomLink)this.mEntries.elementAt(i);
            NavbarNode treeNode = new NavbarNode();
            treeNode.setCustomLink(cl);
            if (cl.getDepthAsInt() == 0) {
                root.addChild(treeNode);
                lastSection = treeNode;
                continue;
            }
            lastSection.addChild(treeNode);
        }
        return tree;
    }

    public void syncTrees(UITree oldTree, UITree newTree) {
        UITreeNode oldRootNode = oldTree.getRoot();
        Vector oldRootChildren = oldRootNode.getChildren();
        UITreeNode newRootNode = newTree.getRoot();
        Vector newRootChildren = newRootNode.getChildren();
        for (int i = 0; i < oldRootChildren.size(); ++i) {
            NavbarNode oldNavbarNode = (NavbarNode)oldRootChildren.get(i);
            CustomLink cl = oldNavbarNode.mCustomLink;
            NavbarNode newNavbarNode = (NavbarNode)newRootChildren.get(i);
            UITreeNodeType newType = newNavbarNode.getType();
            if (cl.getDepthAsInt() != 0 || newType.equals(UITreeNodeType.BRANCH_EMPTY)) continue;
            UITreeNodeType type = oldNavbarNode.getType();
            if (type.equals(UITreeNodeType.BRANCH_OPEN)) {
                newNavbarNode.open();
                continue;
            }
            if (!type.equals(UITreeNodeType.BRANCH_CLOSED)) continue;
            newNavbarNode.close();
        }
    }
}

